/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.generator;

import de.destatis.core.connect.Client;
import de.destatis.core.connect.TransferProtocolException;
import de.destatis.core.generator.CsvDataProvider;
import de.destatis.core.generator.DataProvider;
import de.destatis.core.generator.MapDataProvider;
import de.destatis.core.generator.MappingProvider;
import de.destatis.core.generator.SurveyDataDocumentGeneratorException;
import de.destatis.core.generator.generation.DocumentBuilderInterpreter;
import de.destatis.core.map.Mapping;
import de.destatis.core.map.MappingCheckResult;
import de.destatis.core.map.MappingParser;
import de.destatis.core.map.MappingsParser;
import de.destatis.core.map.MetaMappingCheck;
import de.destatis.core.map.model.MetaMapping;
import de.destatis.core.resource.DatmlSdfSource;
import de.destatis.core.resource.NoResourceFoundException;
import de.destatis.core.resource.ResourceConfig;
import de.destatis.core.resource.ResourceException;
import de.destatis.core.resource.ResourceStorageException;
import de.destatis.core.resource.SDFMetaResource;
import de.destatis.core.resource.SDFMetaResourceProvider;
import de.destatis.core.resource.SurveyResource;
import de.destatis.core.resource.SurveyResourceProvider;
import de.destatis.core.resource.util.ResourceManager;
import de.destatis.core.resource.util.ResponseStatusException;
import de.statspez.sdf.generator.meta.generated.MetaSDFDokumenterzeuger;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetabeschreibung;
import de.werum.sis.meta.ElementVisitorInterface;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Properties;

public final class SurveyDataDocumentGenerator {
    private static final String ARG_MODE = "-mode";
    private static final String MODE_PROPERTIES = "properties";
    private static final String MODE_CSV = "csv";
    private static final String[] ALL_MODES = new String[]{"properties", "csv"};
    private static final String ARG_INPUT_FILE = "-inputfile";
    private static final String ARG_CONFIG_FILE = "-conffile";
    private static final String ARG_MAPPING = "-mapfile";
    private static final String ARG_META_MAPPING = "-metamapfile";
    private static final String ARG_ENCODING = "-encoding";
    private static final String ARG_CSV_SEP = "-csvsep";
    private static final char DEFAULT_CSV_SEP = ';';
    private static final String ARG_CSV_QUOTE = "-csvquot";
    private static final char DEFAULT_CSV_QUOTE = '\"';
    private static final String ARG_OUTPUT_FILE = "-outputfile";
    private static final String ARG_USER_NAME = "-username";
    private static final String ARG_PASSWORD = "-password";
    private static final String ARG_DATML_RAW_VERSION = "-datmlrawversion";
    private static final String ARG_SDF_VALIDATION_MODE = "-sdfvalidation";
    private static final String SDF_VALIDATION_MODE_FREE_PARAM = new String("free");
    private static final String SDF_VALIDATION_MODE_STRICT_PARAM = new String("strict");
    private static final String[] SDF_VALIDATION_MODE_PARAMS = new String[]{SDF_VALIDATION_MODE_FREE_PARAM, SDF_VALIDATION_MODE_STRICT_PARAM};
    public static final short SDF_VALIDATION_MODE_FREE = 0;
    public static final short SDF_VALIDATION_MODE_STRICT = 10;
    private static final short[] SDF_VALIDATION_MODES = new short[]{0, 10};
    public static final short SDF_META_VALIDATION_MODE_FREE = 0;
    public static final short SDF_META_VALIDATION_MODE_STRICT = 10;
    private static final short[] SDF_META_VALIDATION_MODES = new short[]{0, 10};
    private ResourceConfig resourceConfig;
    private SurveyResourceProvider surveyResourceProvider;
    private SurveyResourceProvider autoSurveyResourceProvider;
    private SDFMetaResourceProvider sdfMetaResourceProvider;
    private SDFMetaResourceProvider autoSdfMetaResourceProvider;
    private ResourceManager resourceManager;
    private short sdfValidationMode = 0;
    private short sdfMetaValidationMode = (short)10;

    public SurveyDataDocumentGenerator() {
        this(null);
    }

    public SurveyDataDocumentGenerator(ResourceConfig resourceConfig) {
        this.setResourceConfig(resourceConfig);
    }

    public short getSDFValidationMode() {
        return this.sdfValidationMode;
    }

    public void setSDFValidationMode(short sdfValidationMode) {
        boolean sdfValidationOk = false;
        int len = SDF_VALIDATION_MODES.length;
        for (int i = 0; i < len; ++i) {
            if (SDF_VALIDATION_MODES[i] != sdfValidationMode) continue;
            sdfValidationOk = true;
            break;
        }
        if (!sdfValidationOk) {
            throw new IllegalArgumentException("Ung\u00fcltiger Modus '" + sdfValidationMode + "'!");
        }
        this.sdfValidationMode = sdfValidationMode;
    }

    public short getSDFMetaValidationMode() {
        return this.sdfMetaValidationMode;
    }

    public void setSDFMetaValidationMode(short sdfMetaValidationMode) {
        boolean sdfMetaValidationOk = false;
        int len = SDF_META_VALIDATION_MODES.length;
        for (int i = 0; i < len; ++i) {
            if (SDF_META_VALIDATION_MODES[i] != sdfMetaValidationMode) continue;
            sdfMetaValidationOk = true;
            break;
        }
        if (!sdfMetaValidationOk) {
            throw new IllegalArgumentException("Ung\u00fcltiger Modus '" + sdfMetaValidationMode + "'!");
        }
        this.sdfMetaValidationMode = sdfMetaValidationMode;
    }

    public void setResourceConfig(ResourceConfig resourceConfig) {
        this.resourceConfig = resourceConfig;
        this.resourceManager = null;
    }

    public ResourceConfig getResourceConfig() {
        if (this.resourceConfig == null) {
            this.resourceConfig = new ResourceConfig();
        }
        return this.resourceConfig;
    }

    public void setSurveyResourceProvider(SurveyResourceProvider surveyResourceProvider) {
        this.surveyResourceProvider = surveyResourceProvider;
    }

    public void setSDFMetaResourceProvider(SDFMetaResourceProvider sdfMetaResourceProvider) {
        this.sdfMetaResourceProvider = sdfMetaResourceProvider;
    }

    private ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceManager(this.getResourceConfig());
        }
        return this.resourceManager;
    }

    private SurveyResourceProvider getSurveyResourceProvider() {
        SurveyResourceProvider result;
        if (this.surveyResourceProvider != null) {
            result = this.surveyResourceProvider;
        } else {
            if (this.autoSurveyResourceProvider == null) {
                this.autoSurveyResourceProvider = new GeneratorSurveyResourceProvider();
            }
            result = this.autoSurveyResourceProvider;
        }
        return result;
    }

    private SDFMetaResourceProvider getSDFMetaResourceProvider() {
        SDFMetaResourceProvider result;
        if (this.sdfMetaResourceProvider != null) {
            result = this.sdfMetaResourceProvider;
        } else {
            if (this.autoSdfMetaResourceProvider == null) {
                this.autoSdfMetaResourceProvider = new GeneratorSDFMetaResourceProvider();
            }
            result = this.autoSdfMetaResourceProvider;
        }
        return result;
    }

    public void generate(DataProvider dataProvider, OutputStream out) throws SurveyDataDocumentGeneratorException {
        this.generate(dataProvider, out, null, null, (MappingProvider)null);
    }

    public void generate(DataProvider dataProvider, OutputStream out, String datMlRawVersion) throws SurveyDataDocumentGeneratorException {
        this.generate(dataProvider, out, datMlRawVersion, null, (MappingProvider)null);
    }

    public void generate(DataProvider dataProvider, OutputStream out, String datMlRawVersion, MetaMapping metaMapping, Mapping mapping) throws SurveyDataDocumentGeneratorException {
        SimpleMappingProvider mappingProvider = null;
        if (mapping != null) {
            mappingProvider = new SimpleMappingProvider(mapping);
        }
        this.generate(dataProvider, out, datMlRawVersion, metaMapping, mappingProvider);
    }

    public void generate(DataProvider dataProvider, OutputStream out, String datMlRawVersion, MetaMapping metaMapping, MappingProvider mappingProvider) throws SurveyDataDocumentGeneratorException {
        BufferedWriter writer;
        MetaMappingCheck check;
        MappingCheckResult checkResult;
        MetaSDFMetabeschreibung sdfMetaBeschreibung;
        SDFMetaResource sdfMetaResource;
        if (out == null) {
            throw new IllegalArgumentException("out ist erforderlich.");
        }
        if (dataProvider == null) {
            throw new IllegalArgumentException("dataProvider ist erforderlich.");
        }
        SDFMetaResourceProvider sdfMetaResourceProvider = this.getSDFMetaResourceProvider();
        try {
            sdfMetaResource = sdfMetaResourceProvider.getSDFMetaResource(datMlRawVersion);
        }
        catch (NoResourceFoundException e) {
            throw new SurveyDataDocumentGeneratorException("Es wurde keine SDFMetaBeschreibung gefunden.", e);
        }
        catch (RuntimeException e) {
            throw new SurveyDataDocumentGeneratorException("Fehler beim Zugriff auf die SDFMeta-Ressourcenablage: " + e.toString() + ".", e);
        }
        try {
            sdfMetaBeschreibung = sdfMetaResource.getSdfMetaBeschreibung();
        }
        catch (ResourceException e) {
            throw new SurveyDataDocumentGeneratorException("Fehler beim Parsen der SDFMeta-Ressource '" + sdfMetaResource.getResourceId() + "': " + e.toString() + ".", e);
        }
        MetaSDFDokumenterzeuger documentBuilder = this.getDocumentbuilder(sdfMetaResource, sdfMetaBeschreibung, null, null);
        if (metaMapping != null && !(checkResult = (check = new MetaMappingCheck()).check(metaMapping, sdfMetaBeschreibung)).isOk()) {
            String errorStr = checkResult.getErrorDescriptionString();
            throw new SurveyDataDocumentGeneratorException("Das gegebene Metadaten-Mapping ist nicht fehlerfrei:\n" + errorStr);
        }
        String documentBuilderEncoding = documentBuilder.getEncoding();
        try {
            writer = new BufferedWriter(new OutputStreamWriter(out, documentBuilderEncoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new SurveyDataDocumentGeneratorException("Das im Dokumenterzeuger definierte Encoding ('" + documentBuilderEncoding + "') wird nicht unterst\u00fctzt.", e);
        }
        try {
            documentBuilder.accept((ElementVisitorInterface)new DocumentBuilderInterpreter(dataProvider, sdfMetaBeschreibung, writer, this.getSurveyResourceProvider(), this.sdfValidationMode == 10, this.sdfMetaValidationMode == 10, metaMapping, mappingProvider));
        }
        catch (DocumentBuilderInterpreter.DocumentbuilderInterpreterException e) {
            throw new SurveyDataDocumentGeneratorException(e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw new SurveyDataDocumentGeneratorException("Laufzeitfehler bei der Erzeugung des Lieferdatendokuments: " + e.toString() + ".", e);
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw new SurveyDataDocumentGeneratorException("IOException beim Schreiben des Dokuments: " + e.getMessage() + ".", e);
        }
    }

    private MetaSDFDokumenterzeuger getDocumentbuilder(SDFMetaResource sdfMetaResource, MetaSDFMetabeschreibung sdfMetabeschreibung, String documentType, String documentVersion) throws SurveyDataDocumentGeneratorException {
        MetaSDFDokumenterzeuger foundDocumentBuilder = null;
        Iterator it = sdfMetabeschreibung.getDokumenterzeuger();
        while (it.hasNext()) {
            MetaSDFDokumenterzeuger tmp = (MetaSDFDokumenterzeuger)it.next();
            if (documentType == null) {
                foundDocumentBuilder = tmp;
                break;
            }
            if (!tmp.getDokumentTyp().equalsIgnoreCase(documentType)) continue;
            if (documentVersion == null) {
                foundDocumentBuilder = tmp;
                break;
            }
            if (!tmp.getDokumentVersion().equals(documentVersion)) continue;
            foundDocumentBuilder = tmp;
            break;
        }
        if (foundDocumentBuilder == null) {
            String message = documentType != null && documentVersion != null ? "Es existiert kein Dokumenterzeuger f\u00fcr den Typ '" + documentType + "' und die Version '" + documentVersion + "' in der SDFMetaRessource '" + sdfMetaResource.getResourceId() + "'." : (documentType != null ? "Es existiert kein Dokumenterzeuger f\u00fcr den Typ '" + documentType + "' in der SDFMetaRessource '" + sdfMetaResource.getResourceId() + "'." : "Es existiert kein Dokumenterzeuger in der SDFMetaRessource '" + sdfMetaResource.getResourceId() + "'.");
            throw new SurveyDataDocumentGeneratorException(message);
        }
        return foundDocumentBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            SurveyDataDocumentGenerator.printHelp();
            System.exit(1);
        }
        String mode = null;
        File inputFile = null;
        File outputFile = null;
        String userName = null;
        String password = null;
        File mappingFile = null;
        Mapping mapping = null;
        File metaMappingFile = null;
        MetaMapping metaMapping = null;
        String encoding = null;
        String csvSeparator = null;
        char csvSepartorChar = ';';
        String csvQuote = null;
        char csvQuoteChar = '\"';
        int sdfValidation = 0;
        String sdfValidationValue = null;
        String datMlRawVersion = null;
        Properties properties = null;
        try {
            String inputFilePath = null;
            String outputFilePath = null;
            String configFilePath = null;
            String mappingFilePath = null;
            String metaMappingFilePath = null;
            int len = args.length;
            for (int i = 0; i < len; ++i) {
                String arg = args[i];
                int valueIndex = i + 1;
                if (ARG_MODE.equalsIgnoreCase(arg)) {
                    SurveyDataDocumentGenerator.checkValueIndex(valueIndex, len, ARG_MODE);
                    mode = args[valueIndex];
                    mode = mode.trim();
                    ++i;
                    continue;
                }
                if (ARG_INPUT_FILE.equalsIgnoreCase(arg)) {
                    SurveyDataDocumentGenerator.checkValueIndex(valueIndex, len, ARG_INPUT_FILE);
                    inputFilePath = args[valueIndex];
                    inputFilePath = inputFilePath.trim();
                    ++i;
                    continue;
                }
                if (ARG_OUTPUT_FILE.equalsIgnoreCase(arg)) {
                    SurveyDataDocumentGenerator.checkValueIndex(valueIndex, len, ARG_OUTPUT_FILE);
                    outputFilePath = args[valueIndex];
                    outputFilePath = outputFilePath.trim();
                    ++i;
                    continue;
                }
                if (ARG_CONFIG_FILE.equalsIgnoreCase(arg)) {
                    SurveyDataDocumentGenerator.checkValueIndex(valueIndex, len, ARG_CONFIG_FILE);
                    configFilePath = args[valueIndex];
                    configFilePath = configFilePath.trim();
                    ++i;
                    continue;
                }
                if (ARG_USER_NAME.equalsIgnoreCase(arg)) {
                    SurveyDataDocumentGenerator.checkValueIndex(valueIndex, len, ARG_USER_NAME);
                    userName = args[valueIndex];
                    ++i;
                    continue;
                }
                if (ARG_PASSWORD.equalsIgnoreCase(arg)) {
                    SurveyDataDocumentGenerator.checkValueIndex(valueIndex, len, ARG_PASSWORD);
                    password = args[valueIndex];
                    ++i;
                    continue;
                }
                if (ARG_DATML_RAW_VERSION.equalsIgnoreCase(arg)) {
                    SurveyDataDocumentGenerator.checkValueIndex(valueIndex, len, ARG_DATML_RAW_VERSION);
                    datMlRawVersion = args[valueIndex];
                    ++i;
                    continue;
                }
                if (ARG_SDF_VALIDATION_MODE.equalsIgnoreCase(arg)) {
                    SurveyDataDocumentGenerator.checkValueIndex(valueIndex, len, ARG_SDF_VALIDATION_MODE);
                    sdfValidationValue = args[valueIndex];
                    ++i;
                    continue;
                }
                if (ARG_MAPPING.equalsIgnoreCase(arg)) {
                    SurveyDataDocumentGenerator.checkValueIndex(valueIndex, len, ARG_MAPPING);
                    mappingFilePath = args[valueIndex];
                    mappingFilePath = mappingFilePath.trim();
                    ++i;
                    continue;
                }
                if (ARG_META_MAPPING.equalsIgnoreCase(arg)) {
                    SurveyDataDocumentGenerator.checkValueIndex(valueIndex, len, ARG_META_MAPPING);
                    metaMappingFilePath = args[valueIndex];
                    metaMappingFilePath = metaMappingFilePath.trim();
                    ++i;
                    continue;
                }
                if (ARG_ENCODING.equalsIgnoreCase(arg)) {
                    SurveyDataDocumentGenerator.checkValueIndex(valueIndex, len, ARG_ENCODING);
                    encoding = args[valueIndex];
                    encoding = encoding.trim();
                    ++i;
                    continue;
                }
                if (ARG_CSV_SEP.equalsIgnoreCase(arg)) {
                    SurveyDataDocumentGenerator.checkValueIndex(valueIndex, len, ARG_CSV_SEP);
                    csvSeparator = args[valueIndex];
                    csvSeparator = csvSeparator.trim();
                    ++i;
                    continue;
                }
                if (!ARG_CSV_QUOTE.equalsIgnoreCase(arg)) continue;
                SurveyDataDocumentGenerator.checkValueIndex(valueIndex, len, ARG_CSV_QUOTE);
                csvQuote = args[valueIndex];
                csvQuote = csvQuote.trim();
                ++i;
            }
            if (mode == null) {
                throw new IllegalArgumentException("Parameter -mode ist erforderlich!");
            }
            boolean modeOk = false;
            int len2 = ALL_MODES.length;
            for (int i = 0; i < len2; ++i) {
                if (!ALL_MODES[i].equals(mode)) continue;
                modeOk = true;
                break;
            }
            if (!modeOk) {
                throw new IllegalArgumentException("Ung\u00fcltiger Wert f\u00fcr Paramater -mode: " + mode + "!");
            }
            if (MODE_CSV.equals(mode)) {
                if (csvSeparator != null) {
                    if (csvSeparator.equals("TAB")) {
                        csvSepartorChar = '\t';
                    } else if (csvSeparator.length() == 1) {
                        csvSepartorChar = csvSeparator.charAt(0);
                    } else {
                        throw new IllegalArgumentException("Ung\u00fcltiges CSV-Feldtrennerzeichen: " + csvSeparator);
                    }
                }
                if (csvQuote != null) {
                    if (csvQuote.length() != 1) {
                        throw new IllegalArgumentException("Ung\u00fcltiges CSV-Feldbegrenzerzeichen: " + csvQuote);
                    }
                    csvQuoteChar = csvQuote.charAt(0);
                }
            }
            if (sdfValidationValue != null) {
                if (SDF_VALIDATION_MODE_FREE_PARAM.equals(sdfValidationValue)) {
                    sdfValidation = 0;
                } else if (SDF_VALIDATION_MODE_STRICT_PARAM.equals(sdfValidationValue)) {
                    sdfValidation = 10;
                } else {
                    throw new IllegalArgumentException("Ung\u00fcltiger Wert f\u00fcr Parameter -sdfvalidation: " + sdfValidationValue);
                }
            }
            if (inputFilePath == null) {
                throw new IllegalArgumentException("Parameter -inputfile ist erforderlich!");
            }
            inputFile = new File(inputFilePath);
            if (!inputFile.isFile()) {
                throw new IllegalArgumentException("Die Eingabedatei '" + inputFile.getAbsolutePath() + "' existiert nicht!");
            }
            if (outputFilePath == null) {
                throw new IllegalArgumentException("Parameter -outputfile ist erforderlich!");
            }
            outputFile = new File(outputFilePath);
            File configFile = null;
            if (configFilePath != null && !(configFile = new File(configFilePath)).isFile()) {
                throw new IllegalArgumentException("Die Konfigurationsdatei '" + configFile.getAbsolutePath() + "' existiert nicht!");
            }
            if (configFile != null) {
                FileInputStream fIn = null;
                try {
                    fIn = new FileInputStream(configFile);
                    properties = new Properties();
                    properties.load(new BufferedInputStream(fIn));
                }
                finally {
                    if (fIn != null) {
                        try {
                            fIn.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
            if (mappingFilePath != null && !(mappingFile = new File(mappingFilePath)).isFile()) {
                throw new IllegalArgumentException("Die Mappingdatei '" + mappingFile.getAbsolutePath() + "' existiert nicht.");
            }
            if (metaMappingFilePath != null && !(metaMappingFile = new File(metaMappingFilePath)).isFile()) {
                throw new IllegalArgumentException("Die MetaMappingdatei '" + metaMappingFile.getAbsolutePath() + "' existiert nicht.");
            }
            if (MODE_CSV.equals(mode)) {
                if (mappingFile == null) {
                    throw new IllegalArgumentException("Im Modus 'csv' muss per '-mapfile' eine SDFDaten-Mappingdatei angegeben werden.");
                }
                if (metaMappingFile == null) {
                    throw new IllegalArgumentException("Im Modus 'csv' muss per '-metamapfile' eine Metadaten-Mappingdatei angegeben werden.");
                }
            }
            if (mappingFile != null) {
                MappingParser mappingParser = new MappingParser();
                mapping = mappingParser.parse(mappingFile);
            }
            if (metaMappingFile != null) {
                MappingsParser mappingsParser = new MappingsParser();
                metaMapping = (MetaMapping)mappingsParser.parse(metaMappingFile);
            }
        }
        catch (DocumentBuilderInterpreter.DocumentbuilderInterpreterException e) {
            System.err.println(e.getMessage());
            SurveyDataDocumentGenerator.printHelp();
            System.exit(1);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            SurveyDataDocumentGenerator.printHelp();
            System.exit(1);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
        OutputStream out = null;
        FileInputStream csvFIn = null;
        Throwable error = null;
        try {
            DataProvider dataProvider;
            if (properties != null) {
                if (userName != null) {
                    properties.setProperty("client.username", userName);
                }
                if (password != null) {
                    properties.setProperty("client.password", password);
                }
            }
            SurveyDataDocumentGenerator generator = SurveyDataDocumentGenerator.createGenerator(properties);
            generator.setSDFValidationMode((short)sdfValidation);
            if (MODE_PROPERTIES.equals(mode)) {
                Properties values = null;
                FileInputStream fIn = null;
                try {
                    fIn = new FileInputStream(inputFile);
                    values = new Properties();
                    values.load(new BufferedInputStream(fIn));
                }
                finally {
                    if (fIn != null) {
                        try {
                            fIn.close();
                        }
                        catch (Exception e) {}
                    }
                }
                dataProvider = new MapDataProvider(values);
            } else if (MODE_CSV.equals(mode)) {
                csvFIn = new FileInputStream(inputFile);
                BufferedReader reader = encoding == null ? new BufferedReader(new InputStreamReader(csvFIn)) : new BufferedReader(new InputStreamReader((InputStream)csvFIn, encoding));
                dataProvider = new CsvDataProvider(reader, csvSepartorChar, csvQuoteChar, mapping);
            } else {
                throw new IllegalArgumentException("Unbekannter Modus '" + mode + "'.");
            }
            out = new BufferedOutputStream(new FileOutputStream(outputFile));
            generator.generate(dataProvider, out, datMlRawVersion, metaMapping, mapping);
            out.close();
            out = null;
            System.out.println("Generierung erfolgreich durchgef\u00fchrt.");
            if (csvFIn != null) {
                try {
                    csvFIn.close();
                    csvFIn = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable e) {
            error = e;
            System.err.println("Fehler bei der Generierung: " + e.getMessage());
            e.printStackTrace();
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
        }
        finally {
            if (csvFIn != null) {
                try {
                    csvFIn.close();
                }
                catch (Throwable e) {}
            }
        }
        System.exit(error == null ? 0 : 1);
    }

    private static void checkValueIndex(int valueIndex, int argLength, String paramName) {
        if (valueIndex >= argLength) {
            throw new IllegalArgumentException("Kein Wert f\u00fcr Parameter " + paramName + " angegeben!");
        }
    }

    private static SurveyDataDocumentGenerator createGenerator(Properties properties) {
        SurveyDataDocumentGenerator generator = null;
        if (properties != null) {
            generator = new SurveyDataDocumentGenerator();
            ResourceConfig resourceConfig = SurveyDataDocumentGenerator.getResourceConfig(properties);
            generator.setResourceConfig(resourceConfig);
        } else {
            generator = new SurveyDataDocumentGenerator();
        }
        return generator;
    }

    private static ResourceConfig getResourceConfig(Properties properties) {
        ResourceConfig resourceConfig = null;
        if (properties != null) {
            String property = null;
            resourceConfig = new ResourceConfig();
            Boolean surveyAutoUpdate = null;
            property = properties.getProperty("resourceconfig.survey.autoupdate");
            if (property != null) {
                surveyAutoUpdate = "1".equals(property = property.trim()) || "true".equalsIgnoreCase(property) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (surveyAutoUpdate != null) {
                resourceConfig.setSurveyAutoUpdate(surveyAutoUpdate);
            }
            if ((property = properties.getProperty("resourceconfig.survey.dir")) != null) {
                property = property.trim();
                resourceConfig.setSurveyDir(property);
            }
            Boolean sdfMetaAutoUpdate = null;
            property = properties.getProperty("resourceconfig.sdfmeta.autoupdate");
            if (property != null) {
                sdfMetaAutoUpdate = "1".equals(property = property.trim()) || "true".equalsIgnoreCase(property) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (sdfMetaAutoUpdate != null) {
                resourceConfig.setSdfMetaAutoUpdate(sdfMetaAutoUpdate);
            }
            if ((property = properties.getProperty("resourceconfig.sdfmeta.dir")) != null) {
                property = property.trim();
                resourceConfig.setSdfMetaDir(property);
            }
            if (resourceConfig.isSurveyAutoUpdate()) {
                String username = properties.getProperty("client.username");
                String password = properties.getProperty("client.password");
                if (username == null || username.length() == 0) {
                    throw new IllegalArgumentException("Die Benutzerkennung wurde nicht angegeben.");
                }
                if (password == null || password.length() == 0) {
                    throw new IllegalArgumentException("Das Passwort wurde nicht angegeben.");
                }
                Client client = new Client(username, password.toCharArray(), properties);
                resourceConfig.setClient(client);
            }
        } else {
            resourceConfig = new ResourceConfig();
        }
        return resourceConfig;
    }

    private static void printHelp() {
        int i;
        System.out.println("Usage:");
        System.out.println("java " + SurveyDataDocumentGenerator.class.getName() + " <Paramater...>");
        System.out.println();
        System.out.println("Liste aller moeglichen Parameter:");
        System.out.println();
        System.out.print(" -mode ");
        int len = ALL_MODES.length;
        for (i = 0; i < len; ++i) {
            if (i > 0) {
                System.out.print("|");
            }
            System.out.print(ALL_MODES[i]);
        }
        System.out.println();
        System.out.println(" -inputfile <Eingabedatei>");
        System.out.println(" -outputfile <Ausgabedatei>");
        System.out.println(" [-mapfile <SDFDaten-Mappingdatei>]");
        System.out.println("                    Muss im Modus 'csv' zwingend angegeben werden.");
        System.out.println(" [-metamapfile <Metadaten-Mappingdatei>]");
        System.out.println("                    Muss im Modus 'csv' zwingend angegeben werden.");
        System.out.println(" [-encoding <Encoding der CSV-Datei im Mode 'csv'>]");
        System.out.println("                    Standardmaessig wird das Encoding der Plattform verwendet.");
        System.out.println(" [-csvsep <Feldtrenner der CSV-Datei>]");
        System.out.println("                    Erlaubt ist ein beliebiges Zeichen oder TAB fuer Tabulator.");
        System.out.println("                    Standardmaessig wird ';' verwendet.");
        System.out.println(" [-csvquot <Feldbegrenzer der CSV-Datei>]");
        System.out.println("                    Erlaubt ist ein beliebiges Zeichen.");
        System.out.println("                    Standardmaessig wird '\"' verwendet.");
        System.out.println(" [-conffile <Konfigurationsdatei>]");
        System.out.println(" [-username <Benutzername>]");
        System.out.println(" [-password <Passwort>]");
        System.out.print(" [-sdfvalidation ");
        len = SDF_VALIDATION_MODE_PARAMS.length;
        for (i = 0; i < len; ++i) {
            if (i > 0) {
                System.out.print("|");
            }
            System.out.print(SDF_VALIDATION_MODE_PARAMS[i]);
        }
        System.out.println("]");
        System.out.println("                    Standard ist '" + SDF_VALIDATION_MODE_FREE_PARAM + "'.");
        System.out.println(" [-datmlrawversion <DatML/RAW-Version im Format ##.## (zurzeit nur 2.0 und 2.1)>]");
    }

    private class SimpleMappingProvider
    implements MappingProvider {
        private final Mapping mapping;

        public SimpleMappingProvider(Mapping mapping) {
            this.mapping = mapping;
        }

        @Override
        public Mapping getMapping(int messageIndex) {
            return this.mapping;
        }
    }

    private class GeneratorSDFMetaResourceProvider
    implements SDFMetaResourceProvider {
        @Override
        public SDFMetaResource getSDFMetaResource(String datMlRawVersion) throws NoResourceFoundException {
            SDFMetaResource sdfMeta;
            try {
                sdfMeta = SurveyDataDocumentGenerator.this.getResourceManager().getSdfMetaResource(datMlRawVersion);
            }
            catch (TransferProtocolException e) {
                throw new RuntimeException(e);
            }
            catch (ResourceStorageException e) {
                throw new RuntimeException(e);
            }
            catch (ResponseStatusException e) {
                throw new RuntimeException(e);
            }
            return sdfMeta;
        }
    }

    private class GeneratorSurveyResourceProvider
    implements SurveyResourceProvider {
        @Override
        public SurveyResource getSurveyResource(String statId, String reportingPeriod, String collector) throws NoResourceFoundException {
            DatmlSdfSource sdf;
            try {
                sdf = SurveyDataDocumentGenerator.this.getResourceManager().getSdfResource(statId, reportingPeriod, collector);
            }
            catch (TransferProtocolException e) {
                throw new RuntimeException(e);
            }
            catch (ResourceStorageException e) {
                throw new RuntimeException(e);
            }
            catch (ResponseStatusException e) {
                throw new RuntimeException(e);
            }
            return sdf;
        }
    }
}

