/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.generator;

import com.mindprod.csv.CSVReader;
import de.destatis.core.generator.DataProvider;
import de.destatis.core.generator.FieldDescriptor;
import de.destatis.core.generator.StructureDescriptor;
import de.destatis.core.map.Mapping;
import de.destatis.core.map.model.HelpFeatureConfigValue;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;

public class CsvDataProvider
implements DataProvider {
    private final CSVReader csvReader;
    private String[] currentLine;
    private final Mapping mapping;
    private final HelpFeatureConfigValue helpFeatureConfigValue;
    private final String csvQuote;
    private StructureDescriptor messageDescriptor;
    private StructureDescriptor currentRecordDescriptor;
    private boolean recordLineForHelpFeaturesRead;
    private boolean separateHelpFeaturesLineRead;

    public CsvDataProvider(Reader reader, char separator, char quote, Mapping mapping) throws EOFException, IOException {
        this.csvQuote = String.valueOf(quote);
        this.csvReader = new CSVReader(reader, separator, quote, true, false, true);
        this.mapping = mapping;
        this.helpFeatureConfigValue = this.mapping.getHelpFeatureConfig();
        this.currentLine = this.csvReader.getAllFieldsInLine();
        if (this.currentLine == null || this.currentLine.length == 0) {
            throw new IllegalArgumentException("Die CSV-Datei enth\u00e4lt keine Daten.");
        }
    }

    public CsvDataProvider(Reader reader, char separator, char quote, Mapping mapping, StructureDescriptor messageDescriptor) throws EOFException, IOException {
        this.csvQuote = String.valueOf(quote);
        this.csvReader = new CSVReader(reader, separator, quote, true, false, true);
        this.mapping = mapping;
        this.helpFeatureConfigValue = this.mapping.getHelpFeatureConfig();
        this.currentLine = null;
        this.messageDescriptor = messageDescriptor;
    }

    public CsvDataProvider(String[] recordLine, char quote, Mapping mapping, StructureDescriptor messageDescriptor) {
        this.csvQuote = String.valueOf(quote);
        this.csvReader = null;
        this.mapping = mapping;
        this.helpFeatureConfigValue = this.mapping.getHelpFeatureConfig();
        if (!HelpFeatureConfigValue.EACH_RECORD.equals(this.helpFeatureConfigValue)) {
            throw new IllegalArgumentException();
        }
        this.currentLine = recordLine;
        this.messageDescriptor = messageDescriptor;
        this.recordLineForHelpFeaturesRead = true;
    }

    public CsvDataProvider(String[] recordLine, char quote, Mapping mapping, StructureDescriptor messageDescriptor, StructureDescriptor recordDescriptor) {
        this.csvQuote = String.valueOf(quote);
        this.csvReader = null;
        this.mapping = mapping;
        this.helpFeatureConfigValue = this.mapping.getHelpFeatureConfig();
        if (!HelpFeatureConfigValue.EACH_RECORD.equals(this.helpFeatureConfigValue)) {
            throw new IllegalArgumentException();
        }
        this.currentLine = recordLine;
        this.messageDescriptor = messageDescriptor;
        this.currentRecordDescriptor = recordDescriptor;
        this.recordLineForHelpFeaturesRead = true;
    }

    @Override
    public DataProvider getDataProvider(StructureDescriptor structure) {
        CsvDataProvider result;
        int type = structure.getType();
        if (2 == type) {
            boolean readNextLine = true;
            if (this.currentRecordDescriptor == null) {
                if (this.helpFeatureConfigValue.isEachRecord()) {
                    if (this.recordLineForHelpFeaturesRead) {
                        readNextLine = false;
                    }
                } else if (this.helpFeatureConfigValue.isSeparateRow() && !this.separateHelpFeaturesLineRead) {
                    try {
                        String[] hmmLine = this.csvReader.getAllFieldsInLine();
                        if (hmmLine == null || hmmLine.length == 0) {
                            throw new RuntimeException("Die Hilfsmerkmalzeile existiert nicht.");
                        }
                    }
                    catch (EOFException e) {
                        throw new RuntimeException("Die Hilfsmerkmalzeile existiert nicht.", e);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (readNextLine) {
                try {
                    this.currentLine = this.csvReader.getAllFieldsInLine();
                    if (this.currentLine == null || this.currentLine.length == 0) {
                        result = null;
                    }
                    result = this;
                }
                catch (EOFException e) {
                    result = null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                result = this;
            }
            this.currentRecordDescriptor = structure;
        } else if (1 == type) {
            if (this.messageDescriptor != null) {
                result = null;
            } else {
                this.messageDescriptor = structure;
                try {
                    this.currentLine = this.csvReader.getAllFieldsInLine();
                    if (this.currentLine == null || this.currentLine.length == 0) {
                        result = null;
                    }
                    result = this;
                }
                catch (EOFException e) {
                    result = null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        } else if (3 == type) {
            Integer firstCsvPosition;
            Integer index;
            Integer quantity = structure.getQuantity();
            result = quantity != null && quantity > 0 ? ((index = structure.getIndex()) < quantity ? ((firstCsvPosition = this.calculateFirstMmgrCsvPosition(structure)) != null && firstCsvPosition <= this.currentLine.length ? this : null) : null) : null;
        } else if (4 == type) {
            Integer quantity = structure.getQuantity();
            result = quantity != null && quantity == 1 ? this : null;
        } else {
            throw new IllegalArgumentException("Unbekannter Strukturdeskriptor-Typ: " + type + ". Feld: '" + structure.getPathString() + "'.");
        }
        return result;
    }

    @Override
    public String getFieldValue(FieldDescriptor field) {
        String value;
        Integer position;
        if (this.currentRecordDescriptor == null) {
            int fieldType = field.getType();
            if (!this.recordLineForHelpFeaturesRead && this.helpFeatureConfigValue.isEachRecord() && 1 == fieldType) {
                if (this.messageDescriptor == null) {
                    throw new IllegalStateException("Hilfsmerkmale m\u00fcssen innerhalb einer Nachricht abgefragt werden.");
                }
                if (field.getParent() != this.messageDescriptor) {
                    throw new IllegalStateException("Es handelt sich nicht um ein Hilfsmerkmal: '" + field.getPathString() + "'.");
                }
                try {
                    this.currentLine = this.csvReader.getAllFieldsInLine();
                    if (this.currentLine == null || this.currentLine.length == 0) {
                        throw new RuntimeException("Die Daten enthalten keine Satzzeile f\u00fcr die Hilfsmerkmale. Feld: '" + field.getPathString() + "'.");
                    }
                }
                catch (EOFException e) {
                    throw new RuntimeException("Die Daten enthalten keine Satzzeile f\u00fcr die Hilfsmerkmale. Feld: '" + field.getPathString() + "'.", e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.recordLineForHelpFeaturesRead = true;
            } else if (!this.separateHelpFeaturesLineRead && this.helpFeatureConfigValue.isSeparateRow() && 1 == fieldType) {
                if (this.messageDescriptor == null) {
                    throw new IllegalStateException("Hilfsmerkmale m\u00fcssen innerhalb einer Nachricht abgefragt werden.");
                }
                if (field.getParent() != this.messageDescriptor) {
                    throw new IllegalStateException("Es handelt sich nicht um ein Hilfsmerkmal: '" + field.getPathString() + "'.");
                }
                try {
                    this.currentLine = this.csvReader.getAllFieldsInLine();
                    if (this.currentLine == null || this.currentLine.length == 0) {
                        throw new RuntimeException("Die Daten enthalten keine Zeile f\u00fcr die Hilfsmerkmale. Feld: '" + field.getPathString() + "'.");
                    }
                }
                catch (EOFException e) {
                    throw new RuntimeException("Die Daten enthalten keine Satzzeile f\u00fcr die Hilfsmerkmale. Feld: '" + field.getPathString() + "'.", e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.separateHelpFeaturesLineRead = true;
            }
        }
        if ((position = this.calculatePosition(field)) != null) {
            try {
                value = this.currentLine[position - 1];
                value = CsvDataProvider.createValueFromCsvValue(value, this.csvQuote);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new RuntimeException("Fehler beim Zugriff auf das Feld '" + field.getPathString() + "': " + e.getMessage(), e);
            }
        } else {
            value = null;
        }
        return value;
    }

    @Override
    public void close() {
    }

    private Integer calculateFirstMmgrCsvPosition(StructureDescriptor mmgrDescriptor) {
        int offset;
        Integer firstPosition = mmgrDescriptor.getFirstCsvPosition();
        if (firstPosition != null && (offset = this.calculateOffset(mmgrDescriptor)) > 0) {
            firstPosition = new Integer(firstPosition + offset);
        }
        return firstPosition;
    }

    private Integer calculatePosition(FieldDescriptor field) {
        int offset;
        Integer csvPosition = field.getCsvPosition();
        if (csvPosition != null && (offset = this.calculateOffset(field.getParent())) > 0) {
            csvPosition = new Integer(csvPosition + offset);
        }
        return csvPosition;
    }

    private int calculateOffset(StructureDescriptor mmgrDescriptor) {
        int type;
        int result = 0;
        if (mmgrDescriptor != null && ((type = mmgrDescriptor.getType()) == 4 || type == 3)) {
            Integer index = mmgrDescriptor.getIndex();
            Integer firstCsvPosition = mmgrDescriptor.getFirstCsvPosition();
            Integer lastCsvPosition = mmgrDescriptor.getLastCsvPosition();
            int offset = (lastCsvPosition - firstCsvPosition + 1) * (index == null ? 0 : index);
            result += offset;
            int parentOffset = this.calculateOffset(mmgrDescriptor.getParent());
            result += parentOffset;
        }
        return result;
    }

    public static String createValueFromCsvValue(String value, String csvQuote) {
        if (value != null) {
            if (value.startsWith(csvQuote)) {
                value = CsvDataProvider.removeEnclosingQuotes(value, csvQuote);
            } else if (value.length() == 0) {
                value = null;
            }
        }
        return value;
    }

    private static String removeEnclosingQuotes(String value, String csvQuote) {
        if (value.startsWith(csvQuote) && value.endsWith(csvQuote) && value.length() >= 2) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }
}

