/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect.transfer;

import de.destatis.core.connect.CheckDeliveryRequest;
import de.destatis.core.connect.ClientAuthenticator;
import de.destatis.core.connect.ClientStatusEvent;
import de.destatis.core.connect.ClientStatusListener;
import de.destatis.core.connect.DataDelivery;
import de.destatis.core.connect.GetCommonResourceRequest;
import de.destatis.core.connect.GetSurveyResourceRequest;
import de.destatis.core.connect.GetSurveysRequest;
import de.destatis.core.connect.PingRequest;
import de.destatis.core.connect.ProtocolRequest;
import de.destatis.core.connect.ResponseToCheckDeliveryRequest;
import de.destatis.core.connect.ResponseToDataDelivery;
import de.destatis.core.connect.ResponseToGetCommonResourceRequest;
import de.destatis.core.connect.ResponseToGetResourceRequest;
import de.destatis.core.connect.ResponseToGetSurveysRequest;
import de.destatis.core.connect.ResponseToPingRequest;
import de.destatis.core.connect.ResponseToProtocolRequest;
import de.destatis.core.connect.ServerAddress;
import de.destatis.core.connect.TransferProtocol;
import de.destatis.core.connect.TransferProtocolException;
import de.destatis.core.connect.util.ClientConfig;
import de.destatis.core.connect.util.Contract;
import java.util.Vector;

public abstract class ProtocolHandlerBase {
    private ClientConfig config = null;
    private ClientAuthenticator authenticator = null;
    private TransferProtocol protocol = null;
    private Vector statusListeners = new Vector();

    public ProtocolHandlerBase(ClientConfig config, TransferProtocol protocol) {
        Contract.verify(config != null, "Keine Konfiguration angegeben");
        Contract.verify(protocol != null, "Kein Transferprotokoll angegeben");
        this.config = config;
        this.protocol = protocol;
    }

    public abstract ResponseToDataDelivery send(ClientAuthenticator var1, DataDelivery var2, ServerAddress var3) throws TransferProtocolException;

    public abstract ResponseToProtocolRequest send(ClientAuthenticator var1, ProtocolRequest var2, ServerAddress var3) throws TransferProtocolException;

    public abstract ResponseToGetSurveysRequest send(ClientAuthenticator var1, GetSurveysRequest var2, ServerAddress var3) throws TransferProtocolException;

    public abstract ResponseToGetResourceRequest send(ClientAuthenticator var1, GetSurveyResourceRequest var2, ServerAddress var3) throws TransferProtocolException;

    public abstract ResponseToCheckDeliveryRequest send(ClientAuthenticator var1, CheckDeliveryRequest var2, ServerAddress var3) throws TransferProtocolException;

    public abstract ResponseToGetCommonResourceRequest send(ClientAuthenticator var1, GetCommonResourceRequest var2, ServerAddress var3) throws TransferProtocolException;

    public abstract ResponseToPingRequest send(PingRequest var1, ServerAddress var2) throws TransferProtocolException;

    public ClientConfig getConfig() {
        return this.config;
    }

    public TransferProtocol getTransferProtocol() {
        return this.protocol;
    }

    public void addStatusListener(ClientStatusListener listener) {
        Contract.verify(listener != null, "Kein Listener angegeben");
        this.statusListeners.add(listener);
    }

    public void removeStatusListener(ClientStatusListener listener) {
        Contract.verify(listener != null, "Kein Listener angegeben");
        this.statusListeners.remove(listener);
    }

    public ClientStatusListener[] getStatusListeners() {
        return this.statusListeners.toArray(new ClientStatusListener[0]);
    }

    public void notifyListeners(ClientStatusEvent event) {
        ClientStatusListener[] listeners = this.getStatusListeners();
        for (int idx = 0; idx < listeners.length; ++idx) {
            listeners[idx].statusChanged(event);
        }
    }
}

