/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect;

import de.destatis.core.connect.IncompleteRequestException;
import de.destatis.core.connect.Request;
import de.destatis.core.connect.transfer.CoreCommunicationInterface;
import de.destatis.core.resource.ResourceType;

public abstract class GetCommonResourceRequest
extends Request {
    protected String datMlRawVersion;
    protected String currentResourceId;

    protected GetCommonResourceRequest(String datMlRawVersion, String currentResourceId) {
        this.datMlRawVersion = datMlRawVersion;
        this.currentResourceId = currentResourceId;
    }

    public String getDatMlRawVersion() {
        return this.datMlRawVersion;
    }

    public String getCurrentResourceId() {
        return this.currentResourceId;
    }

    @Override
    public void check() throws IncompleteRequestException {
        ResourceType resourceType = this.getResourceType();
        if (resourceType == null) {
            throw new IncompleteRequestException("Kein Ressourcetyp angegeben.");
        }
        if (this.datMlRawVersion != null) {
            CoreCommunicationInterface.checkDatMlRawVersion(this.datMlRawVersion);
        }
        if (this.currentResourceId != null) {
            CoreCommunicationInterface.checkCommonResourceId(this.currentResourceId);
        }
    }

    public abstract ResourceType getResourceType();
}

