/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.ode;

import org.apache.commons.math.ode.DerivativeException;
import org.apache.commons.math.ode.RungeKuttaStepInterpolator;
import org.apache.commons.math.ode.StepInterpolator;

class MidpointStepInterpolator
extends RungeKuttaStepInterpolator {
    private static final long serialVersionUID = -865524111506042509L;

    public MidpointStepInterpolator() {
    }

    public MidpointStepInterpolator(MidpointStepInterpolator interpolator) {
        super(interpolator);
    }

    protected StepInterpolator doCopy() {
        return new MidpointStepInterpolator(this);
    }

    protected void computeInterpolatedState(double theta, double oneMinusThetaH) throws DerivativeException {
        double coeff1 = oneMinusThetaH * theta;
        double coeff2 = oneMinusThetaH * (1.0 + theta);
        for (int i = 0; i < this.interpolatedState.length; ++i) {
            this.interpolatedState[i] = this.currentState[i] + coeff1 * this.yDotK[0][i] - coeff2 * this.yDotK[1][i];
        }
    }
}

