/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.util.format;

import com.atlassian.clover.util.format.MessageFormatException;

public class MessageTokenizer {
    public static final int ANCHOR_START = 1;
    public static final int ANCHOR_END = 2;
    public static final int BOLD_START = 3;
    public static final int BOLD_END = 4;
    public static final int ITALIC_START = 5;
    public static final int ITALIC_END = 6;
    public static final int TEXT = 7;
    public static final int END = -1;
    public static final int HORIZONTAL_LINE = 8;
    private char[] message;
    int nextIndex = 0;
    private String currentContent = null;

    public MessageTokenizer(String aMessage) {
        this.message = aMessage == null ? new char[0] : aMessage.toCharArray();
    }

    public boolean hasNext() {
        return this.nextIndex < this.message.length;
    }

    public int nextToken() throws MessageFormatException {
        char next;
        if (!this.hasNext()) {
            return -1;
        }
        char c = this.message[this.nextIndex];
        if (c == '<') {
            return this.readToken();
        }
        if (c == '*' && this.message.length > this.nextIndex && (next = this.message[this.nextIndex + 1]) == '*') {
            return this.readHorizontalLine();
        }
        return this.readText();
    }

    private int readHorizontalLine() {
        char c;
        StringBuffer buffer = new StringBuffer();
        while (this.hasNext() && (c = this.message[this.nextIndex]) == '*') {
            buffer.append(c);
            ++this.nextIndex;
        }
        this.currentContent = buffer.toString();
        return 8;
    }

    private int readText() {
        char next;
        char c;
        StringBuffer buffer = new StringBuffer();
        while (this.hasNext() && (c = this.message[this.nextIndex]) != '<' && (c != '*' || this.message.length <= this.nextIndex || (next = this.message[this.nextIndex + 1]) != '*')) {
            buffer.append(c);
            ++this.nextIndex;
        }
        this.currentContent = buffer.toString();
        return 7;
    }

    private int readToken() throws MessageFormatException {
        int token = 0;
        boolean end = false;
        StringBuffer buffer = new StringBuffer();
        char c = this.message[this.nextIndex];
        if (c != '<') {
            throw new MessageFormatException("Expected < but found " + c);
        }
        ++this.nextIndex;
        buffer.append(c);
        c = this.message[this.nextIndex];
        if (c == '/') {
            end = true;
            ++this.nextIndex;
            buffer.append(c);
        }
        if ((c = this.message[this.nextIndex]) == 'A' || c == 'a') {
            token = end ? 2 : 1;
        } else if (c == 'B' || c == 'b') {
            token = end ? 4 : 3;
        } else if (c == 'I' || c == 'i') {
            token = end ? 6 : 5;
        } else {
            throw new MessageFormatException("Expected [aAbBiI] but found " + c);
        }
        ++this.nextIndex;
        buffer.append(c);
        c = this.message[this.nextIndex];
        if (c != '>') {
            throw new MessageFormatException("Expected > but found " + c);
        }
        ++this.nextIndex;
        buffer.append(c);
        this.currentContent = buffer.toString();
        return token;
    }

    public String getContent() {
        return this.currentContent;
    }
}

