/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.util;

import com.atlassian.clover.ProgressListener;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ProgressInputStream
extends FilterInputStream {
    private final ProgressListener progressListener;
    private final String message;
    private long counter;
    private final float total;
    private long markedCount;

    private void updateProgressListener() {
        this.progressListener.handleProgress(this.message, (float)this.counter / this.total);
    }

    public ProgressInputStream(InputStream is, long length, ProgressListener progressListener, String message) {
        super(is);
        this.progressListener = progressListener;
        this.message = message;
        this.total = length > 0L ? length : 1L;
    }

    public int read() throws IOException {
        ++this.counter;
        return super.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = super.read(b, off, len);
        if (read != -1) {
            this.counter += (long)read;
        }
        this.updateProgressListener();
        return read;
    }

    public long skip(long n) throws IOException {
        long skipped = super.skip(n);
        this.counter += skipped;
        this.updateProgressListener();
        return skipped;
    }

    public void mark(int readlimit) {
        super.mark(readlimit);
        this.markedCount = this.counter;
    }

    public void reset() throws IOException {
        super.reset();
        this.counter = this.markedCount;
        this.updateProgressListener();
    }
}

