/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.spi.lang;

import com.atlassian.clover.spi.lang.LanguageConstruct;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Language {
    public String getName();

    public Set<String> getFileExtensions();

    public Set<LanguageConstruct> getSupportedConstructs();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Builtin implements Language
    {
        JAVA(".java", LanguageConstruct.Builtin.METHOD, LanguageConstruct.Builtin.BRANCH, LanguageConstruct.Builtin.STATEMENT),
        GROOVY(".groovy", LanguageConstruct.Builtin.METHOD, LanguageConstruct.Builtin.BRANCH, LanguageConstruct.Builtin.STATEMENT, LanguageConstruct.Builtin.GROOVY_FIELD_EXPRESSION, LanguageConstruct.Builtin.GROOVY_SAFE_METHOD, LanguageConstruct.Builtin.GROOVY_SAFE_ATTRIBUTE, LanguageConstruct.Builtin.GROOVY_SAFE_PROPERTY);

        private final Set<String> extensions;
        private final Set<LanguageConstruct> constructs;

        private Builtin(String extension, LanguageConstruct ... constructs) {
            this.extensions = Collections.singleton(extension);
            this.constructs = Collections.unmodifiableSet(new HashSet<LanguageConstruct>(Arrays.asList(constructs)));
        }

        @Override
        public String getName() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        @Override
        public Set<String> getFileExtensions() {
            return this.extensions;
        }

        @Override
        public Set<LanguageConstruct> getSupportedConstructs() {
            return this.constructs;
        }
    }
}

