/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.html;

import clover.org.apache.velocity.VelocityContext;
import com.atlassian.clover.registry.entities.BaseClassInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.metrics.HasMetricsSupport;
import com.atlassian.clover.reporters.html.ClassInfoStatsCalculator;
import com.atlassian.clover.reporters.html.HtmlReportUtil;
import com.atlassian.clover.reporters.html.HtmlReporter;
import com.atlassian.clover.reporters.html.RenderCoverageCloudAction;
import com.atlassian.clover.reporters.html.TabInfo;
import com.atlassian.clover.reporters.html.TestClassFilter;
import java.io.File;
import java.util.Collections;
import java.util.List;

public class RenderProjectCoverageCloudsAction
extends RenderCoverageCloudAction {
    protected FullProjectInfo projectInfo;

    public RenderProjectCoverageCloudsAction(VelocityContext context, File basePath, HtmlReporter.TreeInfo tree, FullProjectInfo projectInfo) {
        this(context, basePath, tree, projectInfo, RenderProjectCoverageCloudsAction.sortedAppClassesFor(projectInfo));
    }

    public RenderProjectCoverageCloudsAction(VelocityContext context, File basePath, HtmlReporter.TreeInfo tree, FullProjectInfo projectInfo, List classes) {
        super(context, tree, classes, basePath);
        this.projectInfo = projectInfo;
    }

    protected File createOutputDir() {
        return this.basePath;
    }

    protected TabInfo createRisksTab() {
        return new TabInfo("Project Risks", "proj-risks.html", "help_pkg_risks");
    }

    private static List sortedAppClassesFor(FullProjectInfo model) {
        List<? extends BaseClassInfo> classes = model.getClasses(new TestClassFilter());
        Collections.sort(classes, HasMetricsSupport.CMP_LEX);
        return classes;
    }

    protected void applySpecificProperties() {
        this.context.put("projectInfo", this.projectInfo);
        this.context.put("headerMetrics", this.projectInfo.getMetrics());
        this.context.put("headerMetricsRaw", this.projectInfo.getRawMetrics());
        this.context.put("siblingPresent", Boolean.TRUE);
        this.context.put("topLevel", Boolean.TRUE);
        HtmlReportUtil.addFilteredPercentageToContext(this.context, this.projectInfo);
    }

    protected void applyAxies(ClassInfoStatsCalculator axis1, ClassInfoStatsCalculator axis2) {
        this.applyAxis("deep", axis1, axis2, this.classes);
    }
}

