/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.util;

import com.atlassian.clover.api.registry.BranchInfo;
import com.atlassian.clover.api.registry.EntityVisitor;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.api.registry.StatementInfo;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityVisitorUtils {
    public final CheckParent CHECK_PARENT = new CheckParent();
    public final GetParent GET_PARENT = new GetParent();

    public boolean isInnerMethod(@NotNull MethodInfo thisMethod) {
        return this.CHECK_PARENT.isMethod(thisMethod);
    }

    public boolean isParentAnInnerMethod(@NotNull StatementInfo thisStatement) {
        MethodInfo parentMethod = this.GET_PARENT.asMethod(thisStatement);
        return parentMethod != null && this.CHECK_PARENT.isMethod(parentMethod);
    }

    public boolean isParentAnInnerMethod(@NotNull BranchInfo thisBranch) {
        MethodInfo parentMethod = this.GET_PARENT.asMethod(thisBranch);
        return parentMethod != null && this.CHECK_PARENT.isMethod(parentMethod);
    }

    public boolean isParentALambdaMethod(@NotNull StatementInfo thisStatement) {
        MethodInfo parentMethod = this.GET_PARENT.asMethod(thisStatement);
        return parentMethod != null && parentMethod.isLambda();
    }

    public boolean isParentALambdaMethod(@NotNull BranchInfo thisBranch) {
        MethodInfo parentMethod = this.GET_PARENT.asMethod(thisBranch);
        return parentMethod != null && parentMethod.isLambda();
    }

    public boolean isParentAMethod(@NotNull StatementInfo thisStatement) {
        return this.CHECK_PARENT.isMethod(thisStatement);
    }

    public boolean isParentAMethod(@NotNull BranchInfo thisBranch) {
        return this.CHECK_PARENT.isMethod(thisBranch);
    }

    public static class GetParent {
        private final AtomicReference<MethodInfo> parentMethod = new AtomicReference();
        private final EntityVisitor parentMethodVisitor = new EntityVisitor(){

            public void visitMethod(@NotNull MethodInfo parent) {
                GetParent.this.parentMethod.set(parent);
            }
        };

        @Nullable
        public MethodInfo asMethod(@NotNull MethodInfo thisMethod) {
            this.parentMethod.set(null);
            thisMethod.getParent().visit(this.parentMethodVisitor);
            return this.parentMethod.get();
        }

        @Nullable
        public MethodInfo asMethod(@NotNull StatementInfo thisStatement) {
            this.parentMethod.set(null);
            thisStatement.getParent().visit(this.parentMethodVisitor);
            return this.parentMethod.get();
        }

        @Nullable
        public MethodInfo asMethod(@NotNull BranchInfo thisBranch) {
            this.parentMethod.set(null);
            thisBranch.getParent().visit(this.parentMethodVisitor);
            return this.parentMethod.get();
        }
    }

    public static class CheckParent {
        private final AtomicBoolean isMethod = new AtomicBoolean();
        private final EntityVisitor isMethodVisitor = new EntityVisitor(){

            public void visitMethod(@NotNull MethodInfo parentMethod) {
                CheckParent.this.isMethod.set(true);
            }
        };

        public boolean isMethod(@NotNull MethodInfo thisMethod) {
            this.isMethod.set(false);
            thisMethod.getParent().visit(this.isMethodVisitor);
            return this.isMethod.get();
        }

        public boolean isMethod(@NotNull StatementInfo thisStatement) {
            this.isMethod.set(false);
            thisStatement.getParent().visit(this.isMethodVisitor);
            return this.isMethod.get();
        }

        public boolean isMethod(@NotNull BranchInfo thisBranch) {
            this.isMethod.set(false);
            thisBranch.getParent().visit(this.isMethodVisitor);
            return this.isMethod.get();
        }
    }
}

