/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.format;

import com.atlassian.clover.Logger;
import com.atlassian.clover.context.ContextSet;
import com.atlassian.clover.context.ContextStore;
import com.atlassian.clover.context.MethodRegexpContext;
import com.atlassian.clover.context.StatementRegexpContext;
import com.atlassian.clover.io.tags.TaggedDataInput;
import com.atlassian.clover.io.tags.TaggedIO;
import com.atlassian.clover.io.tags.TaggedPersistent;
import com.atlassian.clover.io.tags.Tags;
import com.atlassian.clover.registry.FixedSourceRegion;
import com.atlassian.clover.registry.RegistryFormatException;
import com.atlassian.clover.registry.entities.AnnotationImpl;
import com.atlassian.clover.registry.entities.ArrayAnnotationValue;
import com.atlassian.clover.registry.entities.FullBranchInfo;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullMethodInfo;
import com.atlassian.clover.registry.entities.FullStatementInfo;
import com.atlassian.clover.registry.entities.MethodSignature;
import com.atlassian.clover.registry.entities.Modifiers;
import com.atlassian.clover.registry.entities.Parameter;
import com.atlassian.clover.registry.entities.StringifiedAnnotationValue;
import com.atlassian.clover.registry.format.BufferUtils;
import com.atlassian.clover.registry.format.FileInfoRecord;
import com.atlassian.clover.registry.format.LazyLoader;
import com.atlassian.clover.registry.format.LazyProxy;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrSessionSegment {
    static final long NONE_IDX = -1L;
    static final Tags TAGS = new Tags().registerTag(FullFileInfo.class.getName(), 9, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<FullFileInfo>(){

        @Override
        public FullFileInfo read(TaggedDataInput in) throws IOException {
            return FullFileInfo.read(in);
        }
    }).registerTag(FullClassInfo.class.getName(), 10, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<FullClassInfo>(){

        @Override
        public FullClassInfo read(TaggedDataInput in) throws IOException {
            return FullClassInfo.read(in);
        }
    }).registerTag(FullMethodInfo.class.getName(), 11, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<FullMethodInfo>(){

        @Override
        public FullMethodInfo read(TaggedDataInput in) throws IOException {
            return FullMethodInfo.read(in);
        }
    }).registerTag(FullStatementInfo.class.getName(), 12, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<FullStatementInfo>(){

        @Override
        public FullStatementInfo read(TaggedDataInput in) throws IOException {
            return FullStatementInfo.read(in);
        }
    }).registerTag(FullBranchInfo.class.getName(), 13, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<FullBranchInfo>(){

        @Override
        public FullBranchInfo read(TaggedDataInput in) throws IOException {
            return FullBranchInfo.read(in);
        }
    }).registerTag(ContextSet.class.getName(), 14, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<ContextSet>(){

        @Override
        public ContextSet read(TaggedDataInput in) throws IOException {
            return ContextSet.read(in);
        }
    }).registerTag(FixedSourceRegion.class.getName(), 15, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<FixedSourceRegion>(){

        @Override
        public FixedSourceRegion read(TaggedDataInput in) throws IOException {
            return FixedSourceRegion.read(in);
        }
    }).registerTag(MethodSignature.class.getName(), 16, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<MethodSignature>(){

        @Override
        public MethodSignature read(TaggedDataInput in) throws IOException {
            return MethodSignature.read(in);
        }
    }).registerTag(Modifiers.class.getName(), 17, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<Modifiers>(){

        @Override
        public Modifiers read(TaggedDataInput in) throws IOException {
            return Modifiers.read(in);
        }
    }).registerTag(Parameter.class.getName(), 18, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<Parameter>(){

        @Override
        public Parameter read(TaggedDataInput in) throws IOException {
            return Parameter.read(in);
        }
    }).registerTag(AnnotationImpl.class.getName(), 19, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<AnnotationImpl>(){

        @Override
        public AnnotationImpl read(TaggedDataInput in) throws IOException {
            return AnnotationImpl.read(in);
        }
    }).registerTag(ArrayAnnotationValue.class.getName(), 20, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<ArrayAnnotationValue>(){

        @Override
        public ArrayAnnotationValue read(TaggedDataInput in) throws IOException {
            return ArrayAnnotationValue.read(in);
        }
    }).registerTag(StringifiedAnnotationValue.class.getName(), 21, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<StringifiedAnnotationValue>(){

        @Override
        public StringifiedAnnotationValue read(TaggedDataInput in) throws IOException {
            return StringifiedAnnotationValue.read(in);
        }
    }).registerTag(ContextStore.class.getName(), 22, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<ContextStore>(){

        @Override
        public ContextStore read(TaggedDataInput in) throws IOException {
            return ContextStore.read(in);
        }
    }).registerTag(StatementRegexpContext.class.getName(), 23, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<StatementRegexpContext>(){

        @Override
        public StatementRegexpContext read(TaggedDataInput in) throws IOException {
            return StatementRegexpContext.read(in);
        }
    }).registerTag(MethodRegexpContext.class.getName(), 24, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<MethodRegexpContext>(){

        @Override
        public MethodRegexpContext read(TaggedDataInput in) throws IOException {
            return MethodRegexpContext.read(in);
        }
    });
    private final long version;
    private final long startTs;
    private final long endTs;
    private final List<FileInfoRecord> fileInfoRecords;
    private final LazyProxy<ContextStore> ctxStore;

    public InstrSessionSegment(FileChannel channel) throws IOException {
        long endOfSegment = channel.position();
        Footer footer = this.loadFooter(channel, endOfSegment);
        this.version = footer.version;
        this.startTs = footer.startTs;
        this.endTs = footer.endTs;
        this.ctxStore = new LazyLoader<ContextStore>(channel, endOfSegment - 40L - (long)footer.ctxStoreByteLen + 1L){

            @Override
            protected ContextStore getImpl(FileChannel channel) throws IOException, RegistryFormatException {
                return InstrSessionSegment.this.loadContextStore(channel);
            }
        };
        this.fileInfoRecords = this.loadFileInfos(channel, endOfSegment, footer.fileInfosByteLen, footer.ctxStoreByteLen, footer.numRecords);
        channel.position(Math.max(0L, endOfSegment - 40L - (long)footer.fileInfosByteLen - (long)footer.ctxStoreByteLen));
    }

    public InstrSessionSegment(long version, long startTs, long endTs, List<FileInfoRecord> fileInfoRecords, ContextStore ctxStore) {
        this.version = version;
        this.startTs = startTs;
        this.endTs = endTs;
        this.fileInfoRecords = Collections.unmodifiableList(new LinkedList<FileInfoRecord>(fileInfoRecords));
        this.ctxStore = new LazyProxy.Preloaded<ContextStore>(ctxStore);
    }

    private Footer loadFooter(FileChannel channel, long endOfSegment) throws IOException {
        channel.position(endOfSegment - 40L + 1L);
        ByteBuffer footerBuffer = BufferUtils.readFully(channel, ByteBuffer.allocate(40));
        Footer footer = new Footer(footerBuffer.getInt(), footerBuffer.getInt(), footerBuffer.getInt(), footerBuffer.getLong(), footerBuffer.getLong(), footerBuffer.getLong());
        Logger.getInstance().debug("Loaded InstrumentationSession footer: " + footer);
        if (footerBuffer.getInt() != 56026) {
            throw new IOException("InstrSessionSegment did not start with marker 0x" + Integer.toHexString(56026));
        }
        return footer;
    }

    private List<FileInfoRecord> loadFileInfos(FileChannel channel, long endOfSegment, int fileInfosByteLen, int offset, int numRecords) throws IOException {
        long startRecPos = endOfSegment - 40L - (long)offset - (long)fileInfosByteLen + 1L;
        Logger.getInstance().debug("Loading InstrumentationSession: Loading FileInfos: setting channel position to " + startRecPos + " out of " + channel.size());
        channel.position(startRecPos);
        LinkedList<FileInfoRecord> fileInfos = new LinkedList<FileInfoRecord>();
        for (int i = 0; i < numRecords; ++i) {
            fileInfos.add(new FileInfoRecord(channel));
        }
        return Collections.unmodifiableList(fileInfos);
    }

    private ContextStore loadContextStore(FileChannel channel) throws IOException {
        return TaggedIO.read(channel, TAGS, ContextStore.class);
    }

    public Collection<FileInfoRecord> getFileInfoRecords() {
        return this.fileInfoRecords;
    }

    public long getVersion() {
        return this.version;
    }

    public long getStartTs() {
        return this.startTs;
    }

    public long getEndTs() {
        return this.endTs;
    }

    public ContextStore getCtxStore() {
        return this.ctxStore.get();
    }

    public void write(FileChannel channel) throws IOException {
        long startPos = channel.position();
        for (FileInfoRecord fileInfo : this.fileInfoRecords) {
            fileInfo.write(channel);
        }
        long afterFileInfosPos = channel.position();
        TaggedIO.write(channel, TAGS, ContextStore.class, (TaggedPersistent)this.ctxStore.get());
        long afterCtxStorePos = channel.position();
        ByteBuffer headerBuffer = ByteBuffer.allocate(40);
        headerBuffer.putInt((int)(afterFileInfosPos - startPos));
        headerBuffer.putInt((int)(afterCtxStorePos - afterFileInfosPos));
        headerBuffer.putInt(this.fileInfoRecords.size());
        headerBuffer.putLong(this.endTs);
        headerBuffer.putLong(this.startTs);
        headerBuffer.putLong(this.version);
        headerBuffer.putInt(56026);
        headerBuffer.flip();
        BufferUtils.writeFully(channel, headerBuffer);
    }

    private static class Footer {
        public static final int SIZE = 40;
        public static final int MARKER = 56026;
        public final int fileInfosByteLen;
        public final int ctxStoreByteLen;
        public final int numRecords;
        public final long endTs;
        public final long startTs;
        public final long version;

        private Footer(int fileInfosByteLen, int ctxStoreByteLen, int numRecords, long endTs, long startTs, long version) {
            this.fileInfosByteLen = fileInfosByteLen;
            this.ctxStoreByteLen = ctxStoreByteLen;
            this.numRecords = numRecords;
            this.endTs = endTs;
            this.startTs = startTs;
            this.version = version;
        }

        public String toString() {
            return "Footer{fileInfosByteLen=" + this.fileInfosByteLen + ", ctxStoreByteLen=" + this.ctxStoreByteLen + ", numRecords=" + this.numRecords + ", endTs=" + this.endTs + ", startTs=" + this.startTs + ", version=" + this.version + '}';
        }
    }
}

