/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.format;

import com.atlassian.clover.io.tags.TaggedIO;
import com.atlassian.clover.io.tags.TaggedPersistent;
import com.atlassian.clover.registry.RegistryFormatException;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.format.InstrSessionSegment;
import com.atlassian.clover.registry.format.LazyLoader;
import com.atlassian.clover.registry.format.LazyProxy;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;

public class FileInfoRecord {
    private static final int MARKER = 974110;
    private final String name;
    private final String packageName;
    private final LazyProxy<FullFileInfo> fileInfo;

    public FileInfoRecord(FullFileInfo fileInfo) {
        this.name = fileInfo.getName();
        this.packageName = fileInfo.getContainingPackage().getName();
        this.fileInfo = new LazyProxy.Preloaded<FullFileInfo>(fileInfo);
    }

    public FileInfoRecord(FileChannel channel) throws IOException {
        DataInputStream in = new DataInputStream(Channels.newInputStream(channel));
        int mayBeMarker = in.readInt();
        if (mayBeMarker != 974110) {
            throw new IOException("FileInfoRecord did not start with marker 0x" + Integer.toHexString(974110) + ", started with 0x" + Integer.toHexString(mayBeMarker) + " instead");
        }
        this.name = in.readUTF();
        this.packageName = in.readUTF();
        long endPos = (long)in.readInt() + channel.position();
        this.fileInfo = new LazyLoader<FullFileInfo>(channel, channel.position()){

            @Override
            protected FullFileInfo getImpl(FileChannel channel) throws IOException, RegistryFormatException {
                return TaggedIO.read(channel, InstrSessionSegment.TAGS, FullFileInfo.class);
            }
        };
        channel.position(endPos);
    }

    public String getName() {
        return this.name == null ? this.getFileInfo().getName() : this.name;
    }

    public String getPackageName() {
        return this.packageName == null ? this.getFileInfo().getContainingPackage().getName() : this.packageName;
    }

    public FullFileInfo getFileInfo() {
        return this.fileInfo.get();
    }

    public void write(FileChannel channel) throws IOException {
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(Channels.newOutputStream(channel)));
        out.writeInt(974110);
        out.writeUTF(this.getName());
        out.writeUTF(this.getPackageName());
        out.flush();
        long lengthPos = channel.position();
        out.writeInt(-1);
        out.flush();
        TaggedIO.write(channel, InstrSessionSegment.TAGS, FullFileInfo.class, (TaggedPersistent)this.fileInfo.get());
        long endPos = channel.position();
        long fileInfoSize = endPos - lengthPos - 4L;
        channel.position(lengthPos);
        out.writeInt((int)fileInfoSize);
        out.flush();
        channel.position(endPos);
    }
}

