/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.entities;

import com.atlassian.clover.api.registry.BranchInfo;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.EntityContainer;
import com.atlassian.clover.api.registry.EntityVisitor;
import com.atlassian.clover.api.registry.FileInfo;
import com.atlassian.clover.api.registry.HasAggregatedMetrics;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.api.registry.SourceInfo;
import com.atlassian.clover.api.registry.StatementInfo;
import com.atlassian.clover.context.ContextSet;
import com.atlassian.clover.io.tags.TaggedDataInput;
import com.atlassian.clover.io.tags.TaggedDataOutput;
import com.atlassian.clover.io.tags.TaggedPersistent;
import com.atlassian.clover.lang.Languages;
import com.atlassian.clover.registry.CoverageDataProvider;
import com.atlassian.clover.registry.FileElementVisitor;
import com.atlassian.clover.registry.FixedSourceRegion;
import com.atlassian.clover.registry.entities.BasicMethodInfo;
import com.atlassian.clover.registry.entities.FullBranchInfo;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.FullElementInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullStatementInfo;
import com.atlassian.clover.registry.entities.MethodSignature;
import com.atlassian.clover.registry.entities.ParentEntity;
import com.atlassian.clover.registry.metrics.BlockMetrics;
import com.atlassian.clover.registry.metrics.HasMetricsNode;
import com.atlassian.clover.spi.lang.LanguageConstruct;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullMethodInfo
extends FullElementInfo<BasicMethodInfo>
implements HasAggregatedMetrics,
HasMetricsNode,
TaggedPersistent,
MethodInfo {
    public static final int DEFAULT_METHOD_COMPLEXITY = 1;
    private List<FullStatementInfo> statements = new ArrayList<FullStatementInfo>();
    private List<FullBranchInfo> branches = new ArrayList<FullBranchInfo>();
    private List<FullClassInfo> innerClasses = new ArrayList<FullClassInfo>();
    private List<FullMethodInfo> innerMethods = new ArrayList<FullMethodInfo>();
    private int aggregatedStatementCount;
    private int aggregatedComplexity;
    private transient com.atlassian.clover.api.registry.BlockMetrics rawMetrics;
    private transient com.atlassian.clover.api.registry.BlockMetrics metrics;
    private transient com.atlassian.clover.api.registry.ContextSet contextFilter;
    private transient CoverageDataProvider data;
    private transient ParentEntity parent;

    public FullMethodInfo(FullClassInfo containingClass, int relativeDataIndex, com.atlassian.clover.api.registry.ContextSet context, SourceInfo region, MethodSignature signature, boolean isTest, String staticTestName, boolean isLambda, int complexity) {
        this(containingClass, relativeDataIndex, context, region, signature, isTest, staticTestName, isLambda, complexity, LanguageConstruct.Builtin.METHOD);
    }

    public FullMethodInfo(FullClassInfo containingClass, int relativeDataIndex, com.atlassian.clover.api.registry.ContextSet context, SourceInfo region, MethodSignature signature, boolean isTest, String staticTestName, boolean isLambda, int complexity, LanguageConstruct construct) {
        this(containingClass, context, new BasicMethodInfo(region, relativeDataIndex, complexity, signature, isTest, staticTestName, isLambda, construct));
    }

    public FullMethodInfo(FullClassInfo containingClass, com.atlassian.clover.api.registry.ContextSet context, BasicMethodInfo methodInfo) {
        super(context, methodInfo);
        this.parent = new ParentEntity(containingClass);
    }

    public FullMethodInfo(FullMethodInfo containingMethod, com.atlassian.clover.api.registry.ContextSet context, BasicMethodInfo methodInfo) {
        super(context, methodInfo);
        this.parent = new ParentEntity(containingMethod);
    }

    public FullMethodInfo(FullFileInfo containingFile, com.atlassian.clover.api.registry.ContextSet context, BasicMethodInfo methodInfo) {
        super(context, methodInfo);
        this.parent = new ParentEntity(containingFile);
    }

    private FullMethodInfo(MethodSignature signature, com.atlassian.clover.api.registry.ContextSet context, int relativeDataIndex, int dataLength, int complexity, LanguageConstruct construct, SourceInfo region, boolean isTest, String staticTestName, boolean isLambda, List<FullStatementInfo> statements, List<FullBranchInfo> branches, List<FullClassInfo> classes, List<FullMethodInfo> methods) {
        super(context, new BasicMethodInfo(region, relativeDataIndex, dataLength, complexity, signature, isTest, staticTestName, isLambda, construct));
        this.statements = statements;
        this.branches = branches;
        this.innerClasses = classes;
        this.innerMethods = methods;
    }

    @Override
    public String getName() {
        return ((BasicMethodInfo)this.sharedInfo).getName();
    }

    @Override
    public String getSimpleName() {
        return ((BasicMethodInfo)this.sharedInfo).getSignature().getName();
    }

    @Override
    @NotNull
    public MethodSignature getSignature() {
        return ((BasicMethodInfo)this.sharedInfo).getSignature();
    }

    @Override
    public String getQualifiedName() {
        String prefix = this.parent.getContainingClass() != null ? this.parent.getContainingClass().getQualifiedName() : (this.parent.getContainingMethod() != null ? this.parent.getContainingMethod().getQualifiedName() : "");
        return prefix + "." + ((BasicMethodInfo)this.sharedInfo).getSignature().getName();
    }

    @Override
    @Nullable
    public ClassInfo getContainingClass() {
        return this.parent.getContainingClass();
    }

    @Override
    @Nullable
    public MethodInfo getContainingMethod() {
        return this.parent.getContainingMethod();
    }

    @Override
    public boolean isTest() {
        return ((BasicMethodInfo)this.sharedInfo).isTest();
    }

    @Override
    @Nullable
    public String getStaticTestName() {
        return ((BasicMethodInfo)this.sharedInfo).getStaticTestName();
    }

    @Override
    public boolean isLambda() {
        return ((BasicMethodInfo)this.sharedInfo).isLambda();
    }

    @Override
    public boolean isEmpty() {
        return this.statements.size() == 0 && this.branches.size() == 0;
    }

    @Override
    public com.atlassian.clover.api.registry.ContextSet getContextFilter() {
        return this.contextFilter != null ? this.contextFilter : this.getParentContextFilter();
    }

    @Override
    public int getAggregatedStatementCount() {
        return this.aggregatedStatementCount;
    }

    @Override
    public void setAggregatedStatementCount(int aggregatedStatementCount) {
        this.aggregatedStatementCount = aggregatedStatementCount;
    }

    public void increaseAggregatedStatementCount(int increment) {
        this.aggregatedStatementCount += increment;
    }

    @Override
    public int getAggregatedComplexity() {
        return this.aggregatedComplexity;
    }

    @Override
    public void setAggregatedComplexity(int aggregatedComplexity) {
        this.aggregatedComplexity = aggregatedComplexity;
    }

    public void increaseAggregatedComplexity(int increment) {
        this.aggregatedComplexity += increment;
    }

    public void addClass(FullClassInfo classInfo) {
        this.innerClasses.add(classInfo);
    }

    public void addMethod(FullMethodInfo methodInfo) {
        this.innerMethods.add(methodInfo);
    }

    @Override
    @NotNull
    public List<? extends ClassInfo> getClasses() {
        return new ArrayList<FullClassInfo>(this.innerClasses);
    }

    @Override
    @NotNull
    public List<? extends ClassInfo> getAllClasses() {
        ArrayList<ClassInfo> allClasses = new ArrayList<ClassInfo>();
        for (FullClassInfo classInfo : this.innerClasses) {
            allClasses.add(classInfo);
            allClasses.addAll(classInfo.getAllClasses());
        }
        for (FullMethodInfo methodInfo : this.innerMethods) {
            allClasses.addAll(methodInfo.getAllClasses());
        }
        return allClasses;
    }

    @Override
    @NotNull
    public List<? extends MethodInfo> getMethods() {
        return new ArrayList<FullMethodInfo>(this.innerMethods);
    }

    @Override
    @NotNull
    public List<? extends MethodInfo> getAllMethods() {
        ArrayList<MethodInfo> allMethods = new ArrayList<MethodInfo>();
        for (FullMethodInfo methodInfo : this.innerMethods) {
            allMethods.add(methodInfo);
            allMethods.addAll(methodInfo.getAllMethods());
        }
        for (FullClassInfo classInfo : this.innerClasses) {
            allMethods.addAll(classInfo.getAllMethods());
        }
        return allMethods;
    }

    public void addStatement(FullStatementInfo stmt) {
        this.statements.add(stmt);
    }

    public void addBranch(FullBranchInfo branch) {
        this.branches.add(branch);
    }

    @Override
    @NotNull
    public List<? extends StatementInfo> getStatements() {
        return new ArrayList<FullStatementInfo>(this.statements);
    }

    @Override
    @NotNull
    public List<? extends BranchInfo> getBranches() {
        return new ArrayList<FullBranchInfo>(this.branches);
    }

    public int getBranchCount() {
        return this.branches.size();
    }

    private com.atlassian.clover.api.registry.ContextSet getParentContextFilter() {
        final AtomicReference parentContextFilter = new AtomicReference();
        this.parent.getParentEntity().visit(new EntityVisitor(){

            public void visitFile(FileInfo parentFile) {
                parentContextFilter.set(parentFile.getContextFilter());
            }

            public void visitClass(ClassInfo parentClass) {
                parentContextFilter.set(parentClass.getContextFilter());
            }

            public void visitMethod(MethodInfo parentMethod) {
                parentContextFilter.set(parentMethod.getContextFilter());
            }
        });
        return (com.atlassian.clover.api.registry.ContextSet)parentContextFilter.get();
    }

    @Override
    public com.atlassian.clover.api.registry.BlockMetrics getMetrics() {
        com.atlassian.clover.api.registry.ContextSet parentContextFilter = this.getParentContextFilter();
        if (this.metrics == null || parentContextFilter != this.contextFilter) {
            this.contextFilter = parentContextFilter;
            this.metrics = this.calcMetrics(this.contextFilter);
        }
        return this.metrics;
    }

    @Override
    public com.atlassian.clover.api.registry.BlockMetrics getRawMetrics() {
        if (this.rawMetrics == null) {
            this.rawMetrics = this.calcMetrics(null);
        }
        return this.rawMetrics;
    }

    @Override
    public void setMetrics(com.atlassian.clover.api.registry.BlockMetrics metrics) {
        this.metrics = metrics;
    }

    @Override
    public void setDataProvider(CoverageDataProvider data) {
        this.data = data;
        for (FullMethodInfo methodInfo : this.innerMethods) {
            methodInfo.setDataProvider(data);
        }
        for (FullClassInfo classInfo : this.innerClasses) {
            classInfo.setDataProvider(data);
        }
        this.rawMetrics = null;
        this.metrics = null;
    }

    public void gatherSourceRegions(Set<SourceInfo> regions) {
        regions.add(this);
        regions.addAll(this.statements);
        regions.addAll(this.branches);
        for (FullClassInfo classInfo : this.innerClasses) {
            classInfo.gatherSourceRegions(regions);
        }
        for (FullMethodInfo methodInfo : this.innerMethods) {
            methodInfo.gatherSourceRegions(regions);
        }
    }

    @Override
    public void visit(EntityVisitor entityVisitor) {
        entityVisitor.visitMethod(this);
    }

    public void visit(FileElementVisitor visitor) {
        visitor.visitMethod(this);
        for (FullStatementInfo statementInfo : this.statements) {
            visitor.visitStatement(statementInfo);
        }
        for (FullBranchInfo branchInfo : this.branches) {
            visitor.visitBranch(branchInfo);
        }
        for (FullClassInfo classInfo : this.innerClasses) {
            classInfo.visitElements(visitor);
        }
        for (FullMethodInfo methodInfo : this.innerMethods) {
            methodInfo.visit(visitor);
        }
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public int getNumChildren() {
        return 0;
    }

    @Override
    public String getChildType() {
        return null;
    }

    @Override
    public HasMetricsNode getChild(int i) {
        return null;
    }

    @Override
    public int getIndexOfChild(HasMetricsNode child) {
        return -1;
    }

    @Override
    public void setComparator(Comparator cmp) {
    }

    private com.atlassian.clover.api.registry.BlockMetrics calcMetrics(com.atlassian.clover.api.registry.ContextSet contextSet) {
        BlockMetrics blockMetrics = new BlockMetrics(this);
        int covered = 0;
        int numStatements = 0;
        int numBranches = 0;
        int complexity = 1;
        for (FullClassInfo classInfo : this.innerClasses) {
            blockMetrics.add(classInfo.getMetrics());
        }
        for (FullMethodInfo methodInfo : this.innerMethods) {
            blockMetrics.add(methodInfo.getMetrics());
        }
        for (FullStatementInfo statementInfo : this.statements) {
            if (statementInfo.isFiltered(contextSet)) continue;
            if (statementInfo.getHitCount() > 0) {
                ++covered;
            }
            complexity += statementInfo.getComplexity();
            ++numStatements;
        }
        blockMetrics.addNumCoveredStatements(covered);
        blockMetrics.addNumStatements(numStatements);
        covered = 0;
        for (FullBranchInfo branchInfo : this.branches) {
            if (branchInfo.isFiltered(contextSet)) continue;
            if (branchInfo.getTrueHitCount() > 0) {
                ++covered;
            }
            if (branchInfo.getFalseHitCount() > 0) {
                ++covered;
            }
            complexity += branchInfo.getComplexity();
            numBranches += 2;
        }
        blockMetrics.addNumCoveredBranches(covered);
        blockMetrics.addNumBranches(numBranches);
        int totalComplexity = blockMetrics.getComplexity() + complexity;
        blockMetrics.setComplexity(totalComplexity);
        this.setComplexity(totalComplexity);
        return blockMetrics;
    }

    private void copyMethodInternals(FullMethodInfo targetMethod) {
        targetMethod.setDataProvider(this.getDataProvider());
        for (FullStatementInfo statementInfo : this.statements) {
            targetMethod.addStatement(statementInfo.copy(targetMethod));
        }
        for (FullBranchInfo branchInfo : this.branches) {
            targetMethod.addBranch(branchInfo.copy(targetMethod));
        }
        for (FullClassInfo classInfo : this.innerClasses) {
            targetMethod.addClass(classInfo);
        }
        for (FullMethodInfo methodInfo : this.innerMethods) {
            targetMethod.addMethod(methodInfo);
        }
        targetMethod.setDataLength(this.getDataLength());
    }

    public FullMethodInfo copy(FullClassInfo classAsParent) {
        FullMethodInfo method = new FullMethodInfo(classAsParent, this.getContext(), (BasicMethodInfo)this.sharedInfo);
        this.copyMethodInternals(method);
        return method;
    }

    public FullMethodInfo copy(FullMethodInfo methodAsParent) {
        FullMethodInfo method = new FullMethodInfo(methodAsParent, this.getContext(), (BasicMethodInfo)this.sharedInfo);
        this.copyMethodInternals(method);
        return method;
    }

    public FullMethodInfo copy(FullFileInfo fileAsParent) {
        FullMethodInfo method = new FullMethodInfo(fileAsParent, this.getContext(), (BasicMethodInfo)this.sharedInfo);
        this.copyMethodInternals(method);
        return method;
    }

    public boolean isPublic() {
        return Modifier.isPublic(((BasicMethodInfo)this.sharedInfo).getSignature().getModifiersMask());
    }

    public String getVisibility() {
        return ((BasicMethodInfo)this.sharedInfo).getSignature().getModifiers().getVisibility();
    }

    @Override
    public CoverageDataProvider getDataProvider() {
        return this.data;
    }

    @Override
    public int getDataLength() {
        return ((BasicMethodInfo)this.sharedInfo).getDataLength();
    }

    public void setDataLength(int length) {
        ((BasicMethodInfo)this.sharedInfo).setDataLength(length);
    }

    protected void setContainingClass(FullClassInfo classInfo) {
        this.parent = new ParentEntity(classInfo);
    }

    protected void setContainingMethod(FullMethodInfo methodInfo) {
        this.parent = new ParentEntity(methodInfo);
    }

    protected void setContainingFile(FullFileInfo fileInfo) {
        if (this.parent == null) {
            this.parent = new ParentEntity(fileInfo);
        } else {
            this.parent.setContainingFile(fileInfo);
        }
    }

    @Override
    @Nullable
    public FileInfo getContainingFile() {
        return this.parent.getContainingFile();
    }

    @Override
    @NotNull
    public EntityContainer getParent() {
        return this.parent.getParentEntity();
    }

    public void setRegionEnd(int endLine, int endCol) {
        SourceInfo region = ((BasicMethodInfo)this.sharedInfo).getRegion();
        ((BasicMethodInfo)this.sharedInfo).setRegion(new FixedSourceRegion(region.getStartLine(), region.getStartColumn(), endLine, endCol));
    }

    public void setStaticTestName(String staticTestName) {
        ((BasicMethodInfo)this.sharedInfo).setStaticTestName(staticTestName);
    }

    @Override
    public void write(TaggedDataOutput out) throws IOException {
        out.write(MethodSignature.class, ((BasicMethodInfo)this.sharedInfo).getSignature());
        out.writeUTF(this.getStaticTestName());
        out.writeBoolean(this.isTest());
        out.writeBoolean(this.isLambda());
        out.write(ContextSet.class, (ContextSet)this.context);
        out.writeInt(((BasicMethodInfo)this.sharedInfo).getRelativeDataIndex());
        out.writeInt(this.getDataLength());
        out.writeInt(this.getComplexity());
        out.writeInt(this.getAggregatedComplexity());
        out.writeInt(this.getAggregatedStatementCount());
        out.writeUTF(((BasicMethodInfo)this.sharedInfo).getConstruct().getId());
        FixedSourceRegion.writeRaw(this, out);
        out.writeList(FullStatementInfo.class, this.statements);
        out.writeList(FullBranchInfo.class, this.branches);
        out.writeList(FullClassInfo.class, this.innerClasses);
        out.writeList(FullMethodInfo.class, this.innerMethods);
    }

    public static FullMethodInfo read(TaggedDataInput in) throws IOException {
        MethodSignature signature = in.read(MethodSignature.class);
        String staticTestName = in.readUTF();
        boolean isTest = in.readBoolean();
        boolean isLambda = in.readBoolean();
        com.atlassian.clover.api.registry.ContextSet context = in.read(ContextSet.class);
        int index = in.readInt();
        int length = in.readInt();
        int complexity = in.readInt();
        int aggregatedComplexity = in.readInt();
        int aggregatedStatements = in.readInt();
        LanguageConstruct construct = Languages.lookupConstruct(in.readUTF());
        FixedSourceRegion region = FixedSourceRegion.read(in);
        List<FullStatementInfo> statements = in.readList(FullStatementInfo.class);
        List<FullBranchInfo> branches = in.readList(FullBranchInfo.class);
        List<FullClassInfo> innerClasses = in.readList(FullClassInfo.class);
        List<FullMethodInfo> innerMethods = in.readList(FullMethodInfo.class);
        FullMethodInfo methodInfo = new FullMethodInfo(signature, context, index, length, complexity, construct, region, isTest, staticTestName, isLambda, statements, branches, innerClasses, innerMethods);
        methodInfo.setAggregatedComplexity(aggregatedComplexity);
        methodInfo.setAggregatedStatementCount(aggregatedStatements);
        for (FullStatementInfo statement : statements) {
            statement.setContainingMethod(methodInfo);
        }
        for (FullBranchInfo branch : branches) {
            branch.setContainingMethod(methodInfo);
        }
        for (FullClassInfo innerClass : innerClasses) {
            innerClass.setContainingMethod(methodInfo);
        }
        for (FullMethodInfo innerMethod : innerMethods) {
            innerMethod.setContainingMethod(methodInfo);
        }
        return methodInfo;
    }

    public String toString() {
        return "FullMethodInfo{sharedInfo='" + this.sharedInfo + '\'' + " aggregatedComplexity=" + this.aggregatedComplexity + " aggregatedStatementCount=" + this.aggregatedStatementCount + "} ";
    }
}

