/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import com.atlassian.clover.context.ContextSet;

public class ContextTreeNode {
    private final ContextTreeNode parent;
    private final ContextSet context;
    private ContextTreeNode[] children;

    ContextTreeNode(ContextTreeNode parent, ContextSet context) {
        this.parent = parent;
        this.children = new ContextTreeNode[parent.children.length];
        this.context = context;
    }

    public ContextTreeNode(int childCount, ContextSet context) {
        this.parent = null;
        this.children = new ContextTreeNode[childCount];
        this.context = context;
    }

    public ContextTreeNode enterContext(int index) {
        ContextTreeNode child;
        if (index >= this.children.length) {
            ContextTreeNode[] children = new ContextTreeNode[this.children.length * 2];
            System.arraycopy(this.children, 0, children, 0, this.children.length);
        }
        if ((child = this.children[index]) == null) {
            ContextSet context = new ContextSet(this.context);
            context = context.set(index);
            this.children[index] = child = new ContextTreeNode(this, context);
        }
        return child;
    }

    public ContextTreeNode exitContext() {
        return this.parent;
    }

    public ContextSet getContext() {
        return this.context;
    }

    public int countSelfAndDescendants() {
        int count = 1;
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] == null) continue;
            count += this.children[i].countSelfAndDescendants();
        }
        return count;
    }
}

