/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.context;

import com.atlassian.clover.context.RegexpContext;
import com.atlassian.clover.instr.java.FileStructureInfo;
import com.atlassian.clover.io.tags.TaggedDataInput;
import com.atlassian.clover.io.tags.TaggedDataOutput;
import com.atlassian.clover.io.tags.TaggedPersistent;
import java.io.IOException;
import java.util.regex.Pattern;

public class MethodRegexpContext
extends RegexpContext
implements TaggedPersistent {
    private int maxComplexity;
    private int maxStatements;
    private int maxAggregatedComplexity;
    private int maxAggregatedStatements;

    public MethodRegexpContext(MethodRegexpContext ctx) {
        this(ctx.getIndex(), ctx.getName(), ctx.getPattern(), ctx.getMaxComplexity(), ctx.getMaxStatements(), ctx.getMaxAggregatedComplexity(), ctx.getMaxAggregatedStatements());
    }

    public MethodRegexpContext(String name, Pattern pattern) {
        this(name, pattern, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public MethodRegexpContext(String name, Pattern pattern, int maxComplexity, int maxStatements) {
        this(name, pattern, maxComplexity, maxStatements, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public MethodRegexpContext(String name, Pattern pattern, int maxComplexity, int maxStatements, int maxAggregatedComplexity, int maxAggregatedStatements) {
        this(-1, name, pattern, maxComplexity, maxStatements, maxAggregatedComplexity, maxAggregatedStatements);
    }

    public MethodRegexpContext(int index, String name, Pattern pattern) {
        this(index, name, pattern, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public MethodRegexpContext(int index, String name, Pattern pattern, int maxComplexity, int maxStatements, int maxAggregatedComplexity, int maxAggregatedStatements) {
        super(index, name, pattern);
        this.maxComplexity = maxComplexity;
        this.maxStatements = maxStatements;
        this.maxAggregatedComplexity = maxAggregatedComplexity;
        this.maxAggregatedStatements = maxAggregatedStatements;
    }

    public int getMaxComplexity() {
        return this.maxComplexity;
    }

    public int getMaxStatements() {
        return this.maxStatements;
    }

    public int getMaxAggregatedComplexity() {
        return this.maxAggregatedComplexity;
    }

    public int getMaxAggregatedStatements() {
        return this.maxAggregatedStatements;
    }

    public boolean matches(FileStructureInfo.MethodMarker methodMarker) {
        return super.matches(methodMarker.getNormalisedSignature()) && methodMarker.getMethod().getMetrics().getComplexity() <= this.maxComplexity && methodMarker.getMethod().getStatements().size() <= this.maxStatements && methodMarker.getMethod().getAggregatedComplexity() <= this.maxAggregatedComplexity && methodMarker.getMethod().getAggregatedStatementCount() <= this.maxAggregatedStatements;
    }

    public boolean isEquivalent(RegexpContext other) {
        return other instanceof MethodRegexpContext && ((MethodRegexpContext)other).getMaxComplexity() == this.maxComplexity && ((MethodRegexpContext)other).getMaxStatements() == this.maxStatements && ((MethodRegexpContext)other).getMaxAggregatedComplexity() == this.maxAggregatedComplexity && ((MethodRegexpContext)other).getMaxAggregatedStatements() == this.maxAggregatedStatements && super.isEquivalent(other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MethodRegexpContext that = (MethodRegexpContext)o;
        return this.maxComplexity == that.maxComplexity && this.maxStatements == that.maxStatements && this.maxAggregatedComplexity == that.maxAggregatedComplexity && this.maxAggregatedStatements == that.maxAggregatedStatements;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.maxComplexity;
        result = 31 * result + this.maxStatements;
        result = 31 * result + this.maxAggregatedComplexity;
        result = 31 * result + this.maxAggregatedStatements;
        return result;
    }

    public void write(TaggedDataOutput out) throws IOException {
        out.writeUTF(this.getName());
        out.writeInt(this.getIndex());
        out.writeUTF(this.getPattern().pattern());
        out.writeInt(this.maxComplexity);
        out.writeInt(this.maxStatements);
        out.writeInt(this.maxAggregatedComplexity);
        out.writeInt(this.maxAggregatedStatements);
    }

    public static MethodRegexpContext read(TaggedDataInput in) throws IOException {
        String name = in.readUTF();
        int index = in.readInt();
        Pattern pattern = Pattern.compile(in.readUTF());
        int maxComplexity = in.readInt();
        int maxStatements = in.readInt();
        int maxAggregatedComplexity = in.readInt();
        int maxAggregatedStatements = in.readInt();
        return new MethodRegexpContext(index, name, pattern, maxComplexity, maxStatements, maxAggregatedComplexity, maxAggregatedStatements);
    }
}

