/*
 * Decompiled with CFR 0.152.
 */
package clover.org.apache.velocity.runtime.parser.node;

import clover.org.apache.commons.lang.builder.ToStringBuilder;
import clover.org.apache.velocity.context.InternalContextAdapter;
import clover.org.apache.velocity.exception.MethodInvocationException;
import clover.org.apache.velocity.exception.ParseErrorException;
import clover.org.apache.velocity.exception.ResourceNotFoundException;
import clover.org.apache.velocity.exception.TemplateInitException;
import clover.org.apache.velocity.runtime.directive.Directive;
import clover.org.apache.velocity.runtime.parser.ParseException;
import clover.org.apache.velocity.runtime.parser.Parser;
import clover.org.apache.velocity.runtime.parser.ParserVisitor;
import clover.org.apache.velocity.runtime.parser.node.SimpleNode;
import clover.org.apache.velocity.util.ExceptionUtils;
import java.io.IOException;
import java.io.Writer;

public class ASTDirective
extends SimpleNode {
    private Directive directive = null;
    private String directiveName = "";
    private boolean isDirective;

    public ASTDirective(int id) {
        super(id);
    }

    public ASTDirective(Parser p, int id) {
        super(p, id);
    }

    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object init(InternalContextAdapter context, Object data) throws TemplateInitException {
        super.init(context, data);
        if (this.parser.isDirective(this.directiveName)) {
            this.isDirective = true;
            try {
                this.directive = (Directive)this.parser.getDirective(this.directiveName).getClass().newInstance();
            }
            catch (InstantiationException e) {
                throw ExceptionUtils.createRuntimeException("Couldn't initialize directive of class " + this.parser.getDirective(this.directiveName).getClass().getName(), e);
            }
            catch (IllegalAccessException e) {
                throw ExceptionUtils.createRuntimeException("Couldn't initialize directive of class " + this.parser.getDirective(this.directiveName).getClass().getName(), e);
            }
            this.directive.init(this.rsvc, context, this);
            this.directive.setLocation(this.getLine(), this.getColumn());
        } else if (this.rsvc.isVelocimacro(this.directiveName, context.getCurrentTemplateName())) {
            this.isDirective = true;
            this.directive = this.rsvc.getVelocimacro(this.directiveName, context.getCurrentTemplateName());
            try {
                this.directive.init(this.rsvc, context, this);
            }
            catch (TemplateInitException die) {
                throw new TemplateInitException(die.getMessage(), (ParseException)die.getWrappedThrowable(), die.getTemplateName(), die.getColumnNumber() + this.getColumn(), die.getLineNumber() + this.getLine());
            }
            this.directive.setLocation(this.getLine(), this.getColumn());
        } else {
            this.isDirective = false;
        }
        return data;
    }

    public boolean render(InternalContextAdapter context, Writer writer) throws IOException, MethodInvocationException, ResourceNotFoundException, ParseErrorException {
        if (this.isDirective) {
            this.directive.render(context, writer, this);
        } else if (context.getAllowRendering()) {
            writer.write("#");
            writer.write(this.directiveName);
        }
        return true;
    }

    public void setDirectiveName(String str) {
        this.directiveName = str;
    }

    public String getDirectiveName() {
        return this.directiveName;
    }

    public String toString() {
        return new ToStringBuilder(this).appendSuper(super.toString()).append("directiveName", this.getDirectiveName()).toString();
    }
}

