/*
 * Decompiled with CFR 0.152.
 */
package clover.com.google.gson;

import clover.com.google.gson.Preconditions;
import clover.com.google.gson.TypeInfo;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;

final class TypeInfoCollection {
    private final ParameterizedType collectionType;

    public TypeInfoCollection(Type collectionType) {
        if (!(collectionType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Collection objects need to be parameterized unless you use a custom serializer. Use the com.google.gson.reflect.TypeToken to extract the ParameterizedType.");
        }
        TypeInfo rawType = new TypeInfo(collectionType);
        Preconditions.checkArgument(Collection.class.isAssignableFrom(rawType.getRawClass()));
        this.collectionType = (ParameterizedType)collectionType;
    }

    public Type getElementType() {
        return this.collectionType.getActualTypeArguments()[0];
    }
}

