/*
 * Decompiled with CFR 0.152.
 */
package clover.com.google.gson;

import clover.com.google.gson.Preconditions;
import clover.com.google.gson.RecursiveFieldNamingPolicy;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

class ModifyFirstLetterNamingPolicy
extends RecursiveFieldNamingPolicy {
    private final LetterModifier letterModifier;

    public ModifyFirstLetterNamingPolicy(LetterModifier modifier) {
        Preconditions.checkNotNull((Object)modifier);
        this.letterModifier = modifier;
    }

    protected String translateName(String target, Type fieldType, Annotation[] annotations) {
        boolean capitalizeFirstLetter;
        StringBuilder fieldNameBuilder = new StringBuilder();
        int index = 0;
        char firstCharacter = target.charAt(index);
        while (index < target.length() - 1 && !Character.isLetter(firstCharacter)) {
            fieldNameBuilder.append(firstCharacter);
            firstCharacter = target.charAt(++index);
        }
        if (index == target.length()) {
            return fieldNameBuilder.toString();
        }
        boolean bl = capitalizeFirstLetter = this.letterModifier == LetterModifier.UPPER;
        if (capitalizeFirstLetter && !Character.isUpperCase(firstCharacter)) {
            String modifiedTarget = this.modifyString(Character.toUpperCase(firstCharacter), target, ++index);
            return fieldNameBuilder.append(modifiedTarget).toString();
        }
        if (!capitalizeFirstLetter && Character.isUpperCase(firstCharacter)) {
            String modifiedTarget = this.modifyString(Character.toLowerCase(firstCharacter), target, ++index);
            return fieldNameBuilder.append(modifiedTarget).toString();
        }
        return target;
    }

    private String modifyString(char firstCharacter, String srcString, int indexOfSubstring) {
        if (indexOfSubstring < srcString.length()) {
            return firstCharacter + srcString.substring(indexOfSubstring);
        }
        return String.valueOf(firstCharacter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LetterModifier {
        UPPER,
        LOWER;

    }
}

