/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.filter.Util;
import info.bliki.wiki.filter.WPRow;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.HTMLTag;
import info.bliki.wiki.tags.WPTag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WPTable
extends WPTag {
    private String fParams;
    private ArrayList<WPRow> fRows;
    private Map<String, String> fAttributes;

    public WPTable(ArrayList<WPRow> rows) {
        super("{||}");
        this.fRows = rows;
        this.fParams = null;
        this.fAttributes = null;
    }

    public String getParams() {
        return this.fParams;
    }

    public void setParams(String params) {
        this.fParams = params;
        this.fAttributes = Util.getAttributes(params);
    }

    public boolean add(WPRow row) {
        return this.fRows.add(row);
    }

    public WPRow get(int index) {
        return this.fRows.get(index);
    }

    public int getRowsSize() {
        return this.fRows.size();
    }

    public int size() {
        return this.fRows.size();
    }

    @Override
    public void renderHTML(ITextConverter converter, Appendable buf, IWikiModel wikiModel) throws IOException {
        if (this.fRows.size() > 0) {
            buf.append("\n<div style=\"page-break-inside: avoid;\">");
            buf.append("\n<table");
            HTMLTag.appendEscapedAttributes(buf, this.fAttributes);
            buf.append(">");
            for (int i = 0; i < this.fRows.size(); ++i) {
                WPRow row = this.fRows.get(i);
                row.renderHTML(converter, buf, wikiModel);
            }
            buf.append("</table></div>");
        }
    }

    public int getNumColumns() {
        int maxCols = 0;
        for (int i = 0; i < this.fRows.size(); ++i) {
            WPRow row = this.fRows.get(i);
            if (maxCols >= row.getNumColumns()) continue;
            maxCols = row.getNumColumns();
        }
        return maxCols;
    }

    @Override
    public Object clone() {
        WPTable tt = (WPTable)super.clone();
        tt.fParams = this.fParams;
        tt.fRows = this.fRows == null ? null : (ArrayList)this.fRows.clone();
        tt.fAttributes = this.fAttributes == null ? null : new HashMap<String, String>(this.fAttributes);
        return tt;
    }

    @Override
    public boolean isReduceTokenStack() {
        return true;
    }

    @Override
    public String getParents() {
        return "|applet|snippet|blockquote|body|button|center|dd|del|div|fieldset|form|iframe|ins|li|map|noframes|noscript|object|td|th|";
    }

    public void renderPlainText(ITextConverter converter, Appendable buf, IWikiModel wikiModel) throws IOException {
        if (this.fRows.size() > 0) {
            for (int i = 0; i < this.fRows.size(); ++i) {
                WPRow row = this.fRows.get(i);
                row.renderPlainText(converter, buf, wikiModel);
            }
        }
    }
}

