/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.WebTable;
import de.memtext.db.ConnectionCreator;
import de.memtext.util.EqualsUtil;
import de.memtext.util.StringUtils;
import de.memtext.util.XMLUtils;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SxXmlTester {
    Document document;
    List webserverlist = new LinkedList();
    List dbserverConnections = new LinkedList();
    StringBuffer errors = new StringBuffer();

    private void readdbServers() throws IOException, SQLException, ClassNotFoundException {
        NodeList nl = this.document.getElementsByTagName("dbserver");
        int i2 = 0;
        while (i2 < nl.getLength()) {
            Node serverNode = nl.item(i2);
            Connection con = ConnectionCreator.getConnectionCryptPassword(XMLUtils.getAttribValue(serverNode, "db_properties"), "driverName", "connectionURL", "connectionName", "connectionPassword");
            System.out.println("Found 1 db.properties node");
            this.dbserverConnections.add(con);
            ++i2;
        }
    }

    private void readWebServers() {
        NodeList nl = this.document.getElementsByTagName("webserver");
        int i2 = 0;
        while (i2 < nl.getLength()) {
            Node serverNode = nl.item(i2);
            this.webserverlist.add(XMLUtils.getAttribValue(serverNode, "url"));
            System.out.println("Found 1 webserver node");
            ++i2;
        }
    }

    private void runDbTests() throws IOException, SQLException, ClassNotFoundException {
        this.readdbServers();
        NodeList nl = this.document.getElementsByTagName("dbtest");
        int i2 = 0;
        while (i2 < nl.getLength()) {
            Node testNode = nl.item(i2);
            String name = XMLUtils.getAttribValue(testNode, "name");
            System.out.println("Db-Testnr " + (i2 + 1) + " :" + name);
            String sql = XMLUtils.getAttribValue(testNode, "sql");
            for (Connection con : this.dbserverConnections) {
                Statement stm = con.createStatement();
                ResultSet rs = stm.executeQuery(sql);
                Vector result = new Vector();
                int colcount = 0;
                while (rs.next()) {
                    colcount = rs.getMetaData().getColumnCount();
                    Vector<Object> row = new Vector<Object>();
                    int col = 1;
                    while (col <= colcount) {
                        row.add(rs.getObject(col));
                        ++col;
                    }
                    result.add(row);
                }
                Iterator it2 = XMLUtils.getChildNodeIterator(testNode);
                while (it2.hasNext()) {
                    Node childNode = (Node)it2.next();
                    if (!childNode.getNodeName().equals("valuetest")) continue;
                    String rowStr = XMLUtils.getAttribValue(childNode, "row");
                    int row = Integer.parseInt(rowStr);
                    String colStr = XMLUtils.getAttribValue(childNode, "col");
                    int col = Integer.parseInt(colStr);
                    String val = XMLUtils.getAttribValue(childNode, "val");
                    if (col > colcount) {
                        this.errors.append("Test " + name + " Versuch Spalte " + col + " zu lesen, Tabelle hat nur " + colcount + " Spalten\n");
                        continue;
                    }
                    if (row > result.size()) {
                        this.errors.append("Test " + name + " Versuch Zeile " + row + " zu lesen, ResultSet hat nur " + result.size() + " Zeilen\n");
                        continue;
                    }
                    Vector arow = (Vector)result.get(row - 1);
                    String gefunden = arow.get(col - 1).toString();
                    if (EqualsUtil.areEqual(val, gefunden)) continue;
                    this.errors.append("Test " + name + " Falscher Wert Zeile " + row + " Spalte " + col + " erwartet:" + val + " gefunden:" + gefunden + "\n(sql:" + sql + "\n\n");
                }
            }
            ++i2;
        }
    }

    public void go(String[] args) throws SAXException, IOException, SQLException, ClassNotFoundException {
        XMLUtils.getExceptionHandler().setWithGui(false);
        this.document = XMLUtils.buildDocument(new File(args[0]));
        this.runDbTests();
        this.runWebtests();
        if (this.errors.length() > 0) {
            System.out.println("Es sind Fehler aufgetaucht siehe output-errors.txt");
            StringUtils.write(new File("output-errors.txt"), new Date() + "\n" + this.errors.toString());
        } else {
            System.out.println("Keine Fehler aufgefallen");
        }
    }

    private void runWebtests() throws SAXException, IOException {
        this.readWebServers();
        NodeList nl = this.document.getElementsByTagName("webtest");
        WebConversation wc = new WebConversation();
        int i2 = 0;
        while (i2 < nl.getLength()) {
            Node testNode = nl.item(i2);
            String name = XMLUtils.getAttribValue(testNode, "name");
            System.out.println("Webserver-Testnr " + (i2 + 1) + " :" + name);
            String params = XMLUtils.getChildNodeValue(testNode, "params");
            for (String serverUrl : this.webserverlist) {
                WebResponse resp;
                serverUrl = String.valueOf(serverUrl) + params;
                GetMethodWebRequest req = new GetMethodWebRequest(serverUrl);
                try {
                    resp = wc.getResponse((WebRequest)req);
                }
                catch (IOException e2) {
                    System.err.println("Aufruf fehlgeschlagen von " + serverUrl);
                    throw e2;
                }
                StringUtils.write(new File("output_" + name + ".htm"), resp.getText());
                if (resp.getTables().length < 2) {
                    this.errors.append("Test " + name + " Keine Ergebnistabelle geliefert\n ");
                    continue;
                }
                Iterator it2 = XMLUtils.getChildNodeIterator(testNode);
                while (it2.hasNext()) {
                    Node childNode = (Node)it2.next();
                    if (!childNode.getNodeName().equals("valuetest")) continue;
                    String rowStr = XMLUtils.getAttribValue(childNode, "row");
                    int row = Integer.parseInt(rowStr);
                    String colStr = XMLUtils.getAttribValue(childNode, "col");
                    int col = Integer.parseInt(colStr);
                    String val = XMLUtils.getAttribValue(childNode, "val");
                    WebTable table = resp.getTables()[1];
                    if (col > table.getColumnCount()) {
                        StringUtils.write(new File("output_" + name + ".htm"), resp.getText());
                        this.errors.append("Test " + name + " Versuch Spalte " + col + " zu lesen, Tabelle hat nur " + table.getColumnCount() + " Spalten\n");
                        continue;
                    }
                    if (row > table.getRowCount()) {
                        StringUtils.write(new File("output_" + name + ".htm"), resp.getText());
                        this.errors.append("Test " + name + " Versuch Zeile " + row + " zu lesen, Tabelle hat nur " + table.getRowCount() + " Zeilen\n");
                        continue;
                    }
                    String gefunden = table.getTableCell(row - 1, col - 1).getText();
                    if (EqualsUtil.areEqual(val, gefunden)) continue;
                    this.errors.append("Test " + name + " Falscher Wert Zeile " + row + " Spalte " + col + " erwartet:" + val + " gefunden:" + gefunden + "\n(url:" + serverUrl + "\n\n");
                }
            }
            ++i2;
        }
    }

    public static void main(String[] args) {
        System.out.println("");
        if (args.length != 1) {
            System.err.println("usage SxXmlTester test.xml");
            System.exit(-1);
        }
        try {
            new SxXmlTester().go(args);
        }
        catch (Exception e2) {
            System.out.println(e2);
            e2.printStackTrace();
        }
    }
}

