/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.superx.bin.SxConnection;
import de.superx.bin.SxDBUtils;
import de.superx.bin.SxTransformer;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SxJdbcClient {
    String sqlstmt;
    String propFile;
    String loglevel = "../conf/logging.properties";
    public Logger myLogger = null;
    Connection myDb = null;
    SxConnection myConnection = null;
    public Statement st = null;
    public PreparedStatement pst = null;
    public DatabaseMetaData dbmd;
    public ResultSet rs = null;
    public ResultSetMetaData rsmd = null;
    public String db_driver = null;
    private final List _keywords = new ArrayList();
    private final List _dataTypes = new ArrayList();
    private final List _functions = new ArrayList();
    private final List _tables = new ArrayList();
    private final List _columns = new ArrayList();
    private boolean isLogAllResultSetsToConsole = false;
    public String[] mySchemas = null;

    public SxJdbcClient(Logger logger, String dbpropfile) {
        this.propFile = dbpropfile;
        this.myLogger = logger;
        this.myLogger.config("Starting the jdbc-Client.");
    }

    public SxJdbcClient(Logger logger, String dbpropfile, String sql) {
        this.propFile = dbpropfile;
        this.setSqlstmt(sql);
        this.myLogger = logger;
        this.myLogger.config("Starting the jdbc-Client.");
    }

    public synchronized void sqlResultSet(Statement st, String sql) throws SQLException {
        sql = sql.trim();
        int pos = 0;
        boolean type = false;
        this.myLogger.info("sql-stmt: " + sql);
        if (sql.startsWith("\\!")) {
            sql = sql.substring(1);
        }
        if (sql.startsWith("!")) {
            pos = sql.indexOf("\n");
            if (pos == -1) {
                this.executeShellScript(sql.substring(1));
            } else {
                this.executeShellScript(sql.substring(1, pos));
                this.sqlResultSet(st, sql.substring(pos + 1));
            }
        } else {
            type = st.execute(sql);
            boolean loop = true;
            if (type) {
                this.rs = st.getResultSet();
                this.rsmd = this.rs.getMetaData();
                if (this.isLogAllResultSetsToConsole) {
                    this.logToConsole(this.rs);
                }
            } else {
                int count = st.getUpdateCount();
                this.rs = null;
                this.rsmd = null;
                if (count == -1) {
                    loop = false;
                } else {
                    this.myLogger.info("Statement executed; " + count + " rows");
                }
            }
        }
    }

    private void logToConsole(ResultSet rs) throws SQLException {
        int colCount = rs.getMetaData().getColumnCount();
        StringBuffer buf = new StringBuffer();
        while (rs.next()) {
            int i2 = 1;
            while (i2 <= colCount) {
                buf.append(rs.getObject(i2) + " ^");
                ++i2;
            }
            buf.append("\n");
        }
        if (buf.length() > 1) {
            System.out.println(buf.toString());
        }
    }

    private void executeShellScript(String inString) {
        if (inString.startsWith("!")) {
            throw new IllegalArgumentException("kein ! erlaubt");
        }
        String extCommand = "";
        this.myLogger.info("SxJdbcClient - executing shell command:" + inString);
        if (inString == null || inString.length() < 1) {
            return;
        }
        try {
            File f2 = new File("tmp.x");
            FileWriter fw = new FileWriter(f2);
            fw.write(inString);
            fw.flush();
            fw.close();
            this.sendToShell("! chmod +x tmp.x");
            this.sendToShell("! tmp.x");
            if (this.myLogger != null && f2 != null && this.myLogger.getLevel() != null && this.myLogger.getLevel().intValue() <= Level.INFO.intValue()) {
                f2.delete();
            }
        }
        catch (Exception e2) {
            throw new RuntimeException("Failed to execute command '" + inString + "':  " + e2);
        }
    }

    private void sendToShell(String inString) throws IOException, InterruptedException {
        int i2;
        StringTokenizer toker = new StringTokenizer(inString);
        String other = null;
        String arg1 = null;
        arg1 = toker.nextToken();
        if (toker.hasMoreTokens()) {
            other = toker.nextToken("").trim();
        }
        byte[] ba = new byte[1024];
        String extCommand = String.valueOf(arg1.length() == 1 ? "" : arg1.substring(1)) + (arg1.length() > 1 && other != null ? " " : "") + (other == null ? "" : other);
        Process proc = Runtime.getRuntime().exec(extCommand);
        proc.getOutputStream().close();
        InputStream stream = proc.getInputStream();
        while ((i2 = stream.read(ba)) > 0) {
            System.out.println(new String(ba, 0, i2));
        }
        stream.close();
        stream = proc.getErrorStream();
        while ((i2 = stream.read(ba)) > 0) {
            System.out.println(new String(ba, 0, i2));
        }
        stream.close();
        if (proc.waitFor() != 0) {
            throw new RuntimeException("Failed to execute command '" + extCommand + "'");
        }
    }

    public void Rs_executeALL() throws SQLException {
        if (this.myConnection == null) {
            this.getConnection();
        }
        StringTokenizer stoken = new StringTokenizer(this.sqlstmt, ";");
        int n = 0;
        while (stoken.hasMoreTokens()) {
            String sql = stoken.nextToken().trim();
            this.myLogger.info("Statement Nummer " + ++n + ": " + sql);
            if (sql.length() <= 5) continue;
            this.sqlResultSet(this.st, sql);
        }
    }

    public void execute() throws SQLException {
        try {
            this.getConnection();
        }
        catch (SQLException e2) {
            this.myLogger.severe("Failed to get connection: " + e2.toString());
            throw new SQLException("Failed to get connection: " + e2.toString());
        }
        this.myLogger.info("Statement : " + this.sqlstmt);
        if (this.sqlstmt.length() > 5) {
            this.sqlResultSet(this.st, this.sqlstmt);
        }
    }

    public void executeQueryWithinConnection() throws SQLException {
        this.myLogger.info("Statement : " + this.sqlstmt);
        if (this.sqlstmt.length() > 5) {
            this.sqlResultSet(this.st, this.sqlstmt);
        }
    }

    public static void updateRs(ResultSet rs, int col, int coltype, String wert) {
        try {
            if (col == 1) {
                rs.updateString(col, wert);
            }
        }
        catch (SQLException e2) {
            System.err.println("SQL-Insert Fehler:" + e2.toString());
        }
    }

    public void TableColumns(String tabelle) {
        try {
            this.getConnection();
            if (!this.dbmd.storesLowerCaseIdentifiers()) {
                tabelle = tabelle.toUpperCase();
            }
            this.myLogger.config("Tabellenkatalog f\u00fcr " + tabelle + " in Datenbank " + this.myConnection.getCatalog());
            this.rs = this.dbmd.getColumns(this.myConnection.getCatalog(), null, tabelle, null);
            this.rsmd = this.rs.getMetaData();
        }
        catch (SQLException e2) {
            this.myLogger.severe("Tabellenkatalog f\u00fcr " + tabelle + " konnte nicht erstellt werden: " + e2.toString());
        }
    }

    public void prepareStatement(String sql) {
        try {
            this.getConnection();
            this.myLogger.config("PrepareStatement f\u00fcr " + sql + " in Datenbank " + this.myConnection.getCatalog());
            this.pst = this.myConnection.con.prepareStatement(sql);
        }
        catch (SQLException e2) {
            this.myLogger.severe("PrepareStatement konnte nicht erstellt werden f\u00fcr SQL-Statement:" + sql + ": " + e2.toString());
            System.exit(-1);
        }
    }

    public String getTableSchema(String tabelle) throws SQLException {
        String myCatalog = "";
        try {
            this.getConnection();
        }
        catch (SQLException e2) {
            this.myLogger.severe("Failed to get connection: " + e2.toString());
            throw new SQLException("Failed to get connection: " + e2.toString());
        }
        String zs = "";
        String table_type = "";
        if (tabelle.equals("")) {
            zs = String.valueOf(zs) + "<database>";
            try {
                myCatalog = this.myConnection.getCatalog();
                this.myLogger.config("Column-katalog f\u00fcr  Datenbank " + myCatalog);
            }
            catch (SQLException e3) {
                this.myLogger.info("getCatalog nicht implementiert " + e3.toString());
                myCatalog = null;
            }
            ResultSet myTables = this.dbmd.getTables(myCatalog, null, null, null);
            if (myTables != null) {
                while (myTables.next()) {
                    tabelle = myTables.getString("TABLE_NAME");
                    table_type = myTables.getString("TABLE_TYPE");
                    if (table_type != null && !table_type.equalsIgnoreCase("TABLE") || tabelle.startsWith("_")) continue;
                    this.myLogger.info("Getting Table " + tabelle);
                    zs = String.valueOf(zs) + this.myTableSchema(tabelle);
                }
            }
            zs = String.valueOf(zs) + "</database>";
        } else {
            zs = this.myTableSchema(tabelle);
        }
        try {
            this.myConnection.close();
        }
        catch (SQLException e4) {
            this.myLogger.severe("Failed to close connection: " + e4.toString());
        }
        return zs;
    }

    private String myTableSchema(String tabelle) {
        String mzs = "<table name=\"" + tabelle + "\">\n";
        if (this.db_driver.equals("org.hsqldb.jdbcDriver")) {
            tabelle = tabelle.toUpperCase();
        }
        SxTransformer myTransformer = null;
        myTransformer = new SxTransformer(this.myLogger);
        myTransformer.setDelim("");
        myTransformer.setHeader("false");
        mzs = String.valueOf(mzs) + "<columns>" + this.getColumnSchema(tabelle, myTransformer) + "</columns>\n";
        mzs = String.valueOf(mzs) + "<indexes>" + this.getIndexSchema(tabelle, myTransformer) + "</indexes>\n";
        mzs = String.valueOf(mzs) + "<primaryKeys>" + this.getPrimaryKeySchema(tabelle, myTransformer) + "</primaryKeys>\n";
        mzs = String.valueOf(mzs) + "<foreignKeys>" + this.getForeignKeySchema(tabelle, myTransformer) + "</foreignKeys>\n";
        mzs = String.valueOf(mzs) + "<importedKeys>" + this.getImportedKeySchema(tabelle, myTransformer) + "</importedKeys>\n";
        mzs = String.valueOf(mzs) + "<privileges>" + this.getPrivilegeSchema(tabelle, myTransformer) + "</privileges>\n";
        mzs = String.valueOf(mzs) + "</table>\n";
        return mzs;
    }

    private String getIndexSchema(String tabelle, SxTransformer myTransformer) {
        String zs = "";
        String myCatalog = "";
        try {
            myCatalog = this.myConnection.getCatalog();
            this.myLogger.config("Index-katalog f\u00fcr " + tabelle + " in Datenbank " + myCatalog);
        }
        catch (SQLException e2) {
            this.myLogger.info("getCatalog nicht implementiert " + e2.toString());
            myCatalog = null;
        }
        String primaryKeys = "";
        try {
            this.rs = this.dbmd.getPrimaryKeys(myCatalog, null, tabelle);
            this.rsmd = this.rs.getMetaData();
            if (this.rs != null) {
                myTransformer.setOutrs(this.rs);
                myTransformer.setOutrsmd(this.getRsmd());
                primaryKeys = String.valueOf(primaryKeys) + myTransformer.getResult("xml");
            } else {
                this.myLogger.info("Keine R\u00fcckgabewerte aus PrimaryKey-schema");
            }
        }
        catch (SQLException e3) {
            this.myLogger.severe("PrimaryKey-katalog konnte nicht erstellt werden: " + e3.toString());
        }
        try {
            try {
                this.rs = this.dbmd.getIndexInfo(myCatalog, null, tabelle, false, false);
            }
            catch (Exception e4) {
                this.rs = null;
            }
            if (this.rs != null) {
                this.rsmd = this.rs.getMetaData();
                String[] indexes = new String[255];
                String[] uniqueIndex = new String[255];
                String[] indexCols = new String[255];
                int i2 = 1;
                int k2 = 1;
                while (this.rs.next()) {
                    boolean neuerIndex = true;
                    String indexName = this.rs.getString("INDEX_NAME");
                    if (indexName == null || primaryKeys.indexOf("<fld name='pk_name'>" + indexName.trim() + "</fld>") >= 0) continue;
                    indexName = indexName.trim();
                    if (i2 > 1) {
                        k2 = 1;
                        while (k2 < i2) {
                            if (indexes[k2].equals(indexName)) {
                                neuerIndex = false;
                                break;
                            }
                            ++k2;
                        }
                    }
                    if (neuerIndex) {
                        indexes[i2] = indexName;
                        uniqueIndex[i2] = this.rs.getString("non_unique");
                        uniqueIndex[i2] = uniqueIndex[i2].equals("0") || uniqueIndex[i2].equals("false") ? "true" : "false";
                        indexCols[i2] = "<index-column name=\"" + this.rs.getString("column_name") + "\"/>\n";
                        ++i2;
                        continue;
                    }
                    int n = k2;
                    indexCols[n] = String.valueOf(indexCols[n]) + "<index-column name=\"" + this.rs.getString("column_name") + "\"/>\n";
                }
                k2 = 1;
                while (k2 < i2) {
                    if (!indexes[k2].startsWith("1")) {
                        zs = String.valueOf(zs) + "<index name=\"" + indexes[k2] + "\" unique=\"" + uniqueIndex[k2] + "\">\n";
                        zs = String.valueOf(zs) + indexCols[k2];
                        zs = String.valueOf(zs) + "</index>\n";
                    }
                    ++k2;
                }
            } else {
                this.myLogger.warning("Keine R\u00fcckgabewerte aus Indexschema");
            }
        }
        catch (SQLException e5) {
            this.myLogger.severe("Indexkatalog konnte nicht erstellt werden: " + e5.toString());
        }
        return zs;
    }

    private String getPrivilegeSchema(String tabelle, SxTransformer myTransformer) {
        String zs = "";
        String myCatalog = "";
        try {
            myCatalog = this.myConnection.getCatalog();
            this.myLogger.config("Privileges-katalog f\u00fcr " + tabelle + " in Datenbank " + myCatalog);
        }
        catch (SQLException e2) {
            this.myLogger.info("getCatalog nicht implementiert " + e2.toString());
            myCatalog = null;
        }
        try {
            this.rs = this.dbmd.getTablePrivileges(myCatalog, null, tabelle.toUpperCase());
            this.rsmd = this.rs.getMetaData();
            if (this.rs != null) {
                myTransformer.setOutrs(this.rs);
                myTransformer.setOutrsmd(this.getRsmd());
                zs = String.valueOf(zs) + myTransformer.getResult("xml");
            } else {
                this.myLogger.info("Keine R\u00fcckgabewerte aus Privilegschema");
            }
        }
        catch (SQLException e3) {
            this.myLogger.severe("Privilegkatalog konnte nicht erstellt werden: " + e3.toString());
        }
        return zs;
    }

    private String getForeignKeySchema(String tabelle, SxTransformer myTransformer) {
        String zs = "";
        String myCatalog = "";
        try {
            myCatalog = this.myConnection.getCatalog();
            this.myLogger.config("ForeignKey-katalog f\u00fcr " + tabelle + " in Datenbank " + myCatalog);
        }
        catch (SQLException e2) {
            this.myLogger.info("getCatalog nicht implementiert " + e2.toString());
            myCatalog = null;
        }
        try {
            this.rs = this.dbmd.getExportedKeys(myCatalog, null, tabelle);
            this.rsmd = this.rs.getMetaData();
            if (this.rs != null) {
                myTransformer.setOutrs(this.rs);
                myTransformer.setOutrsmd(this.getRsmd());
                zs = String.valueOf(zs) + myTransformer.getResult("xml");
            } else {
                this.myLogger.info("Keine R\u00fcckgabewerte aus ForeignKey-schema");
            }
        }
        catch (SQLException e3) {
            this.myLogger.severe("ForeignKey-katalog konnte nicht erstellt werden: " + e3.toString());
        }
        return zs;
    }

    private String getPrimaryKeySchema(String tabelle, SxTransformer myTransformer) {
        String zs = "";
        String myCatalog = "";
        try {
            myCatalog = this.myConnection.getCatalog();
            this.myLogger.config("PrimaryKey-katalog f\u00fcr " + tabelle + " in Datenbank " + myCatalog);
        }
        catch (SQLException e2) {
            this.myLogger.info("getCatalog nicht implementiert " + e2.toString());
            myCatalog = null;
        }
        try {
            this.rs = this.dbmd.getPrimaryKeys(myCatalog, null, tabelle);
            this.rsmd = this.rs.getMetaData();
            if (this.rs != null) {
                myTransformer.setOutrs(this.rs);
                myTransformer.setOutrsmd(this.getRsmd());
                zs = String.valueOf(zs) + myTransformer.getResult("xml");
            } else {
                this.myLogger.info("Keine R\u00fcckgabewerte aus PrimaryKey-schema");
            }
        }
        catch (SQLException e3) {
            this.myLogger.severe("PrimaryKey-katalog konnte nicht erstellt werden: " + e3.toString());
        }
        return zs;
    }

    private String getImportedKeySchema(String tabelle, SxTransformer myTransformer) {
        String zs = "";
        String myCatalog = "";
        try {
            myCatalog = this.myConnection.getCatalog();
            this.myLogger.config("ImportedKeys-katalog f\u00fcr " + tabelle + " in Datenbank " + myCatalog);
        }
        catch (SQLException e2) {
            this.myLogger.info("getCatalog nicht implementiert " + e2.toString());
            myCatalog = null;
        }
        try {
            this.rs = this.dbmd.getImportedKeys(myCatalog, null, tabelle);
            this.rsmd = this.rs.getMetaData();
            if (this.rs != null) {
                myTransformer.setOutrs(this.rs);
                myTransformer.setOutrsmd(this.getRsmd());
                zs = String.valueOf(zs) + myTransformer.getResult("xml");
            } else {
                this.myLogger.info("Keine R\u00fcckgabewerte aus ImportedKey-schema");
            }
        }
        catch (SQLException e3) {
            this.myLogger.severe("ImportedKey-katalog konnte nicht erstellt werden: " + e3.toString());
        }
        return zs;
    }

    private String getColumnSchema(String tabelle, SxTransformer myTransformer) {
        String zs = "";
        String myCatalog = "";
        try {
            myCatalog = this.myConnection.getCatalog();
            this.myLogger.config("Column-katalog f\u00fcr " + tabelle + " in Datenbank " + myCatalog);
        }
        catch (SQLException e2) {
            this.myLogger.info("getCatalog nicht implementiert " + e2.toString());
            myCatalog = null;
        }
        try {
            this.rs = this.dbmd.getColumns(myCatalog, null, tabelle, null);
            this.rsmd = this.rs.getMetaData();
            if (this.rs != null) {
                while (this.rs.next()) {
                    String colName = "";
                    String colType = "";
                    String colSize = "";
                    String colNotNull = "";
                    String colDefault = "";
                    String colDescription = "";
                    colName = this.rs.getString("COLUMN_NAME");
                    colType = SxDBUtils.getSqlTypeName(this.rs.getInt("DATA_TYPE"));
                    String t = this.rs.getString("DECIMAL_DIGITS");
                    colSize = colType.equals("NUMERIC") || colType.equals("DECIMAL") ? "(" + this.rs.getString("COLUMN_SIZE") + "," + t + ")" : this.rs.getString("COLUMN_SIZE");
                    Object o = this.rs.getObject("COLUMN_DEF");
                    if (o != null) {
                        colDefault = o.toString();
                    }
                    if (colDefault.equals("null")) {
                        colDefault = "";
                    }
                    if (colDefault.startsWith("nextval")) {
                        colType = "SERIAL";
                    }
                    colNotNull = (t = this.rs.getString("IS_NULLABLE")) != null && t.equals("NO") ? "true" : "false";
                    o = this.rs.getObject("REMARKS");
                    if (o != null) {
                        colDescription = o.toString().trim();
                    }
                    if (colType.equals("LONGVARCHAR")) {
                        colType = "text";
                        colSize = "";
                    }
                    zs = String.valueOf(zs) + "<column name=\"" + colName + "\" ";
                    zs = String.valueOf(zs) + "type =\"" + colType + "\" ";
                    zs = String.valueOf(zs) + "size =\"" + colSize + "\" ";
                    zs = String.valueOf(zs) + "default =\"" + colDefault + "\" ";
                    zs = String.valueOf(zs) + "notnull =\"" + colNotNull + "\" ";
                    zs = colDescription != "" ? String.valueOf(zs) + "><comment>" + colDescription + "</comment></column>\n" : String.valueOf(zs) + "/>\n";
                }
            } else {
                this.myLogger.info("Keine R\u00fcckgabewerte aus Column-schema");
            }
        }
        catch (SQLException e3) {
            this.myLogger.severe("Column-katalog konnte nicht erstellt werden: " + e3.toString());
        }
        return zs;
    }

    public String getTableSchemaHIS(String tabelle) throws SQLException {
        try {
            this.getConnection();
        }
        catch (SQLException e2) {
            this.myLogger.severe("Failed to get connection: " + e2.toString());
            throw new SQLException("Failed to get connection: " + e2.toString());
        }
        SxTransformer myTransformer = null;
        myTransformer = new SxTransformer(this.myLogger);
        myTransformer.setDelim("");
        myTransformer.setHeader("false");
        String zs = "";
        try {
            this.myLogger.config("HIS-Konformer Column-katalog f\u00fcr " + tabelle + " in Datenbank " + this.myConnection.getCatalog());
            this.rs = this.dbmd.getColumns(this.myConnection.getCatalog(), null, tabelle, null);
            this.rsmd = this.rs.getMetaData();
            if (this.rs != null) {
                while (this.rs.next()) {
                    String colName = "";
                    String colType = "";
                    String colSize = "";
                    String colNotNull = "";
                    String colDefault = "";
                    String colKey = "false";
                    String colDescription = "";
                    colName = this.rs.getString("COLUMN_NAME");
                    colType = SxDBUtils.getSqlTypeName(this.rs.getInt("DATA_TYPE"));
                    String t = this.rs.getString("DECIMAL_DIGITS");
                    colSize = colType.equals("NUMERIC") || colType.equals("DECIMAL") ? "(" + this.rs.getString("COLUMN_SIZE") + "," + t + ")" : this.rs.getString("COLUMN_SIZE");
                    Object o = this.rs.getObject("COLUMN_DEF");
                    if (o != null) {
                        colDefault = o.toString();
                    }
                    if (colDefault.equals("null")) {
                        colDefault = "";
                    }
                    if (colDefault.startsWith("nextval")) {
                        colType = "SERIAL";
                    }
                    colNotNull = (t = this.rs.getString("IS_NULLABLE")).equals("NO") ? "true" : "false";
                    if (colSize.equals("-1") && colType.equals("VARCHAR") || colType.equals("LONGVARCHAR")) {
                        colType = "text";
                        colSize = "";
                    }
                    zs = String.valueOf(zs) + "<column name=\"" + colName + "\" ";
                    zs = String.valueOf(zs) + "type =\"" + colType + "\" ";
                    zs = String.valueOf(zs) + "size =\"" + colSize + "\" ";
                    zs = String.valueOf(zs) + "default =\"" + colDefault + "\" ";
                    zs = String.valueOf(zs) + "key =\"" + colKey + "\" ";
                    zs = String.valueOf(zs) + "notnull =\"" + colNotNull + "\" ";
                    zs = String.valueOf(zs) + "/>\n";
                }
            } else {
                this.myLogger.info("Keine R\u00fcckgabewerte aus Column-schema");
            }
        }
        catch (SQLException e3) {
            this.myLogger.severe("Column-katalog konnte nicht erstellt werden: " + e3.toString());
        }
        try {
            this.myConnection.close();
        }
        catch (SQLException e4) {
            this.myLogger.severe("Failed to close connection: " + e4.toString());
        }
        return zs;
    }

    public void getSchemas() {
        try {
            this.myLogger.config("Schemakatalog f\u00fcr " + this.myConnection.getCatalog().toString());
            this.rs = this.dbmd.getSchemas();
            this.rsmd = this.rs.getMetaData();
            if (this.rs != null) {
                int i2 = 1;
                while (this.rs.next()) {
                    this.mySchemas[i2] = this.rs.getObject(1).toString();
                }
            }
        }
        catch (SQLException e2) {
            this.myLogger.warning("Schemakatalog konnte nicht erstellt werden: " + e2.toString());
        }
        catch (Exception e3) {
            this.myLogger.warning("Schemakatalog konnte nicht erstellt werden: " + e3.toString());
        }
    }

    public void close() {
        try {
            if (this.st != null) {
                this.st.close();
            }
            this.myDb.close();
            System.gc();
        }
        catch (SQLException e2) {
            this.myLogger.severe("Connection konnte nicht geschlossen werden: " + e2.toString());
        }
    }

    public void getConnection() throws SQLException {
        this.myConnection = new SxConnection();
        this.myConnection.setPropfile(this.propFile);
        this.myLogger.config("Starting Connection...");
        try {
            this.myDb = this.myConnection.getConnection();
            this.st = this.myDb.createStatement();
            this.dbmd = this.myDb.getMetaData();
        }
        catch (Exception e2) {
            this.myLogger.severe("Keine DB-Verbindung: " + e2.toString());
            throw new SQLException("Keine DB-Verbindung: " + e2.toString());
        }
        this.db_driver = this.myConnection.m_DriverClass;
    }

    public String getPropFile() {
        return this.propFile;
    }

    public String getSqlstmt() {
        return this.sqlstmt;
    }

    public void setPropFile(String string) {
        this.propFile = string;
    }

    public void setSqlstmt(String stmts) {
        int pos = stmts.indexOf("--");
        while (pos >= 0) {
            int posNewLine = stmts.indexOf("\n", pos);
            int endOfComment = posNewLine > 0 ? posNewLine : -1;
            String head = stmts.substring(0, pos);
            String tail = "";
            if (endOfComment > -1) {
                tail = stmts.substring(posNewLine + 1, stmts.length());
            }
            stmts = String.valueOf(head) + tail;
            pos = stmts.indexOf("--");
        }
        this.sqlstmt = stmts;
        while (this.sqlstmt.indexOf("\n\n") > -1) {
            this.sqlstmt = this.sqlstmt.replaceAll("\n\n", "\n");
        }
    }

    public ResultSet getRs() {
        return this.rs;
    }

    public ResultSetMetaData getRsmd() {
        return this.rsmd;
    }

    public void setRs(ResultSet set) {
        this.rs = set;
    }

    private void loadDataTypes() {
        try {
            ResultSet rs = this.dbmd.getTypeInfo();
            try {
                while (rs.next()) {
                    this._dataTypes.add(rs.getString(1).trim().toUpperCase());
                }
            }
            finally {
                rs.close();
            }
        }
        catch (Throwable ex) {
            this.myLogger.severe("Error occured creating data types collection " + ex.toString());
        }
    }

    private void loadFunctions() {
        StringBuffer buf = new StringBuffer(1024);
        try {
            buf.append(this.dbmd.getNumericFunctions());
        }
        catch (Throwable ex) {
            this.myLogger.severe("Error" + ex.toString());
        }
        buf.append(",");
        try {
            buf.append(this.dbmd.getStringFunctions());
        }
        catch (Throwable ex) {
            this.myLogger.severe("Error" + ex.toString());
        }
        buf.append(",");
        try {
            buf.append(this.dbmd.getTimeDateFunctions());
        }
        catch (Throwable ex) {
            this.myLogger.severe("Error" + ex.toString());
        }
        StringTokenizer strtok = new StringTokenizer(buf.toString(), ",");
        while (strtok.hasMoreTokens()) {
            String func = strtok.nextToken().trim();
            if (func.length() <= 0) continue;
            this._functions.add(func.toUpperCase());
        }
    }

    private void loadTables() {
        try {
            ResultSet rs = this.dbmd.getTables(null, null, null, new String[]{"TABLE", "VIEW"});
            while (rs.next()) {
                this._tables.add(rs.getString(3).toUpperCase());
            }
        }
        catch (Throwable th) {
            this.myLogger.severe("failed to load table names" + th.toString());
        }
    }

    public static void main(String[] args) {
        new SxJdbcClient(Logger.getAnonymousLogger(), null).setSqlstmt("! echo \"adfasf\" > te.txt");
    }

    public boolean isLogAllResultSetsToConsole() {
        return this.isLogAllResultSetsToConsole;
    }

    public void setLogAllResultSetsToConsole(boolean b2) {
        this.isLogAllResultSetsToConsole = b2;
    }
}

