/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;

public class SubclassFilter
implements ClassVisitor {
    private final Clazz subclass;
    private final ClassVisitor classVisitor;

    public SubclassFilter(Clazz clazz, ClassVisitor classVisitor) {
        this.subclass = clazz;
        this.classVisitor = classVisitor;
    }

    public void visitProgramClass(ProgramClass programClass) {
        if (!this.present(programClass.subClasses)) {
            this.classVisitor.visitProgramClass(programClass);
        }
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        if (!this.present(libraryClass.subClasses)) {
            this.classVisitor.visitLibraryClass(libraryClass);
        }
    }

    private boolean present(Clazz[] clazzArray) {
        if (clazzArray == null) {
            return false;
        }
        for (int i = 0; i < clazzArray.length; ++i) {
            if (!clazzArray[i].equals(this.subclass)) continue;
            return true;
        }
        return false;
    }
}

