/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.support;

import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.util.Iterator;
import java.util.Stack;

public class TBFeldIterator
extends AbstractElementVisitor {
    private MetaElement metaElement;
    private CodeBlock myCode;
    private Stack hierachy = new Stack();

    public TBFeldIterator(MetaElement metaElement) {
        this.metaElement = metaElement;
    }

    public void eachTBFeld(CodeBlock code) {
        assert (this.metaElement != null);
        assert (code != null);
        this.myCode = code;
        this.metaElement.accept(this);
    }

    @Override
    public void visitPlausibilisierung(MetaPlausibilisierung plausi) {
        assert (plausi != null);
        assert (plausi instanceof MetaCustomPlausibilisierung);
        assert (((MetaCustomPlausibilisierung)plausi).rootThemenbereich() != null);
        MetaCustomPlausibilisierung customPlausi = (MetaCustomPlausibilisierung)plausi;
        customPlausi.rootThemenbereich().accept(this);
    }

    @Override
    public void visitThemenbereich(MetaThemenbereich tb) {
        assert (tb != null);
        Iterator it = tb.getFelder();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
        }
    }

    @Override
    public void visitTBFeld(MetaTBFeld feld) {
        assert (feld != null);
        assert (feld instanceof MetaCustomTBFeld);
        assert (this.myCode != null);
        if (!(feld.getKlasse() instanceof MetaThemenbereich)) {
            this.myCode.doForTBFeld((MetaCustomTBFeld)feld, this.createTbHierachy());
        } else {
            MetaThemenbereich refTb = (MetaThemenbereich)feld.getKlasse();
            this.hierachy.push(feld.getName());
            refTb.accept(this);
            this.hierachy.pop();
        }
    }

    private String createTbHierachy() {
        StringBuffer result = new StringBuffer();
        Iterator it = this.hierachy.iterator();
        while (it.hasNext()) {
            result.append((String)it.next());
            if (!it.hasNext()) continue;
            result.append(".");
        }
        return result.toString();
    }

    public static interface CodeBlock {
        public void doForTBFeld(MetaCustomTBFeld var1, String var2);
    }
}

