/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.cpp;

import de.statspez.pleditor.generator.codegen.cpp.CppPlausiElementCodeGenerator;
import de.statspez.pleditor.generator.codegen.cpp.CppProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.cpp.CppSettings;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.support.CodegenUtil;
import de.statspez.pleditor.generator.codegen.support.NamespaceHelper;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.codegen.support.SymbolDescriptor;
import de.statspez.pleditor.generator.codegen.support.TextResource;
import de.statspez.pleditor.generator.common.ElementMessageContext;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomInitwert;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLAblauf;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPLInitwert;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaPLPruefung;
import de.statspez.pleditor.generator.meta.generated.MetaPLVariable;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaTBMaterialReferenz;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.parser.Helper;
import java.util.Iterator;

public class CppThemenbereichCodeGenerator
extends CppPlausiElementCodeGenerator {
    private Scope scope = null;
    private TextResource textResource = null;

    public synchronized void generate(MetaThemenbereich aTb, Scope tbScope) {
        this.scope = tbScope;
        aTb.accept(this);
        this.checkForErrors();
        this.out.flush();
    }

    public void setTextResource(TextResource textResource) {
        this.textResource = textResource;
    }

    @Override
    public void visitThemenbereich(MetaThemenbereich tb) {
        this.defineClass(this.getTbClass(tb), "Topic");
        this.decreaseIndentLevel();
        this.indentNewLine();
        this.out.print("public:");
        this.increaseIndentLevel();
        this.visitElements(tb.getFelder());
        this.visitElements(tb.getVariablen());
        this.visitElements(tb.getMaterialreferenzen());
        this.indentNewLine();
        this.createTbConstructor(tb);
        this.createTbDestructor(tb);
        this.createInitMethod(tb);
        this.indentNewLine();
        this.createGetInstanceMethod(tb);
        if (((MetaCustomThemenbereich)tb).referencedByErhebung()) {
            this.visitElements(tb.getAblaeufe());
            this.visitElements(tb.getPruefungen());
            this.visitElements(tb.getFunktionen());
        }
        this.indentNewLine();
        this.decreaseIndentLevel();
        this.indentNewLine();
        this.out.print("private:");
        this.increaseIndentLevel();
        this.visitElements(tb.getInitialisierungswerte());
        this.indentNewLine();
        this.out.print("Plausi");
        this.out.print("* plausi;");
        this.endClassDefinition();
    }

    @Override
    public void visitTBFeld(MetaTBFeld aFeld) {
        MetaCustomTBFeld feld = (MetaCustomTBFeld)aFeld;
        this.indentNewLine();
        String type = null;
        if (feld.getKlasse() instanceof MetaMerkmal) {
            type = aFeld.getListe() ? "FieldArray" : "Field";
        } else if (feld.getKlasse() instanceof MetaThemenbereich) {
            type = aFeld.getListe() ? "TopicArray<" + this.getTbClass((MetaThemenbereich)feld.getKlasse()) + ">" : this.getTbClass((MetaThemenbereich)feld.getKlasse());
        } else {
            this.error(aFeld, "Das Feld " + feld.getName() + " hat eine ungueltige Feld-Klasse (" + aFeld.getKlasse() + ")");
        }
        this.out.print(type);
        this.out.print("* ");
        this.out.print(StringHelper.getEscapedName(aFeld.getName()));
        this.out.print(";");
    }

    @Override
    public void visitTBMaterialReferenz(MetaTBMaterialReferenz materialReferenz) {
        MetaPLMaterial material = materialReferenz.getMaterialbeschreibung();
        MetaCustomThemenbereich materialTb = (MetaCustomThemenbereich)material.getThemenbereich();
        this.indentNewLine();
        this.out.print(this.getTbClass(materialTb));
        this.out.print("* ");
        this.out.print("__material_");
        this.out.print(StringHelper.getEscapedName(materialReferenz.getName()));
        this.out.print(";");
    }

    @Override
    public void visitPLPruefung(MetaPLPruefung aPruefung) {
        MetaCustomPruefung pruefung = (MetaCustomPruefung)aPruefung;
        this.indentNewLine();
        String[] referenzFeldStrings = null;
        String[] referenzFeldTypen = null;
        int[][] referenzFeldIndizes = null;
        if (pruefung.sizeOfHauptBezugsfeld() > 0) {
            MetaIdentifier referenzFeld = null;
            Iterator it = pruefung.getHauptBezugsfeld();
            int anzahlBezugsfelder = pruefung.sizeOfHauptBezugsfeld();
            referenzFeldTypen = new String[anzahlBezugsfelder];
            referenzFeldIndizes = new int[anzahlBezugsfelder][];
            boolean ok = true;
            NamespaceHelper nsHelper = new NamespaceHelper();
            int strukturTiefe = 0;
            while (ok && it.hasNext()) {
                ++strukturTiefe;
                referenzFeld = new MetaIdentifier(((MetaStatspezObjekt)it.next()).getName());
                if (!this.scope.isDefined(referenzFeld, nsHelper.namespace())) {
                    this.error(pruefung, "Pr\u00fcfung " + pruefung.getPruefschluessel() + ": das spezifizierte Referenz-Feld '" + nsHelper.prettyNamespacePlusSep() + referenzFeld.value() + "' ist nicht definiert");
                    ok = false;
                }
                SymbolDescriptor sd = this.scope.symbolDescriptor(referenzFeld, nsHelper.namespace());
                if (ok && strukturTiefe == anzahlBezugsfelder && sd.isArray() && (pruefung.hauptbezugsfeldIndex() == null || pruefung.hauptbezugsfeldIndex().length == 0)) {
                    this.error(pruefung, "Pr\u00fcfung " + pruefung.getPruefschluessel() + ": das spezifizierte Referenz-Listenfeld '" + nsHelper.prettyNamespacePlusSep() + referenzFeld.value() + "' wurde kein Index angegeben.");
                    ok = false;
                }
                if (ok && strukturTiefe == anzahlBezugsfelder && sd.isArray() && pruefung.hauptbezugsfeldIndex() != null) {
                    if (pruefung.hauptbezugsfeldIndex().length != sd.dimensions()) {
                        this.error(pruefung, "Pr\u00fcfung " + pruefung.getPruefschluessel() + ": das spezifizierte Referenz-Listenfeld '" + nsHelper.prettyNamespacePlusSep() + referenzFeld.value() + "' hat nicht die richtige Dimension " + sd.dimensions() + ".");
                        ok = false;
                    } else {
                        int j = 0;
                        while (j < sd.dimensions() && ok) {
                            if (sd.dimension(j) >= 0 && sd.dimension(j) < pruefung.hauptbezugsfeldIndex()[j] || pruefung.hauptbezugsfeldIndex()[j] <= 0) {
                                String def = sd.dimension(j) >= 0 ? "" + sd.dimension(j) : "N";
                                String ind = pruefung.hauptbezugsfeldIndex()[j] >= 0 ? "" + pruefung.hauptbezugsfeldIndex()[j] : "N";
                                this.error(pruefung, "Pr\u00fcfung " + pruefung.getPruefschluessel() + ": das spezifizierte Referenz-Listenfeld '" + nsHelper.prettyNamespacePlusSep() + referenzFeld.value() + "' hat einen inkonsistenten Index " + ind + " au\u00dferhalb des Bereichs bis " + def + ".");
                                ok = false;
                            }
                            ++j;
                        }
                    }
                }
                if (ok && !sd.isTbField()) {
                    this.error(pruefung, "Pr\u00fcfung " + pruefung.getPruefschluessel() + ": das spezifizierte Referenz-Feld '" + nsHelper.prettyNamespacePlusSep() + referenzFeld.value() + "' ist kein Themenbereichs-Feld");
                    ok = false;
                }
                if (ok && it.hasNext() && !sd.fieldReferencesTb()) {
                    this.error(pruefung, "Pr\u00fcfung " + pruefung.getPruefschluessel() + ": das spezifizierte Referenz-Feld '" + nsHelper.prettyNamespacePlusSep() + referenzFeld.value() + "' referenziert keinen Themenbereich");
                    ok = false;
                }
                if (ok && !it.hasNext() && sd.fieldReferencesTb()) {
                    this.error(pruefung, "Pr\u00fcfung " + pruefung.getPruefschluessel() + ": das spezifizierte Referenz-Feld '" + nsHelper.prettyNamespacePlusSep() + referenzFeld.value() + "' referenziert einen Themenbereich");
                    ok = false;
                }
                if (ok && sd.isArray()) {
                    if (strukturTiefe == anzahlBezugsfelder) {
                        referenzFeldIndizes[strukturTiefe - 1] = pruefung.hauptbezugsfeldIndex();
                    } else {
                        int[] dims = new int[sd.dimensions()];
                        int i = 0;
                        while (i < dims.length) {
                            dims[i] = 1;
                            ++i;
                        }
                        referenzFeldIndizes[strukturTiefe - 1] = dims;
                    }
                    referenzFeldTypen[strukturTiefe - 1] = sd.fieldReferencesTb() ? "TB_" + StringHelper.getEscapedName(sd.getMerkmal()) : "FeatureVariable";
                }
                if (!ok) continue;
                nsHelper.enterSubNamespace(referenzFeld.value());
            }
            referenzFeldStrings = ok ? nsHelper.namespaceAsArray() : null;
        }
        this.createFehlerMethod(this.scope, pruefung.getMetaSpezifikation().name(), pruefung.getPruefschluessel(), this.textResource.getFehlertextKurzProgram(pruefung), this.textResource.getFehlertextLangProgram(pruefung), this.textResource.getKorrekturhinweisProgram(pruefung), pruefung.getThemenbereich().getName(), referenzFeldStrings, referenzFeldTypen, referenzFeldIndizes, pruefung.getPruefungsart());
        this.indentNewLine();
        CppProgramCodeGenerator prgGen = new CppProgramCodeGenerator();
        prgGen.setOutput(this.out);
        prgGen.setIndentLevel(this.indentLevel());
        prgGen.setErrorContext(new ElementMessageContext(1, pruefung.getId(), pruefung.getPruefschluessel(), 6, pruefung.getThemenbereich().getId(), pruefung.getThemenbereich().getName()));
        prgGen.generate(pruefung.getMetaSpezifikation(), this.scope, true, new Short(pruefung.getFehlergewicht()));
    }

    @Override
    public void visitPLAblauf(MetaPLAblauf ablauf) {
        this.indentNewLine();
        CppProgramCodeGenerator prgGen = new CppProgramCodeGenerator();
        prgGen.setOutput(this.out);
        prgGen.setIndentLevel(this.indentLevel());
        MetaCustomAblauf a = (MetaCustomAblauf)ablauf;
        prgGen.setErrorContext(new ElementMessageContext(2, a.getId(), a.getName(), 6, a.getThemenbereich().getId(), a.getThemenbereich().getName()));
        prgGen.generate(a.getMetaSpezifikation(), this.scope, false);
    }

    @Override
    public void visitPLFunktion(MetaPLFunktion funktion) {
        this.indentNewLine();
        CppProgramCodeGenerator prgGen = new CppProgramCodeGenerator();
        prgGen.setOutput(this.out);
        prgGen.setIndentLevel(this.indentLevel());
        MetaCustomFunktion f = (MetaCustomFunktion)funktion;
        int contextType = 4;
        if (f.getFunctionType() == 1) {
            contextType = 3;
        }
        prgGen.setErrorContext(new ElementMessageContext(contextType, f.getId(), f.getName(), 6, f.getThemenbereich().getId(), f.getThemenbereich().getName()));
        prgGen.generate(f.getMetaSpezifikation(), this.scope, false);
    }

    @Override
    public void visitPLVariable(MetaPLVariable variable) {
        this.indentNewLine();
        if (variable.getListe()) {
            this.out.print("LocalArray*");
        } else {
            this.out.print("LocalVariable*");
        }
        this.out.print(" ");
        this.out.print(StringHelper.getEscapedName(variable.getName()));
        this.out.print(";");
    }

    @Override
    public void visitPLInitwert(MetaPLInitwert initwert) {
        this.indentNewLine();
        this.out.print("LocalVariable* ");
        this.out.print(StringHelper.getEscapedName(initwert.getName()));
        this.out.print(";");
    }

    private void createTbConstructor(MetaThemenbereich aTb) {
        String referringField;
        String referringType;
        this.defineMethod("", this.getTbClass(aTb), "TypeDescriptor* typeDescriptor, FieldDescriptor* parent, Plausi* plausi");
        this.out.print(" : ");
        this.out.print("Topic");
        this.out.print("(typeDescriptor, parent)");
        this.openBlock();
        this.indentNewLine();
        this.out.print("this->plausi = plausi;");
        if (((MetaCustomThemenbereich)aTb).countReferenzierendeFelder() > 0) {
            referringType = "typeDescriptor";
            referringField = "this";
        } else {
            referringType = "PL_NULL";
            referringField = "PL_NULL";
        }
        Iterator it = aTb.getFelder();
        while (it.hasNext()) {
            MetaCustomTBFeld aFeld = (MetaCustomTBFeld)it.next();
            this.indentNewLine();
            this.out.print(StringHelper.getEscapedName(aFeld.getName()));
            this.out.print(" = new ");
            if (aFeld.getKlasse() instanceof MetaMerkmal) {
                MetaMerkmal aMerkmal = (MetaMerkmal)aFeld.getKlasse();
                String rtType = CppSettings.getRuntimeFieldType(aMerkmal.getTyp());
                if (rtType == null) {
                    this.error(aFeld, "Ungueltiger Typ fuer das Merkmal des Felds " + aFeld.getName() + ".");
                }
                if (aFeld.getListe()) {
                    this.out.print("FieldArray");
                } else {
                    this.out.print("Field");
                }
                this.out.print("(new ");
                this.out.print("TypeDescriptor");
                this.out.print("(");
                this.out.print(referringType);
                this.out.print(", (typeDescriptor != PL_NULL) ? typeDescriptor->getMapping() : PL_NULL, \"");
                this.out.print(aFeld.getName());
                this.out.print("\", \"");
                this.out.print(StringHelper.getEscapedStringValue(CodegenUtil.getDisplayName(this.textResource, aFeld)));
                this.out.print("\", ");
                this.out.print(rtType);
                this.out.print(", ");
                if (aMerkmal.getMaske() != null && aMerkmal.getMaske().length() > 0) {
                    this.out.print("\"");
                    this.out.print(StringHelper.getEscapedStringValue(aMerkmal.getMaske()));
                    this.out.print("\"");
                } else {
                    this.out.print("PL_NULL");
                }
                this.out.print(", ");
                if (aFeld.getListe()) {
                    this.out.print(aFeld.dimensions().length);
                    int i = 0;
                    while (i < aFeld.dimensions().length) {
                        this.out.print(", ");
                        if (aFeld.dimensions()[i] > 0) {
                            this.out.print(aFeld.dimensions()[i]);
                        } else {
                            this.out.print("0");
                        }
                        ++i;
                    }
                } else {
                    this.out.print("0");
                }
                this.out.print("), ");
                this.out.print(referringField);
                this.out.print(")");
            } else {
                MetaThemenbereich feldKlasse = (MetaThemenbereich)aFeld.getKlasse();
                if (aFeld.getListe()) {
                    this.out.print("TopicArray<");
                    this.out.print(this.getTbClass(feldKlasse));
                    this.out.print(">");
                } else {
                    this.out.print(this.getTbClass(feldKlasse));
                }
                this.out.print("(");
                if (aFeld.getListe()) {
                    this.out.print("new ");
                    this.out.print(this.getTbClass(feldKlasse));
                    this.out.print("(");
                }
                this.out.print("new ");
                this.out.print("TypeDescriptor");
                this.out.print("(");
                this.out.print(referringType);
                this.out.print(", (typeDescriptor != PL_NULL) ? typeDescriptor->getMapping() : PL_NULL, \"");
                this.out.print(aFeld.getName());
                this.out.print("\", \"");
                this.out.print(StringHelper.getEscapedStringValue(CodegenUtil.getDisplayName(this.textResource, aFeld)));
                this.out.print("\", fieldTypeStructure, PL_NULL, ");
                if (aFeld.getListe()) {
                    this.out.print(aFeld.dimensions().length);
                    int i = 0;
                    while (i < aFeld.dimensions().length) {
                        this.out.print(", ");
                        if (aFeld.dimensions()[i] > 0) {
                            this.out.print(aFeld.dimensions()[i]);
                        } else {
                            this.out.print("0");
                        }
                        ++i;
                    }
                } else {
                    this.out.print("0");
                }
                this.out.print("), ");
                this.out.print(referringField);
                this.out.print(", plausi)");
                if (aFeld.getListe()) {
                    this.out.print(")");
                }
            }
            this.out.print(";");
            this.indentNewLine();
            this.out.print("setField(\"");
            this.out.print(aFeld.getName());
            this.out.print("\", ");
            this.out.print(StringHelper.getEscapedName(aFeld.getName()));
            this.out.print(");");
        }
        it = aTb.getMaterialreferenzen();
        while (it.hasNext()) {
            MetaTBMaterialReferenz materialReferenz = (MetaTBMaterialReferenz)it.next();
            MetaPLMaterial material = materialReferenz.getMaterialbeschreibung();
            MetaCustomThemenbereich materialTb = (MetaCustomThemenbereich)material.getThemenbereich();
            this.indentNewLine();
            this.out.print("__material_");
            this.out.print(StringHelper.getEscapedName(materialReferenz.getName()));
            this.out.print(" = (");
            this.out.print(this.getTbClass(materialTb));
            this.out.print("*)plausi->getMaterial(\"");
            this.out.print(materialReferenz.getName());
            this.out.print("\");");
        }
        it = aTb.getVariablen();
        while (it.hasNext()) {
            MetaPLVariable variable = (MetaPLVariable)it.next();
            this.indentNewLine();
            this.out.print(StringHelper.getEscapedName(variable.getName()));
            this.out.print(" = new ");
            if (variable.getListe()) {
                this.out.print("LocalArray");
            } else {
                this.out.print("LocalVariable");
            }
            this.out.print("(");
            if (variable.getListe()) {
                int[] dimension = Helper.parseDimensionSpec(variable.getDimension().trim());
                this.out.print(dimension.length);
                int i = 0;
                while (i < dimension.length) {
                    this.out.print(", ");
                    if (dimension[i] > 0) {
                        this.out.print(dimension[i]);
                    } else {
                        this.out.print("0");
                    }
                    ++i;
                }
            }
            this.out.print(");");
        }
        it = aTb.getInitialisierungswerte();
        while (it.hasNext()) {
            MetaPLInitwert initwert = (MetaPLInitwert)it.next();
            this.indentNewLine();
            this.out.print(StringHelper.getEscapedName(initwert.getName()));
            this.out.print(" = new LocalVariable();");
        }
        this.closeBlock();
    }

    private void createTbDestructor(MetaThemenbereich aTb) {
        this.indentNewLine();
        this.defineMethod("", "~" + this.getTbClass(aTb), "");
        this.openBlock();
        Iterator it = aTb.getVariablen();
        while (it.hasNext()) {
            MetaPLVariable variable = (MetaPLVariable)it.next();
            this.indentNewLine();
            this.out.print("delete ");
            this.out.print(StringHelper.getEscapedName(variable.getName()));
            this.out.print(";");
        }
        it = aTb.getInitialisierungswerte();
        while (it.hasNext()) {
            MetaPLInitwert initwert = (MetaPLInitwert)it.next();
            this.indentNewLine();
            this.out.print("delete ");
            this.out.print(StringHelper.getEscapedName(initwert.getName()));
            this.out.print(";");
        }
        this.closeBlock();
    }

    private void createInitMethod(MetaThemenbereich aTb) {
        if (aTb.sizeOfInitialisierungswerte() > 0) {
            MetaCustomInitwert anInitwert;
            this.indentNewLine();
            this.indentNewLine();
            this.out.print("PL_VOID ");
            this.out.print("init");
            this.out.print("(");
            this.out.print("RuntimeContext*");
            this.out.print(" context");
            Iterator it = aTb.getInitialisierungswerte();
            while (it.hasNext()) {
                anInitwert = (MetaCustomInitwert)it.next();
                this.out.print(", Value* ");
                this.out.print(StringHelper.getEscapedName(anInitwert.getName()));
            }
            this.out.print(")");
            this.openBlock();
            it = aTb.getInitialisierungswerte();
            while (it.hasNext()) {
                anInitwert = (MetaCustomInitwert)it.next();
                this.indentNewLine();
                this.out.print("this->");
                this.out.print(StringHelper.getEscapedName(anInitwert.getName()));
                this.out.print("->set(context, ");
                this.out.print(StringHelper.getEscapedName(anInitwert.getName()));
                this.out.print(");");
            }
            this.closeBlock();
        }
    }

    private void createGetInstanceMethod(MetaThemenbereich aTb) {
        this.indentNewLine();
        this.out.print("Topic");
        this.out.print("* ");
        this.out.print("createNewInstance");
        this.out.print("()");
        this.openBlock();
        this.indentNewLine();
        this.out.print("return new ");
        this.out.print(this.getTbClass(aTb));
        this.out.print("(");
        this.out.print("getTypeDescriptor");
        this.out.print("(), ");
        this.out.print("getParent");
        this.out.print("(), this->plausi);");
        this.closeBlock();
    }
}

