/*
 * Decompiled with CFR 0.152.
 */
package com.bitmechanic.maxq;

import com.bitmechanic.maxq.Preferences;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class PrefsDialog
extends JDialog
implements ActionListener {
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private JTextField portField = new JTextField();
    private JTextField scriptDirField = new JTextField();
    private Preferences prefs;

    public PrefsDialog(Frame frame, Preferences prefs) {
        super(frame);
        this.prefs = prefs;
        this.portField.setText(String.valueOf(prefs.getPort()));
        this.scriptDirField.setText(prefs.getLibDir());
        this.setTitle("MaxQ Preferences");
        Dimension size = new Dimension(300, 200);
        this.setSize(size);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
            }
        });
        this.cancelButton.addActionListener(this);
        this.okButton.addActionListener(this);
        Container c = this.getContentPane();
        c.setLayout(new GridLayout(3, 2));
        c.add(new JLabel("Proxy Port:"));
        c.add(this.portField);
        c.add(new JLabel("Python Script Dir:"));
        c.add(this.scriptDirField);
        c.add(this.okButton);
        c.add(this.cancelButton);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.cancelButton) {
            this.dispose();
        } else if (source == this.okButton) {
            try {
                this.prefs.setPort(Integer.parseInt(this.portField.getText()));
                this.prefs.setLibDir(this.scriptDirField.getText());
                this.prefs.save();
                this.dispose();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

