/*
 * Decompiled with CFR 0.152.
 */
package org.junit.rules;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.junit.Assert;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.matchers.ThrowableCauseMatcher;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.rules.ExpectedExceptionMatcherBuilder;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpectedException
implements TestRule {
    private final ExpectedExceptionMatcherBuilder fMatcherBuilder = new ExpectedExceptionMatcherBuilder();
    private boolean handleAssumptionViolatedExceptions = false;
    private boolean handleAssertionErrors = false;

    public static ExpectedException none() {
        return new ExpectedException();
    }

    private ExpectedException() {
    }

    public ExpectedException handleAssertionErrors() {
        this.handleAssertionErrors = true;
        return this;
    }

    public ExpectedException handleAssumptionViolatedExceptions() {
        this.handleAssumptionViolatedExceptions = true;
        return this;
    }

    @Override
    public Statement apply(Statement base, Description description) {
        return new ExpectedExceptionStatement(base);
    }

    public void expect(Matcher<?> matcher) {
        this.fMatcherBuilder.add(matcher);
    }

    public void expect(Class<? extends Throwable> type) {
        this.expect(CoreMatchers.instanceOf(type));
    }

    public void expectMessage(String substring) {
        this.expectMessage((Matcher<String>)CoreMatchers.containsString((String)substring));
    }

    public void expectMessage(Matcher<String> matcher) {
        this.expect(ThrowableMessageMatcher.hasMessage(matcher));
    }

    public void expectCause(Matcher<? extends Throwable> expectedCause) {
        this.expect(ThrowableCauseMatcher.hasCause(expectedCause));
    }

    private void failDueToMissingException() throws AssertionError {
        String expectation = StringDescription.toString(this.fMatcherBuilder.build());
        Assert.fail("Expected test to throw " + expectation);
    }

    private void optionallyHandleException(Throwable e, boolean handleException) throws Throwable {
        if (!handleException) {
            throw e;
        }
        this.handleException(e);
    }

    private void handleException(Throwable e) throws Throwable {
        if (!this.fMatcherBuilder.expectsThrowable()) {
            throw e;
        }
        Assert.assertThat(e, this.fMatcherBuilder.build());
    }

    private class ExpectedExceptionStatement
    extends Statement {
        private final Statement fNext;

        public ExpectedExceptionStatement(Statement base) {
            this.fNext = base;
        }

        public void evaluate() throws Throwable {
            try {
                this.fNext.evaluate();
                if (ExpectedException.this.fMatcherBuilder.expectsThrowable()) {
                    ExpectedException.this.failDueToMissingException();
                }
            }
            catch (AssumptionViolatedException e) {
                ExpectedException.this.optionallyHandleException(e, ExpectedException.this.handleAssumptionViolatedExceptions);
            }
            catch (AssertionError e) {
                ExpectedException.this.optionallyHandleException((Throwable)((Object)e), ExpectedException.this.handleAssertionErrors);
            }
            catch (Throwable e) {
                ExpectedException.this.handleException(e);
            }
        }
    }
}

