/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.csvinspector;

import de.destatis.core.connect.util.Contract;
import de.destatis.core.csvinspector.CsvInspectionProblem;
import de.destatis.core.csvinspector.CsvInspectionReport;
import de.destatis.core.csvinspector.FatalException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class CsvInspectionReporter {
    protected static final int MAX_PROBLEMS_DECLARATION_PER_PROBLEM_CLASS = 100;
    protected static final int MAX_PROBLEMS_TOTAL = 10000;
    private Date date = null;
    private InspectionProblemList problemList = new InspectionProblemList();
    private ProblemCounter problemCounter = new ProblemCounter();
    private boolean dataInspectionActive = true;
    private boolean dataInspectionWithoutReportRejection = true;
    private boolean unitIdVerificationActive = false;
    private int declnum = 0;
    private int recno = 0;
    private DeclarationInfos declarationInfos = new DeclarationInfos();

    public void setDate(Date date) {
        this.date = date;
    }

    public void setDataInspectionActive(boolean dataInspectionActive) {
        this.dataInspectionActive = dataInspectionActive;
    }

    public void setDataInspectionWithoutReportRejection(boolean dataInspectionWithoutReportRejection) {
        this.dataInspectionWithoutReportRejection = dataInspectionWithoutReportRejection;
    }

    public void setUnitIdVerificationActive(boolean unitIdVerificationActive) {
        this.unitIdVerificationActive = unitIdVerificationActive;
    }

    public void setCollectorCorrection(int declno, String collectorCorrection) {
        DeclarationInfo declarationInfo = this.declarationInfos.getAndCreateDeclarationInfo(declno);
        declarationInfo.setCollectorCorrection(collectorCorrection);
    }

    public void nextDeclaration() {
        ++this.declnum;
        this.recno = 0;
    }

    public int getNumOfDeclarations() {
        return this.declnum;
    }

    public int getDeclarationNo() {
        return this.declnum;
    }

    public void nextRecord() {
        ++this.recno;
    }

    public int getRecordNo() {
        return this.recno;
    }

    public void addProblem(CsvInspectionProblem problem) {
        this.problemList.addProblem(problem);
        this.problemCounter.addProblem(problem);
        if (problem.getProblemType() == CsvInspectionProblem.ProblemType.INVALID_UNIT_ID) {
            DeclarationInfo declarationInfo = this.declarationInfos.getAndCreateDeclarationInfo(problem.getDeclarationNo());
            declarationInfo.setInvalidUnitId(true);
        }
        if (problem.getProblemClass() == CsvInspectionProblem.ProblemClass.FATAL) {
            throw new FatalException();
        }
    }

    public CsvInspectionReport getReport() {
        return new CsvInspectionReport(this.date, this.problemList.getProblemList(), this.problemCounter, this.dataInspectionActive, this.dataInspectionWithoutReportRejection, this.unitIdVerificationActive, this.declnum, this.declarationInfos);
    }

    protected ProblemCounter getProblemCounter() {
        return this.problemCounter;
    }

    protected InspectionProblemList getProblemList() {
        return this.problemList;
    }

    public static class DeclarationInfo {
        private boolean invalidUnitId = false;
        private String collectorCorrection = null;

        public boolean isInvalidUnitId() {
            return this.invalidUnitId;
        }

        public void setInvalidUnitId(boolean invalidUnitId) {
            this.invalidUnitId = invalidUnitId;
        }

        public String getCollectorCorrection() {
            return this.collectorCorrection;
        }

        public void setCollectorCorrection(String collectorCorrection) {
            this.collectorCorrection = collectorCorrection;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append("InvalUnitId: ").append(this.invalidUnitId);
            result.append(", CollCorr: ").append(this.collectorCorrection);
            return result.toString();
        }
    }

    public static class ProblemCounter {
        private Map<Integer, Map<CsvInspectionProblem.ProblemClass, Counter>> declarationMap = new HashMap<Integer, Map<CsvInspectionProblem.ProblemClass, Counter>>();

        private ProblemCounter() {
        }

        public void addProblem(CsvInspectionProblem problem) {
            Counter counter;
            int declno = problem.getDeclarationNo();
            Map<CsvInspectionProblem.ProblemClass, Counter> problemMap = this.declarationMap.get(declno);
            if (problemMap == null) {
                problemMap = new HashMap<CsvInspectionProblem.ProblemClass, Counter>();
                this.declarationMap.put(declno, problemMap);
            }
            if ((counter = problemMap.get((Object)problem.getProblemClass())) == null) {
                counter = new Counter();
                problemMap.put(problem.getProblemClass(), counter);
            }
            counter.counter++;
        }

        public int getProblemCount(int declno, CsvInspectionProblem.ProblemClass problemClass) {
            int count = 0;
            if (declno == -1) {
                for (Map<CsvInspectionProblem.ProblemClass, Counter> problemMap : this.declarationMap.values()) {
                    if (problemClass == null) {
                        for (Counter counter : problemMap.values()) {
                            count += counter.counter;
                        }
                        continue;
                    }
                    Counter counter = problemMap.get((Object)problemClass);
                    if (counter == null) continue;
                    count += counter.counter;
                }
            } else {
                Map<CsvInspectionProblem.ProblemClass, Counter> problemMap = this.declarationMap.get(declno);
                if (problemMap != null) {
                    if (problemClass == null) {
                        for (Counter counter : problemMap.values()) {
                            count += counter.counter;
                        }
                    } else {
                        Counter counter = problemMap.get((Object)problemClass);
                        if (counter != null) {
                            count += counter.counter;
                        }
                    }
                }
            }
            return count;
        }
    }

    private static class Counter {
        private int counter = 0;

        private Counter() {
        }

        public String toString() {
            return String.valueOf(this.counter);
        }
    }

    public static class DeclarationInfos {
        private final Vector<DeclarationInfo> declarationList = new Vector(100, 100);

        private DeclarationInfos() {
        }

        public DeclarationInfo getDeclarationInfo(int declno) {
            DeclarationInfo result = null;
            Contract.verify((declno > 0 ? 1 : 0) != 0, (String)"declno muss > 0 sein.");
            int declIdx = declno - 1;
            if (declIdx < this.declarationList.size()) {
                result = this.declarationList.elementAt(declIdx);
            }
            return result;
        }

        private DeclarationInfo getAndCreateDeclarationInfo(int declno) {
            Contract.verify((declno > 0 ? 1 : 0) != 0, (String)"declno muss > 0 sein.");
            int declIdx = declno - 1;
            DeclarationInfo declInfo = null;
            if (declIdx < this.declarationList.size()) {
                declInfo = this.declarationList.elementAt(declIdx);
            }
            if (declInfo == null) {
                declInfo = new DeclarationInfo();
                if (declIdx >= this.declarationList.size()) {
                    this.declarationList.setSize(declno);
                }
                this.declarationList.setElementAt(declInfo, declIdx);
            }
            return declInfo;
        }
    }

    protected class InspectionProblemList {
        private List<CsvInspectionProblem> problems = new LinkedList<CsvInspectionProblem>();

        public void addProblem(CsvInspectionProblem problem) {
            boolean isSpaceInList;
            int declno = problem.getDeclarationNo();
            CsvInspectionProblem.ProblemClass problemClass = problem.getProblemClass();
            int problemCount = CsvInspectionReporter.this.problemCounter.getProblemCount(declno, problemClass);
            if (problemCount >= 100) {
                return;
            }
            boolean bl = isSpaceInList = this.problems.size() < 10000;
            if (!isSpaceInList) {
                return;
            }
            this.problems.add(problem);
        }

        public List<CsvInspectionProblem> getProblemList() {
            return this.problems;
        }
    }
}

