/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.geometric;

import java.io.Serializable;
import java.sql.SQLException;
import org.postgresql.geometric.PGpoint;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class PGbox
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint[] point = new PGpoint[2];

    public PGbox(double x1, double y1, double x2, double y2) {
        this();
        this.point[0] = new PGpoint(x1, y1);
        this.point[1] = new PGpoint(x2, y2);
    }

    public PGbox(PGpoint p1, PGpoint p2) {
        this();
        this.point[0] = p1;
        this.point[1] = p2;
    }

    public PGbox(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public PGbox() {
        this.setType("box");
    }

    public void setValue(String value) throws SQLException {
        PGtokenizer t = new PGtokenizer(value, ',');
        if (t.getSize() != 2) {
            throw new PSQLException("postgresql.geo.box", PSQLState.DATA_TYPE_MISMATCH, value);
        }
        this.point[0] = new PGpoint(t.getToken(0));
        this.point[1] = new PGpoint(t.getToken(1));
    }

    public boolean equals(Object obj) {
        if (obj instanceof PGbox) {
            PGbox p = (PGbox)obj;
            return p.point[0].equals(this.point[0]) && p.point[1].equals(this.point[1]) || p.point[0].equals(this.point[1]) && p.point[1].equals(this.point[0]);
        }
        return false;
    }

    public Object clone() {
        return new PGbox((PGpoint)this.point[0].clone(), (PGpoint)this.point[1].clone());
    }

    public String getValue() {
        return this.point[0].toString() + "," + this.point[1].toString();
    }
}

