/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.util.CryptUtils;
import de.memtext.util.FileUtils;
import de.memtext.util.StringUtils;
import de.superx.common.DBServletException;
import de.superx.servlet.XmlTransformer;
import de.superx.util.SqlStringUtils;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

public class PreparedXmlProcessor {
    private ServletConfig servletConfig;
    private String mandantenID;
    private String browser;
    private HttpServletRequest request;
    private HttpServletResponse response;

    public PreparedXmlProcessor(ServletConfig servletConfig, HttpServletRequest request, HttpServletResponse response, String mandantenID, String browser) {
        this.servletConfig = servletConfig;
        this.request = request;
        this.response = response;
        this.mandantenID = mandantenID;
        this.browser = browser;
    }

    private ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    private String getMandantenID() {
        return this.mandantenID;
    }

    public boolean isFileOk(String filename, Object notolderthan) {
        boolean isOk = true;
        File f2 = new File(this.getServletConfig().getServletContext().getRealPath("/WEB-INF/preparedxml/" + filename));
        int age = 0;
        if (notolderthan != null) {
            age = notolderthan instanceof Integer ? (Integer)notolderthan : Integer.parseInt(notolderthan.toString());
        }
        if (!f2.exists() || age > 0 && FileUtils.getHowOld(f2) > age) {
            isOk = false;
        }
        return isOk;
    }

    public boolean process(String filename, String stylesheet, String contenttype, Object encrypted) throws DBServletException, FactoryConfigurationError, IOException, ParserConfigurationException, TransformerException {
        boolean success = false;
        File f2 = new File(this.getServletConfig().getServletContext().getRealPath("/WEB-INF/preparedxml/" + filename));
        if (f2.exists()) {
            success = this.xmlProcessing(f2, stylesheet, contenttype, encrypted);
        }
        return success;
    }

    private boolean xmlProcessing(File f2, String stylesheet, String contenttype, Object encrypted) throws DBServletException, FactoryConfigurationError, IOException, ParserConfigurationException, TransformerException {
        boolean success = false;
        if (contenttype == null || contenttype.trim().equals("")) {
            contenttype = "text/html; charset=" + SqlStringUtils.getEncoding();
        }
        Logger.getLogger("superx_" + this.getMandantenID()).log(Level.INFO, "Benutze " + f2 + " als Quelle f\u00fcr Startseite");
        String xml = StringUtils.readFile(f2);
        if (encrypted != null && encrypted.toString().equals("1")) {
            xml = CryptUtils.simpleDecryptString2(xml);
        }
        if (xml.indexOf("<ergebnisse") > -1) {
            XmlTransformer xmlTransformer = new XmlTransformer(this.getServletConfig(), this.request, this.response, this.getMandantenID(), this.browser);
            xmlTransformer.transform("Ergebnis", null, xml, null, stylesheet, contenttype, "false");
            success = true;
        }
        return success;
    }
}

