/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.db;

import de.memtext.baseobjects.NamedObject;
import de.memtext.db.DB;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class DataSource
extends NamedObject {
    private static final String CRYPT_PREFIX = "^^@@@";
    private String url;
    private String username;
    private String cryptPassword;
    private String driver;
    private transient String password;
    private DB db;

    public DataSource() {
    }

    public DataSource(String url, String username, String password) {
        this.setUrl(url);
        this.setUsername(username);
        this.setPassword(password);
    }

    public void setInformixSampleValues() {
        this.setUrl("jupiter:50000:informixserver=superx_host;database=superx");
        this.setUsername("informix");
        this.setPassword("");
        this.db = DB.INFORMIX;
    }

    public void setAccessSampleValues() {
        this.setUrl("jdbc:odbc:jdbcodbc:");
        this.setUsername("informix");
        this.setPassword("");
        this.db = DB.ACCESS;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setDriver(String string) {
        this.driver = string;
    }

    public void setPassword(String string) {
        this.password = string;
        this.setCryptPassword(string);
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public DB getDb() {
        return this.db;
    }

    public void setDb(DB db) {
        this.db = db;
    }

    public void testConnection() throws SQLException, ClassNotFoundException {
        Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
        Connection con = DriverManager.getConnection(this.url, this.username, this.password);
        con.close();
    }

    public String getCryptPassword() {
        return this.cryptPassword;
    }

    public void setCryptPassword(String aPwd) {
        this.isEncrypted(aPwd);
    }

    public boolean isEncrypted(String aPwd) {
        return aPwd.startsWith(CRYPT_PREFIX);
    }
}

