/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxDecimal;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.lang.Decimal;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.dateUtil;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class IfxDateTime
extends IfxObject {
    private long h = 0L;
    private int i = 0;
    private boolean j = false;
    private short k = 0;
    protected Calendar dbCalendar = null;
    private byte[] l = null;
    private short m = 0;
    public static final byte TU_YEAR = 0;
    public static final byte TU_MONTH = 2;
    public static final byte TU_DAY = 4;
    public static final byte TU_HOUR = 6;
    public static final byte TU_MINUTE = 8;
    public static final byte TU_SECOND = 10;
    public static final byte TU_FRAC = 12;
    public static final byte TU_F1 = 11;
    public static final byte TU_F2 = 12;
    public static final byte TU_F3 = 13;
    public static final byte TU_F4 = 14;
    public static final byte TU_F5 = 15;
    public static int n;

    IfxDateTime() throws SQLException {
        this.setIfxType(10);
    }

    IfxDateTime(Time time) throws SQLException {
        this.setIfxType(10);
        this.k = IfxDateTime.a((byte)6, (byte)10);
        if (time != null) {
            this.h = time.getTime();
            this.j = true;
            this.unnullify();
        }
    }

    IfxDateTime(Timestamp timestamp) throws SQLException {
        this.setIfxType(10);
        this.k = IfxDateTime.a((byte)0, (byte)15);
        if (timestamp != null) {
            this.h = timestamp.getTime();
            this.i = timestamp.getNanos();
            this.j = false;
            this.unnullify();
        }
    }

    public byte[] toIfx() {
        if (this.j) {
            return JavaToIfxType.JavaToIfxDateTime(new Time(this.h));
        }
        Timestamp timestamp = new Timestamp(this.h);
        timestamp.setNanos(this.i);
        return JavaToIfxType.JavaToIfxDateTime(timestamp, this.dbCalendar);
    }

    public byte[] toIfxTuple() {
        if (this.isNull()) {
            return JavaToIfxType.JavaToIfxDecimalNull((short)this.encodedLength);
        }
        byte[] byArray = this.toIfx();
        return Decimal.fromBindToTuple(byArray, IfxDecimal.decLength(this.encodedLength));
    }

    public void fromIfx(byte[] byArray, short s) {
        this.fromIfx(byArray, 0, byArray.length, s);
    }

    public void fromIfx(byte[] byArray, int n, int n2, short s) {
        block3: {
            block5: {
                Timestamp timestamp;
                block4: {
                    boolean bl;
                    block2: {
                        bl = IfxSqliConnect.db;
                        this.l = new byte[n2];
                        System.arraycopy(byArray, n, this.l, 0, n2);
                        if (byArray[n] != 0 || byArray[n + 1] != 0) break block2;
                        this.nullify();
                        if (!bl) break block3;
                    }
                    this.m = s;
                    this.k = s;
                    timestamp = IfxToJavaType.IfxToJavaDateTime(byArray, n, n2, s, this.dbCalendar);
                    this.h = timestamp.getTime();
                    if (IfxDateTime.getStartCode(this.k) < 6 || IfxDateTime.getEndCode(this.k) > 10) break block4;
                    this.k = IfxDateTime.a((byte)6, (byte)10);
                    this.i = 0;
                    this.j = true;
                    if (!bl) break block5;
                }
                this.k = IfxDateTime.a((byte)0, (byte)15);
                this.i = timestamp.getNanos();
                this.j = false;
            }
            this.unnullify();
        }
    }

    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        if (this.j) {
            return Time.valueOf(new Time(this.h).toString());
        }
        Timestamp timestamp = new Timestamp(this.h);
        timestamp.setNanos(this.i);
        return timestamp;
    }

    public java.sql.Date toDate() {
        if (this.isNull()) {
            return null;
        }
        return new java.sql.Date(this.h);
    }

    public void fromDate(java.sql.Date date) throws SQLException {
        block3: {
            block2: {
                if (date != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.db) break block3;
            }
            this.h = date.getTime();
            this.i = 0;
            this.j = false;
            this.unnullify();
        }
    }

    public Timestamp toTimestamp() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        Timestamp timestamp = new Timestamp(this.h);
        timestamp.setNanos(this.i);
        return timestamp;
    }

    public void fromTimestamp(Timestamp timestamp) throws SQLException {
        block3: {
            block2: {
                if (timestamp != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.db) break block3;
            }
            this.h = timestamp.getTime();
            this.i = timestamp.getNanos();
            this.j = false;
            this.k = IfxDateTime.a((byte)0, (byte)15);
            this.unnullify();
        }
    }

    public void fromRawDateTime(byte[] byArray, short s) throws SQLException {
        block3: {
            block4: {
                boolean bl;
                block2: {
                    bl = IfxSqliConnect.db;
                    if (byArray != null) break block2;
                    this.nullify();
                    if (!bl) break block3;
                }
                int n = byArray.length;
                this.l = new byte[n];
                System.arraycopy(byArray, 0, this.l, 0, n);
                if (byArray[0] != 0 || byArray[1] != 0) break block4;
                this.nullify();
                if (!bl) break block3;
            }
            this.j = false;
            this.m = s;
            this.unnullify();
        }
    }

    Timestamp a(Calendar calendar) throws SQLException {
        if (this.l == null || this.l.length == 0 || this.m == 0) {
            return null;
        }
        Decimal decimal = new Decimal(this.l, 0, this.l.length, this.m, true);
        Timestamp timestamp = decimal.timestampValue(calendar);
        this.h = timestamp.getTime();
        this.i = timestamp.getNanos();
        return timestamp;
    }

    public void fromTimestamp(Timestamp timestamp, short s) throws SQLException {
        block3: {
            block2: {
                if (timestamp != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.db) break block3;
            }
            this.h = timestamp.getTime();
            this.i = timestamp.getNanos();
            this.j = false;
            this.k = s;
            this.unnullify();
        }
    }

    public Time toTime() throws SQLException {
        int n;
        if (this.isNull()) {
            return null;
        }
        Time time = new Time(this.h);
        String string = time.toString();
        if (string == null) {
            return null;
        }
        Time time2 = null;
        int n2 = string.indexOf(58);
        if (n2 > 0 & (n = string.indexOf(58, n2 + 1)) > 0 & n < string.length() - 1) {
            int n3 = Integer.parseInt(string.substring(0, n2));
            int n4 = Integer.parseInt(string.substring(n2 + 1, n));
            int n5 = Integer.parseInt(string.substring(n + 1));
            time2 = new Time(n3, n4, n5);
            time = null;
        }
        return time2;
    }

    public void fromTime(Time time) throws SQLException {
        block3: {
            block2: {
                if (time != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.db) break block3;
            }
            this.h = time.getTime();
            this.j = true;
            this.k = IfxDateTime.a((byte)6, (byte)10);
            this.unnullify();
        }
    }

    public String toString() {
        String string = null;
        if (this.isNull()) {
            return null;
        }
        try {
            if (this.j) {
                Time time = new Time(this.h);
                string = dateUtil.convertDateTimeStr(time, this.conn, this.h);
            } else if (this.h + (long)(this.i / 1000000) != 0L || this.l == null || this.l.length < 1) {
                Timestamp timestamp = this.toTimestamp();
                string = dateUtil.convertDateTimeStr(timestamp, this.conn, this.h);
            } else {
                StringBuffer stringBuffer = new StringBuffer(this.l.length * 3 + 2);
                for (int i2 = 0; i2 < this.l.length; ++i2) {
                    stringBuffer.append(' ');
                    stringBuffer.append(this.l[i2]);
                    if (!IfxSqliConnect.db) continue;
                }
                string = new String(stringBuffer);
            }
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public String toUnloadString() {
        if (this.isNull()) {
            return null;
        }
        return IfxToJavaType.IfxToDateTimeUnloadString(this.l, 0, this.l.length, this.m);
    }

    public void fromString(String string) throws SQLException {
        block8: {
            block7: {
                if (string != null) break block7;
                this.nullify();
                if (!IfxSqliConnect.db) break block8;
            }
            String string2 = string.trim();
            boolean bl = false;
            try {
                Timestamp timestamp = (Timestamp)dateUtil.convertDateTimeObj(string2, this.conn, bl);
                this.h = timestamp.getTime();
                this.i = timestamp.getNanos();
                this.j = false;
                this.unnullify();
            }
            catch (SQLException sQLException) {
                try {
                    bl = true;
                    Object object = dateUtil.convertDateTimeObj(string2, this.conn, bl);
                    this.h = ((Date)object).getTime();
                    Time time = new Time(this.h);
                    this.i = 0;
                    this.j = true;
                    this.k = IfxDateTime.a((byte)6, (byte)10);
                    this.unnullify();
                }
                catch (Exception exception) {
                    this.nullify();
                    this.h = 0L;
                    this.i = 0;
                    throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
                }
            }
            catch (Exception exception) {
                this.nullify();
                this.h = 0L;
                this.i = 0;
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
    }

    public boolean equals(Object object) {
        if (this.isNull() || object == null) {
            return false;
        }
        if (object instanceof IfxDateTime) {
            IfxDateTime ifxDateTime = (IfxDateTime)object;
            if (ifxDateTime.isNull()) {
                return false;
            }
            if (ifxDateTime.h == this.h && ifxDateTime.i == this.i) {
                return true;
            }
        }
        return false;
    }

    static short a(byte by, byte by2) {
        short s = (short)(by2 - by + (by == 0 ? 4 : 2));
        short s2 = (short)((byte)s << 8 | by << 4 | by2);
        return s2;
    }

    static byte a(short s) {
        byte by = (byte)(s >> 8);
        return by;
    }

    public static byte getStartCode(short s) {
        byte by = (byte)(s >> 4 & 0xF);
        return by;
    }

    public static byte getEndCode(short s) {
        byte by = (byte)(s & 0xF);
        return by;
    }

    public short getEncodedLength() {
        if (this.k == 0) {
            byte by = 0;
            byte by2 = 15;
            this.k = IfxDateTime.a(by, by2);
        }
        return this.k;
    }

    static String a(short s, int n) {
        if (s == 0) {
            return null;
        }
        byte by = IfxDateTime.getStartCode(s);
        byte by2 = IfxDateTime.getEndCode(s);
        byte by3 = IfxDateTime.a(s);
        String string = IfxDateTime.a(by, true);
        if (n == 14 && by <= 10) {
            int n2 = by3 - by2 + by;
            string = string + "(" + n2 + ")";
        }
        string = string + " to ";
        string = string + IfxDateTime.a(by2, false);
        return string;
    }

    static String a(byte by, boolean bl) {
        if (bl && by >= 11) {
            return "fraction";
        }
        switch (by) {
            case 0: {
                return "year";
            }
            case 2: {
                return "month";
            }
            case 4: {
                return "day";
            }
            case 6: {
                return "hour";
            }
            case 8: {
                return "minute";
            }
            case 10: {
                return "second";
            }
            case 11: {
                return "fraction(1)";
            }
            case 12: {
                return "fraction(2)";
            }
            case 13: {
                return "fraction(3)";
            }
            case 14: {
                return "fraction(4)";
            }
            case 15: {
                return "fraction(5)";
            }
        }
        return "";
    }

    public boolean isTimeValue() {
        return this.j;
    }
}

