/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.testdriver;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class CanonicalXML
extends DefaultHandler
implements LexicalHandler {
    private StringWriter out;
    private StringBuffer buf = new StringBuffer();
    private boolean strip = false;
    private boolean isWhite = true;
    private AttributesImpl namespaces = new AttributesImpl();

    public String toCanonicalXML(XMLReader parser, InputSource inputSource, boolean stripSpace) {
        this.strip = stripSpace;
        this.out = new StringWriter();
        parser.setContentHandler(this);
        try {
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            // empty catch block
        }
        parser.setErrorHandler(this);
        try {
            parser.parse(inputSource);
            return this.out.toString();
        }
        catch (SAXParseException e) {
            System.err.println("XML parsing error on line " + e.getLineNumber() + " while creating Canonical XML");
            System.err.println(e.getMessage());
            System.err.println("Parser: " + parser.getClass());
            try {
                System.err.println("Supports XML 1.1: " + parser.getFeature("http://xml.org/sax/features/xml-1.1"));
            }
            catch (Exception exception) {}
        }
        catch (SAXException e) {
            System.err.println("XML parsing error while creating Canonical XML");
            System.err.println(e.getMessage());
        }
        catch (IOException e) {
            System.err.println("XML parsing error while creating Canonical XML");
            System.err.println(e.toString());
        }
        return null;
    }

    public String toCanonicalXML2(XMLReader parser, InputSource inputSource, boolean stripSpace) throws Exception {
        this.strip = stripSpace;
        this.out = new StringWriter();
        parser.setContentHandler(this);
        try {
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            // empty catch block
        }
        parser.setErrorHandler(this);
        parser.parse(inputSource);
        return this.out.toString();
    }

    public String toCanonicalXML3(TransformerFactory factory, XMLReader resultParser, String inxml, boolean stripSpace) throws Exception {
        this.strip = stripSpace;
        this.out = new StringWriter();
        Transformer t = factory.newTransformer();
        SAXSource ss = new SAXSource(resultParser, new InputSource(new StringReader(inxml)));
        ss.setSystemId("http://localhost/string-input");
        t.setOutputProperty("method", "xml");
        t.setOutputProperty("indent", "no");
        t.transform(ss, new SAXResult(this));
        return this.out.toString();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaces.addAttribute("", prefix, prefix.equals("") ? "xmlns" : "xmlns:" + prefix, "CDATA", uri);
        if (!"".equals(uri)) {
            try {
                URI u = new URI(uri);
                if (!u.isAbsolute()) {
                    System.err.println("*** (Canonical XML:) namespace URI " + u + " is not absolute");
                }
            }
            catch (URISyntaxException err) {
                System.err.println("*** (Canonical XML:) namespace " + uri + " is not a valid URI");
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.flushChars();
        this.write("<");
        this.write(qName);
        this.outputAttributes(this.namespaces);
        this.outputAttributes(atts);
        this.write(">");
        this.namespaces.clear();
    }

    private void outputAttributes(Attributes atts) {
        int len = atts.getLength();
        if (len > 0) {
            int n;
            int i;
            int[] v = new int[len];
            for (i = 0; i < len; ++i) {
                v[i] = i;
            }
            for (i = 1; i < len; ++i) {
                n = v[i];
                String s = atts.getQName(n);
                for (int j = i - 1; j >= 0 && s.compareTo(atts.getQName(v[j])) < 0; --j) {
                    v[j + 1] = v[j];
                }
                v[j + 1] = n;
            }
            for (i = 0; i < len; ++i) {
                this.write(" ");
                n = v[i];
                this.write(atts.getQName(n));
                this.write("=\"");
                String value = atts.getValue(n);
                int valueLen = value.length();
                for (int j = 0; j < valueLen; ++j) {
                    this.appendChar(value.charAt(j));
                }
                this.flushChars();
                this.write("\"");
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] cbuf, int start, int len) {
        this.characters(cbuf, start, len);
    }

    @Override
    public void characters(char[] cbuf, int start, int len) {
        while (len-- > 0) {
            this.appendChar(cbuf[start++]);
        }
    }

    private void appendChar(char c) {
        if (this.strip && this.isWhite && !Character.isWhitespace(c)) {
            this.isWhite = false;
        }
        switch (c) {
            case '\u0001': 
            case '\u0002': 
            case '\u0003': 
            case '\u0004': 
            case '\u0005': 
            case '\u0006': 
            case '\u0007': 
            case '\b': 
            case '\u000b': 
            case '\f': 
            case '\u000e': 
            case '\u000f': {
                this.buf.append(this.charRef(c));
                break;
            }
            case '&': {
                this.buf.append("&amp;");
                break;
            }
            case '<': {
                this.buf.append("&lt;");
                break;
            }
            case '>': {
                this.buf.append("&gt;");
                break;
            }
            case '\"': {
                this.buf.append("&quot;");
                break;
            }
            case '\t': {
                this.buf.append("&#9;");
                break;
            }
            case '\n': {
                this.buf.append("&#10;");
                break;
            }
            case '\r': {
                this.buf.append("&#13;");
                break;
            }
            case '\u0080': 
            case '\u0081': 
            case '\u0082': 
            case '\u0083': 
            case '\u0084': 
            case '\u0085': 
            case '\u0086': 
            case '\u0087': 
            case '\u0088': 
            case '\u0089': 
            case '\u008a': 
            case '\u008b': 
            case '\u008c': 
            case '\u008d': 
            case '\u008e': 
            case '\u008f': 
            case '\u0090': 
            case '\u0091': 
            case '\u0092': 
            case '\u0093': 
            case '\u0094': 
            case '\u0095': 
            case '\u0096': 
            case '\u0097': 
            case '\u0098': 
            case '\u0099': 
            case '\u009a': 
            case '\u009b': 
            case '\u009c': 
            case '\u009d': 
            case '\u009e': 
            case '\u009f': 
            case '\u00a0': {
                this.buf.append(this.charRef(c));
                break;
            }
            default: {
                this.buf.append(c);
            }
        }
    }

    private String charRef(char c) {
        return "&#" + c + ";";
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.flushChars();
        this.write("</");
        this.write(qName);
        this.write(">");
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.flushChars();
        this.write("<?");
        this.write(target);
        this.write(" ");
        this.write(data);
        this.write("?>");
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.flushChars();
            this.out.close();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.flushChars();
        this.write("<!--");
        this.write(new String(ch, start, length));
        this.write("-->");
    }

    private void flushChars() {
        if (!(this.buf.length() <= 0 || this.strip && this.isWhite)) {
            this.write(this.buf.toString());
        }
        this.buf.setLength(0);
        this.isWhite = true;
    }

    private void write(String s) {
        int len = s.length();
        block4: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c < '\u0080') {
                this.out.write(c);
                continue;
            }
            switch (c & 0xF800) {
                case 0: {
                    this.out.write(c >> 6 & 0x1F | 0xC0);
                    this.out.write(c & 0x3F | 0x80);
                    continue block4;
                }
                case 55296: {
                    char c2;
                    if (i + 1 < len && (c & 0xFC00) == 55296 && ((c2 = s.charAt(i + 1)) & 0xFC00) == 56320) {
                        ++i;
                        int n = (c & 0x3FF) << 10 | c2 & 0x3FF;
                        this.out.write((n += 65536) >> 18 & 7 | 0xF0);
                        this.out.write(n >> 12 & 0x3F | 0x80);
                        this.out.write(n >> 6 & 0x3F | 0x80);
                        this.out.write(n & 0x3F | 0x80);
                        continue block4;
                    }
                }
                default: {
                    this.out.write(c >> 12 & 0xF | 0xE0);
                    this.out.write(c >> 6 & 0x3F | 0x80);
                    this.out.write(c & 0x3F | 0x80);
                }
            }
        }
    }
}

