/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime.test;

import de.statspez.pleditor.generator.interpreter.SimpleDataset;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.MaterialDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.SatzFilter;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import de.statspez.pleditor.generator.runtime.plausi.WertNichtTypgerechtException;
import de.statspez.pleditor.generator.runtime.refdat.AbstractReferenzDateiZugriff;
import de.statspez.pleditor.generator.runtime.test.FieldValues;
import de.statspez.pleditor.generator.runtime.test.MaterialValues;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TestMaterialAccess
extends AbstractReferenzDateiZugriff {
    private Map materialDatasetMap = new HashMap();

    public TestMaterialAccess(Map materialValuesMap) {
        for (String materialName : materialValuesMap.keySet()) {
            ArrayList<SimpleDataset> materialDatasets = new ArrayList<SimpleDataset>();
            MaterialValues materialValues = (MaterialValues)materialValuesMap.get(materialName);
            Iterator fieldValuesIter = materialValues.getFieldValues();
            while (fieldValuesIter.hasNext()) {
                FieldValues fieldValues = (FieldValues)fieldValuesIter.next();
                HashMap<String, String> values = new HashMap<String, String>();
                Iterator fields = fieldValues.getFields();
                while (fields.hasNext()) {
                    String field = (String)fields.next();
                    values.put(field, fieldValues.getValue(field));
                }
                SimpleDataset dataset = new SimpleDataset(values);
                dataset.setIndicesPrefix("[");
                dataset.setIndicesSuffix("]");
                materialDatasets.add(dataset);
            }
            this.materialDatasetMap.put(materialName, materialDatasets);
        }
    }

    @Override
    public boolean liefertDenZugriffAuf(MaterialDeskriptorInterface material) {
        return this.materialDatasetMap.containsKey(material.getMaterialName());
    }

    @Override
    public String[] getReferenzdateien() {
        return this.materialDatasetMap.keySet().toArray(new String[this.materialDatasetMap.size()]);
    }

    @Override
    public SatzInterface[] gibSaetzeGefiltert(FeldDeskriptorInterface[] felder, SatzFilter filter, MaterialDeskriptorInterface material) throws NoSuchFieldException {
        ArrayList<SatzInterface> result;
        ArrayList<SatzInterface> datasets = (ArrayList<SatzInterface>)this.materialDatasetMap.get(material.getMaterialName());
        if (filter == null || filter.getFilterBedingungen() == null || filter.getFilterBedingungen().length == 0) {
            result = datasets;
        } else {
            result = new ArrayList<SatzInterface>();
            int i = 0;
            while (i < datasets.size()) {
                SatzInterface satz = (SatzInterface)datasets.get(i);
                boolean aufnehmen = true;
                SatzFilter.FilterBedingung[] bedingungen = null;
                if (filter != null) {
                    bedingungen = filter.getFilterBedingungen();
                }
                if (bedingungen != null && bedingungen.length > 0) {
                    int j = 0;
                    while (j < bedingungen.length && aufnehmen) {
                        if (bedingungen[j].feld instanceof FeldDeskriptorImpl) {
                            FeldDeskriptorImpl refdatFeldDeskriptor = (FeldDeskriptorImpl)bedingungen[j].feld;
                            Value refdatWert = refdatFeldDeskriptor.getValueFrom(satz);
                            Value vergleichsWert = bedingungen[j].vergleichsWert;
                            switch (bedingungen[j].operator) {
                                case 1: {
                                    aufnehmen = refdatWert.eq(vergleichsWert);
                                    break;
                                }
                                case 3: {
                                    aufnehmen = refdatWert.gt(vergleichsWert);
                                    break;
                                }
                                case 6: {
                                    aufnehmen = refdatWert.ge(vergleichsWert);
                                    break;
                                }
                                case 2: {
                                    aufnehmen = refdatWert.lt(vergleichsWert);
                                    break;
                                }
                                case 5: {
                                    aufnehmen = refdatWert.le(vergleichsWert);
                                    break;
                                }
                                case 4: {
                                    aufnehmen = refdatWert.ne(vergleichsWert);
                                }
                            }
                        } else {
                            throw new NoSuchFieldException("Felddeskriptor f\u00fcr Referenzdateifeld \"" + bedingungen[j].feld.getFeldNameTB() + "\" nicht FeldDeskriptorImpl.");
                        }
                        ++j;
                    }
                }
                if (aufnehmen) {
                    result.add(satz);
                }
                ++i;
            }
        }
        if (result == null || result.size() == 0) {
            return new SatzInterface[0];
        }
        return result.toArray(new SatzInterface[result.size()]);
    }

    @Override
    public boolean wertKombinationGueltig(Value[] werte, FeldDeskriptorInterface[] felder, SatzFilter filter, MaterialDeskriptorInterface material) throws NoSuchFieldException {
        boolean wertKombinationGueltig = false;
        if (this.pr\u00fcfeParameterWertKombinationGueltig(werte, felder, filter, material)) {
            if (werte.length == 1 && (filter == null || filter.getFilterBedingungen() == null || filter.getFilterBedingungen().length == 0)) {
                List referenzDateiFeldwerte = this.getAlleFeldwerte(material, felder[0]);
                String wert = werte[0].asString();
                wertKombinationGueltig = referenzDateiFeldwerte != null && referenzDateiFeldwerte.contains(wert);
            } else {
                SatzInterface[] saetzeGefiltert = this.gibSaetzeGefiltert(felder, filter, material);
                int i = 0;
                while (i < saetzeGefiltert.length) {
                    boolean wertKombinationGefunden = true;
                    SatzInterface satz = saetzeGefiltert[i];
                    int j = 0;
                    while (j < felder.length) {
                        if (felder[j] instanceof FeldDeskriptorImpl) {
                            Value vergleichsWert;
                            FeldDeskriptorImpl refdatFeldDeskriptor = (FeldDeskriptorImpl)felder[j];
                            Value refdatWert = refdatFeldDeskriptor.getValueFrom(satz);
                            if (refdatWert.ne(vergleichsWert = werte[j])) {
                                wertKombinationGefunden = false;
                                break;
                            }
                        } else {
                            throw new NoSuchFieldException("Felddeskriptor f\u00fcr Feld \"" + felder[j].getFeldNameTB() + "\" nicht FeldDeskriptorImpl.");
                        }
                        ++j;
                    }
                    if (wertKombinationGefunden) {
                        wertKombinationGueltig = true;
                        break;
                    }
                    ++i;
                }
            }
        }
        return wertKombinationGueltig;
    }

    private List getAlleFeldwerte(MaterialDeskriptorInterface material, FeldDeskriptorInterface feld) throws NoSuchFieldException {
        List datasets = (List)this.materialDatasetMap.get(material.getMaterialName());
        ArrayList<String> result = new ArrayList<String>();
        if (datasets != null) {
            int i = 0;
            while (i < datasets.size()) {
                SatzInterface satz = (SatzInterface)datasets.get(i);
                try {
                    String wert = satz.getString(feld);
                    if (wert != null && !result.contains(wert)) {
                        result.add(wert);
                    }
                }
                catch (WertNichtTypgerechtException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        return result;
    }
}

