/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime;

import de.statspez.pleditor.generator.runtime.PlausiRuntimeIterator;
import de.statspez.pleditor.generator.runtime.Range;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.ValueConversionException;

public class IntervalRange
extends Range {
    public static final int INTERVAL_TYPE_MINUS_MINUS = 1;
    public static final int INTERVAL_TYPE_MINUS_PLUS = 2;
    public static final int INTERVAL_TYPE_PLUS_MINUS = 3;
    public static final int INTERVAL_TYPE_PLUS_PLUS = 4;
    private Value first = null;
    private Value last = null;
    private int type = 4;

    public IntervalRange(Value first, Value last) {
        this(first, last, 4);
    }

    public IntervalRange(Value first, Value last, int type) {
        this.first = first;
        this.last = last;
        this.type = type;
    }

    public Value first() {
        return this.first;
    }

    public Value last() {
        return this.last;
    }

    public int type() {
        return this.type;
    }

    @Override
    public PlausiRuntimeIterator iterator() {
        throw new UnsupportedOperationException("Ueber Intervalle kann nicht iteriert werden!");
    }

    @Override
    public double asDouble() throws ValueConversionException {
        throw new ValueConversionException("Der numerische Wert eines Intervalls kann nicht ermittelt werden!");
    }

    @Override
    public long asLong() throws ValueConversionException {
        throw new ValueConversionException("Der numerische Wert eines Intervalls kann nicht ermittelt werden!");
    }

    @Override
    public boolean asBoolean() throws ValueConversionException {
        throw new ValueConversionException("Der boolsche Wert eines Intervalls  kann nicht ermittelt werden!");
    }

    @Override
    public String asString() throws ValueConversionException {
        StringBuffer text = new StringBuffer("");
        text.append(this.first().asString());
        text.append("--");
        text.append(this.last().asString());
        return text.toString();
    }

    @Override
    protected boolean eqImpl(Value aValue) {
        return false;
    }

    @Override
    protected boolean ltImpl(Value aValue) {
        return false;
    }

    @Override
    protected boolean leImpl(Value aValue) {
        return false;
    }

    @Override
    protected boolean gtImpl(Value aValue) {
        return false;
    }

    @Override
    protected boolean geImpl(Value aValue) {
        return false;
    }

    @Override
    protected boolean neImpl(Value aValue) {
        return false;
    }

    @Override
    protected boolean containsImpl(Value aValue) {
        switch (this.type) {
            case 1: {
                return aValue.gt(this.first()) && aValue.lt(this.last());
            }
            case 2: {
                return aValue.gt(this.first()) && aValue.le(this.last());
            }
            case 3: {
                return aValue.ge(this.first()) && aValue.lt(this.last());
            }
        }
        return aValue.ge(this.first()) && aValue.le(this.last());
    }
}

