/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime;

import de.statspez.pleditor.generator.runtime.Classification;
import de.statspez.pleditor.generator.runtime.DefaultLogger;
import de.statspez.pleditor.generator.runtime.FeatureVariable;
import de.statspez.pleditor.generator.runtime.MerkmalCheckFeatureVariable;
import de.statspez.pleditor.generator.runtime.NilValue;
import de.statspez.pleditor.generator.runtime.PlausiDescriptor;
import de.statspez.pleditor.generator.runtime.PlausiDescriptorExt;
import de.statspez.pleditor.generator.runtime.PlausiDescriptorSerializer;
import de.statspez.pleditor.generator.runtime.PlausiRuntimeContext;
import de.statspez.pleditor.generator.runtime.ProgramSectionContext;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.Variable;
import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.Logger;
import de.statspez.pleditor.generator.runtime.plausi.PlausiFehler;
import de.statspez.pleditor.generator.runtime.plausi.PlausiInterface;
import de.statspez.pleditor.generator.runtime.plausi.PlausiKontext;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;

public abstract class BasePlausi
implements PlausiInterface {
    public static final double PLAUSI_MAYOR_VERSION = 3.5;
    public static final String ROOT_TB_FIELD_NAME = "__root_tb__";
    public static final String DESCRIPTOR_FILE_SUFFIX = "_Descriptor.data";
    public static final String ROOT_TB_DSB_NAME = "__root_tb__";
    private PrintStream stdout = null;
    private PrintStream stderr = null;
    private Logger logger = null;
    private PlausiDescriptor plausiDescriptor = null;
    private Hashtable classificationsByCode = new Hashtable();
    private Hashtable classificationsByValue = new Hashtable();
    private Hashtable mappings = new Hashtable();
    public static final String PLAUSI_MAPPINGS_KEY = "__plausi_mapping__";
    private Stack sectionContextStack = new Stack();
    private DefaultLogger defaultLogger = null;

    public BasePlausi() {
        PrintStream nirvanaPrintStream;
        this.stdout = nirvanaPrintStream = new PrintStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        });
        this.stderr = nirvanaPrintStream;
        this.defaultLogger = new DefaultLogger(nirvanaPrintStream);
        this.setLogger(this.defaultLogger);
        this.loadPlausiDescriptor();
    }

    public void setStdout(PrintStream aStream) {
        this.stdout = aStream;
    }

    public void setStderr(PrintStream aStream) {
        this.stderr = aStream;
        this.defaultLogger.setOutput(aStream);
    }

    @Override
    public void setLogger(Logger aLogger) {
        this.logger = aLogger;
        if (this.getPlausiMajorSystemVersion() < this.getPlausiSystemVersion() && this.logger != null) {
            this.logger.warning(String.valueOf(this.getClass().getName()) + " Generierungs-Version: " + this.getPlausiSystemVersion() + " groesser als " + " Laufzeit-Version: " + this.getPlausiMajorSystemVersion());
        }
    }

    public Logger logger() {
        return this.logger;
    }

    public abstract void init(PlausiRuntimeContext var1);

    public PlausiDescriptor plausiDescriptor() {
        assert (this.plausiDescriptor != null);
        return this.plausiDescriptor;
    }

    public ProgramSectionContext currentSectionContext() {
        ProgramSectionContext context = null;
        if (this.sectionContextStack.size() > 0) {
            context = (ProgramSectionContext)this.sectionContextStack.peek();
        }
        return context;
    }

    @Override
    public int gesamtPlausi(SatzInterface satz, PlausiKontext kontext) {
        if (kontext.getPlausiAblauf() == null) {
            kontext.setPlausiAblauf("");
        }
        PlausiDescriptor.FlowInfo ablaufInfo = null;
        if (kontext.getPlausiAblauf().trim().length() == 0) {
            ablaufInfo = this.plausiDescriptor().standardFlow();
            if (ablaufInfo == null) {
                throw new RuntimeException("Es wurde kein Ablauf vorgegeben und es konnte kein Standard-Ablauf ermittelt werden.");
            }
        } else {
            ablaufInfo = this.plausiDescriptor().flow(kontext.getPlausiAblauf());
            if (ablaufInfo == null) {
                throw new RuntimeException("Kein Ablauf mit dem Namen " + kontext.getPlausiAblauf() + " in der Plausibilisierung " + this.plausiDescriptor().name() + " gefunden.");
            }
        }
        PlausiRuntimeContext rtContext = new PlausiRuntimeContext(this);
        rtContext.setPlausiKontext(kontext);
        rtContext.setSatz(satz);
        this.doAblauf(ablaufInfo, rtContext, kontext.getInitWerte());
        return kontext.getPlausiErgebnis();
    }

    @Override
    public int feldPlausi(String feldname, SatzInterface satz, PlausiKontext kontext) {
        this.assertNewPlausiVersion();
        FeatureVariable variable = (FeatureVariable)this.getFeldDeskriptor(feldname);
        String checkMethodName = ((PlausiDescriptorExt)this.plausiDescriptor()).getCheckMethod(feldname);
        if (checkMethodName == null || checkMethodName.length() == 0) {
            throw new RuntimeException("Keine Feldplausi fuer das Feld " + feldname + " in der Plausibilisierung " + this.plausiDescriptor().name() + " gefunden.");
        }
        try {
            Method checkMethod = this.getClass().getMethod(checkMethodName, PlausiRuntimeContext.class, Variable.class);
            Variable variableToCheck = variable;
            PlausiRuntimeContext rtContext = new PlausiRuntimeContext(this);
            if (this.getPlausiSystemVersion() < 3.0) {
                rtContext.setCurrentField(variable);
                variableToCheck = new MerkmalCheckFeatureVariable(variable);
            }
            rtContext.setPlausiKontext(kontext);
            rtContext.setSatz(satz);
            checkMethod.invoke((Object)this, rtContext, variableToCheck);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return kontext.getPlausiErgebnis();
    }

    @Override
    public int feldPlausiDsb(String feldnameDsb, SatzInterface satz, PlausiKontext kontext) {
        return this.feldPlausi(this.convertFieldName(feldnameDsb), satz, kontext);
    }

    @Override
    public String getPlausiName() {
        return this.plausiDescriptor().name();
    }

    @Override
    public int getPlausiVersion() {
        return this.plausiDescriptor().version();
    }

    @Override
    public String getPlausiVersionString() {
        return "00000000_000000";
    }

    @Override
    public String[] getPlausiAblaeufe() {
        Vector<String> v = new Vector<String>();
        Iterator it = this.plausiDescriptor().flows();
        while (it.hasNext()) {
            v.add(((PlausiDescriptor.FlowInfo)it.next()).name);
        }
        return v.toArray(new String[v.size()]);
    }

    @Override
    public abstract String[] getPlausiFehlerIds(String var1);

    @Override
    public String[] getPlausiFelder() {
        return new String[0];
    }

    @Override
    public String getSpezifikationsCode(String fehlerId) {
        if (fehlerId.lastIndexOf(35) == -1) {
            throw new IllegalArgumentException("Ungueltige Fehler-Id");
        }
        String schluessel = fehlerId.substring(fehlerId.lastIndexOf(35) + 1);
        String code = this.plausiDescriptor().getCode(schluessel);
        if (code == null) {
            throw new IllegalArgumentException("Der Pruefschluessel " + schluessel + " wurde in dieser Plausibilisierung " + "nicht gefunden.");
        }
        return code;
    }

    @Override
    public PlausiFehler getPlausiFehlerById(String fehlerId) {
        assert (fehlerId != null) : "Fehler-Id ist null";
        if (fehlerId.lastIndexOf(35) == -1) {
            throw new IllegalArgumentException("Ungueltige Fehler-Id");
        }
        String fehlerschluessel = fehlerId.substring(fehlerId.lastIndexOf(35) + 1);
        PlausiFehler fehler = this.createPlausiFehler(fehlerschluessel);
        assert (fehler != null) : "Fehler zu Fehlerschluessel nicht erzeugt";
        if (!fehlerId.startsWith("#")) {
            String feldId = fehlerId.substring(0, fehlerId.lastIndexOf(35));
            FeatureVariable feldDeskriptor = this.plausiDescriptor().getFeldDeskriptor(feldId);
            if (feldDeskriptor != null && fehler.getReferenzFeldIndizes() != null && fehler.getReferenzFeldIndizes().length > 0) {
                feldDeskriptor.setIndizes(fehler.getReferenzFeldIndizes());
            }
            fehler.setReferenzFeld(feldDeskriptor);
        }
        return fehler;
    }

    @Override
    public FeldDeskriptorInterface getFeldDeskriptor(String feldname) {
        this.assertNewPlausiVersion();
        FeatureVariable variable = this.plausiDescriptor().getFeldDeskriptor(feldname);
        if (variable == null) {
            throw new RuntimeException("Kein Feld mit dem Namen " + feldname + " in der Plausibilisierung " + this.plausiDescriptor().name() + " gefunden.");
        }
        return variable;
    }

    @Override
    public FeldDeskriptorInterface getFeldDeskriptorDsb(String feldnameDsb) {
        return this.getFeldDeskriptor(this.convertFieldName(feldnameDsb));
    }

    public double getPlausiSystemVersion() {
        return 1.0;
    }

    public final double getPlausiMajorSystemVersion() {
        return 3.5;
    }

    public Object invokeExternalFunction(PlausiRuntimeContext context, String funktionsName, Object[] parameter) throws Exception {
        Object erg = null;
        Method extFunc = null;
        if (context.getPlausiKontext().getExterneFunktionenFactory() != null) {
            extFunc = context.getPlausiKontext().getExterneFunktionenFactory().getExterneFunktion(funktionsName);
            if (extFunc == null) {
                throw new IllegalArgumentException("Fehler beim Aufruf der Externen Funktion '" + funktionsName + "': Methode in externer Funktionen-Factory nicht vorhanden.");
            }
        } else {
            throw new IllegalArgumentException("Fehler beim Aufruf der Externen Funktion '" + funktionsName + "': Keine externe Funktionen-Factory vorgegeben.");
        }
        erg = extFunc.invoke((Object)context.getPlausiKontext().getExterneFunktionenFactory(), parameter);
        return erg;
    }

    protected void startNewPruefSection(String section) {
        ProgramSectionContext context = new ProgramSectionContext(section, this.currentSectionContext(), true);
        this.sectionContextStack.push(context);
        this.logger().trace("--> " + context.section());
    }

    protected void startNewSection(String section) {
        ProgramSectionContext context = new ProgramSectionContext(section, this.currentSectionContext());
        this.sectionContextStack.push(context);
        this.logger().trace("--> " + context.section());
    }

    protected void leaveCurrentSection() {
        assert (this.sectionContextStack.size() > 0) : "keine Abschnitts-Kontexte mehr";
        ProgramSectionContext context = this.currentSectionContext();
        if (context != null) {
            this.logger().trace("<-- " + context.section());
        }
        this.sectionContextStack.pop();
    }

    protected void writeSectionInfosToError(PlausiFehler error) {
        ProgramSectionContext context = this.currentSectionContext();
        Vector<String> abschnitte = new Vector<String>();
        ProgramSectionContext currentContext = context;
        while (currentContext != null) {
            String abschnittInfo = currentContext.section();
            if (abschnittInfo == null) {
                abschnittInfo = "Unbekannter Plausi-Abschnitt";
            }
            abschnitte.add(abschnittInfo);
            currentContext = currentContext.parentContext();
        }
        error.setAbschnittInfos(abschnitte.toArray(new String[0]));
        error.setFelder(context.felderSortiertNachZugriff());
    }

    protected FeldDeskriptorInterface lastAccessedField() {
        ProgramSectionContext currentSection = this.currentSectionContext();
        FeldDeskriptorInterface field = null;
        while (currentSection != null) {
            field = currentSection.lastAccessedField();
            if (field != null) break;
            currentSection = currentSection.parentContext();
        }
        return field;
    }

    public void setPlausiMappings(Hashtable mappings) {
        this.mappings.put(PLAUSI_MAPPINGS_KEY, mappings);
    }

    public void setMappingsForMaterial(String material, Hashtable mappings) {
        this.mappings.put(material, mappings);
    }

    protected Hashtable plausiMappings() {
        return (Hashtable)this.mappings.get(PLAUSI_MAPPINGS_KEY);
    }

    protected Hashtable mappingsForMaterial(String material) {
        return (Hashtable)this.mappings.get(material);
    }

    public void registerClassification(Classification aClassification, String regCode, String regValue) {
        this.classificationsByCode.put(regCode, aClassification);
        this.classificationsByValue.put(regValue, aClassification);
    }

    public void registerClassification(Classification aClassification, String regCode) {
        this.classificationsByCode.put(regCode, aClassification);
    }

    public Value classificationByCode(String code) {
        Value theClassification = (Value)this.classificationsByCode.get(code);
        if (theClassification == null) {
            theClassification = NilValue.instance();
        }
        return theClassification;
    }

    public Value classificationByValue(String value) {
        Value theClassification = (Value)this.classificationsByValue.get(value);
        if (theClassification == null) {
            theClassification = NilValue.instance();
        }
        return theClassification;
    }

    protected abstract PlausiFehler createPlausiFehler(String var1);

    protected abstract void doAblauf(PlausiDescriptor.FlowInfo var1, PlausiRuntimeContext var2, Object[] var3);

    public void print(String aString) {
        this.logger.trace(aString);
    }

    public void println(String aString) {
        this.logger.trace(String.valueOf(aString) + System.getProperty("line.separator"));
    }

    public void printErr(String aString) {
        this.logger.error(aString);
    }

    public void printlnErr(String aString) {
        this.logger.error(String.valueOf(aString) + System.getProperty("line.separator"));
    }

    private void assertNewPlausiVersion() {
        if (this.getPlausiSystemVersion() < 2.1) {
            throw new RuntimeException("Die Version der generierten Plausi-Klasse ist alt und unterst\u00fctzt daher nicht alle Funktionalit\u00e4ten.");
        }
    }

    protected void loadPlausiDescriptor() {
        try {
            String plausiClassName = this.getClass().getName();
            String plausiDescriptorFile = String.valueOf(plausiClassName.substring(plausiClassName.lastIndexOf(46) + 1)) + DESCRIPTOR_FILE_SUFFIX;
            InputStream plausiDescriptorIn = this.getClass().getResourceAsStream(plausiDescriptorFile);
            if (plausiDescriptorIn == null) {
                this.printErr("ACHTUNG: Der Deskriptor mit Laufzeit-Informationen zu dieser Plausibilisierung wurde nicht gefunden, es wird ein leerer Deskriptor verwendet!!!!");
                this.plausiDescriptor = new PlausiDescriptor();
                return;
            }
            if (this.getPlausiSystemVersion() > 2.0) {
                PlausiDescriptorSerializer deserializer = new PlausiDescriptorSerializer();
                this.plausiDescriptor = deserializer.deserialize(plausiDescriptorIn);
            } else {
                ObjectInputStream deserializer = new ObjectInputStream(plausiDescriptorIn);
                this.plausiDescriptor = (PlausiDescriptor)deserializer.readObject();
            }
            this.print("Der Deskriptor wurde erfolgreich geladen");
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new RuntimeException("Der Deskriptor mit Laufzeit-Informationen zu dieser Plausibiliserung konnte nicht geladen werden!", exc);
        }
    }

    private String convertFieldName(String fieldNameDsb) {
        if (this.plausiMappings() == null) {
            throw new RuntimeException("Es wurde kein DSB-Mapping f\u00fcr die Plausibilisierung " + this.plausiDescriptor().name() + " definiert.");
        }
        String fieldNameDsbWithoutIndices = fieldNameDsb.replaceAll("\\[[^\\]]*\\]", "");
        String fieldNameWithoutIndices = null;
        Enumeration keys = this.plausiMappings().keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)this.plausiMappings().get(key);
            if (!value.equals(fieldNameDsbWithoutIndices)) continue;
            fieldNameWithoutIndices = key;
        }
        if (fieldNameWithoutIndices == null) {
            throw new RuntimeException("Kein Feld mit dem DSB-Namen " + fieldNameDsb + " in der Plausibilisierung " + this.plausiDescriptor().name() + " gefunden.");
        }
        StringBuffer fieldName = new StringBuffer();
        String[] fieldHierarchyDsb = fieldNameDsb.split("\\.");
        String[] fieldHierarchy = fieldNameWithoutIndices.split("\\.");
        int i = fieldHierarchyDsb.length - 1;
        while (i >= 0) {
            fieldName.append(fieldHierarchy[i]);
            if (fieldHierarchyDsb[i].indexOf(91) > 0) {
                fieldName.append(fieldHierarchyDsb[i].substring(fieldHierarchyDsb[i].indexOf(91)));
            }
            --i;
        }
        return fieldName.toString();
    }
}

