/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.interpreter;

import de.statspez.pleditor.generator.interpreter.MaterialNameResolver;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaTBMaterialReferenz;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import java.util.HashMap;

public class PlausiMaterialNameResolver
implements MaterialNameResolver {
    private final HashMap materialNamen;

    public PlausiMaterialNameResolver(MetaPlausibilisierung plausi) {
        this.materialNamen = this.initHashMap(plausi);
    }

    @Override
    public String getMaterialName(String materialReferenzName, FeldDeskriptorImpl parent) {
        if (materialReferenzName == null || materialReferenzName.length() == 0) {
            throw new IllegalArgumentException("Name der Material-Refrenz erforderlich");
        }
        if (!this.materialNamen.containsKey(materialReferenzName)) {
            throw new IllegalArgumentException("Material-Refrenz " + materialReferenzName + " unbekannt");
        }
        String name = (String)this.materialNamen.get(materialReferenzName);
        return name;
    }

    private HashMap initHashMap(MetaPlausibilisierung plausi) {
        final HashMap materialNamen = new HashMap();
        AbstractElementVisitor myElementVisitor = new AbstractElementVisitor(){

            @Override
            public void visitPlausibilisierung(MetaPlausibilisierung anObject) {
                this.visitElements(anObject.getThemenbereiche());
            }

            @Override
            public void visitTBMaterialReferenz(MetaTBMaterialReferenz anObject) {
                String addedMaterialName;
                String referenzName = anObject.getName();
                String materialName = anObject.getMaterialbeschreibung().getName();
                if (materialNamen.containsKey(referenzName) && !(addedMaterialName = (String)materialNamen.get(referenzName)).equals(materialName)) {
                    throw new IllegalArgumentException("Name der Materialreferenz '" + referenzName + "' nicht eindeutig. Wird f\u00fcr Referenz auf die Materialen '" + addedMaterialName + "' und '" + materialName + "' verwendet");
                }
                materialNamen.put(referenzName, materialName);
            }

            @Override
            public void visitThemenbereich(MetaThemenbereich anObject) {
                this.visitElements(anObject.getMaterialreferenzen());
            }
        };
        plausi.accept(myElementVisitor);
        return materialNamen;
    }
}

