/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java;

import de.statspez.pleditor.generator.codegen.java.CodegenContext;
import de.statspez.pleditor.generator.codegen.java.PlausiElementCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.Settings;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.support.CodegenUtil;
import de.statspez.pleditor.generator.meta.MetaCustomInitwert;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.MetaCustomVariable;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLInitwert;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaPLVariable;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaTBMaterialReferenz;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.util.Iterator;

public class ThemenbereichConstructorGenerator
extends PlausiElementCodeGenerator {
    private static final String PLAUSI_VAR = "plausi";
    private static final String FIELD_DESCRIPTOR_VAR = "feldDeskriptor";
    private CodegenContext context;
    private MetaThemenbereich topic;
    private boolean withinSegment;

    public synchronized void generate(CodegenContext aContext, MetaThemenbereich aTopic, String topicClassName, boolean superIsNotBaseClass, boolean isWithinSegment, Iterator fields) {
        this.context = aContext;
        this.topic = aTopic;
        this.withinSegment = isWithinSegment;
        if (this.withinSegment) {
            this.defineMethod("public", "", topicClassName, String.valueOf(aContext.getPlausiClassName()) + " " + PLAUSI_VAR + ", " + "FeldDeskriptorInterface" + " parent, " + "FeldDeskriptor" + " " + FIELD_DESCRIPTOR_VAR + ", " + "int[] indices");
        } else {
            this.defineMethod("public", "", topicClassName, "FeldDeskriptorInterface parent, FeldDeskriptor feldDeskriptor, int[] indices");
        }
        this.indentNewLine();
        this.out.print("super(");
        if (superIsNotBaseClass) {
            if (this.withinSegment) {
                this.out.print(PLAUSI_VAR);
            } else {
                this.out.print(this.context.getPlausiClassName());
                this.out.print(".this");
            }
            this.out.print(", ");
        }
        this.out.print("parent, ");
        this.out.print(FIELD_DESCRIPTOR_VAR);
        this.out.print(", indices);");
        if (fields.hasNext()) {
            this.indentNewLine();
        }
        this.visitElements(fields);
        this.endMethodDefinition();
    }

    @Override
    public void visitTBFeld(MetaTBFeld anObject) {
        MetaCustomTBFeld aFeld = (MetaCustomTBFeld)anObject;
        boolean isRootTopic = ((MetaCustomThemenbereich)this.topic).countReferenzierendeFelder() == 0;
        this.indentNewLine();
        this.out.print("this.");
        this.out.print(StringHelper.getEscapedName(aFeld.getName()));
        this.out.print(" = ");
        if (aFeld.getKlasse() instanceof MetaMerkmal) {
            this.out.print("new ");
            MetaMerkmal aMerkmal = (MetaMerkmal)aFeld.getKlasse();
            int rtType = Settings.rtTypeForILType(aMerkmal.getTyp());
            if (rtType == -1) {
                this.error(aFeld, "Ungueltiger Typ fuer das Merkmal des Felds " + aFeld.getName() + ".");
            }
            if (aFeld.getListe()) {
                this.out.print("FeatureArray(");
                this.createArrayDimensions(aFeld.dimensions());
                this.out.print(", new ");
            }
            this.out.print("FeatureVariable(");
            if (isRootTopic) {
                this.out.print("null");
            } else {
                this.out.print("this");
            }
            this.out.print(", new FeldDeskriptorExt(");
            this.out.print(FIELD_DESCRIPTOR_VAR);
            this.out.print(".");
            this.out.print("getMappings");
            this.out.print("(), \"");
            this.out.print(aFeld.getName());
            this.out.print("\", ");
            if (isRootTopic) {
                this.out.print("null");
            } else {
                this.out.print(FIELD_DESCRIPTOR_VAR);
            }
            this.out.print(", ");
            this.out.print(Integer.toString(rtType));
            if (aMerkmal.getMaske() != null && aMerkmal.getMaske().length() > 0) {
                this.out.print(", \"");
                this.out.print(StringHelper.getEscapedStringValue(aMerkmal.getMaske()));
                this.out.print("\"");
            }
            this.out.print(", ");
            if (aFeld.getListe()) {
                this.createArrayDimensions(aFeld.dimensions());
            } else {
                this.out.print("null");
            }
            this.out.print(", \"");
            this.out.print(StringHelper.getEscapedStringValue(CodegenUtil.getDisplayName(this.context.getTextResource(), aFeld)));
            this.out.print("\"), null)");
            if (aFeld.getListe()) {
                this.out.print(")");
            }
        } else {
            MetaThemenbereich feldKlasse = (MetaThemenbereich)aFeld.getKlasse();
            if (aFeld.getListe()) {
                this.out.print("new TopicArray(");
                this.createArrayDimensions(aFeld.dimensions());
                this.out.print(", ");
            }
            if (this.withinSegment) {
                this.out.print(PLAUSI_VAR);
                this.out.print(".");
            }
            this.out.print("new ");
            this.out.print(this.getTbClass(feldKlasse));
            this.out.print("(");
            if (isRootTopic) {
                this.out.print("null");
            } else {
                this.out.print("this");
            }
            this.out.print(", new FeldDeskriptorExt(");
            this.out.print(FIELD_DESCRIPTOR_VAR);
            this.out.print(".");
            this.out.print("getMappings");
            this.out.print("(), ");
            this.out.print("\"" + aFeld.getName() + "\", ");
            if (isRootTopic) {
                this.out.print("null");
            } else {
                this.out.print(FIELD_DESCRIPTOR_VAR);
            }
            this.out.print(", RuntimeSettings.RT_TYPE_CUSTOM");
            this.out.print(", ");
            if (aFeld.getListe()) {
                this.createArrayDimensions(aFeld.dimensions());
            } else {
                this.out.print("null");
            }
            this.out.print(", \"");
            this.out.print(StringHelper.getEscapedStringValue(CodegenUtil.getDisplayName(this.context.getTextResource(), aFeld)));
            this.out.print("\"), null)");
            if (aFeld.getListe()) {
                this.out.print(")");
            }
        }
        this.out.print(";");
    }

    @Override
    public void visitTBMaterialReferenz(MetaTBMaterialReferenz materialReferenz) {
        MetaPLMaterial material = materialReferenz.getMaterialbeschreibung();
        this.indentNewLine();
        this.out.print("this.");
        this.out.print("__material_ref_");
        this.out.print(StringHelper.getEscapedName(materialReferenz.getName()));
        this.out.print(" = ");
        this.out.print("__material_");
        this.out.print(StringHelper.getEscapedName(material.getName()));
        this.out.print(";");
    }

    @Override
    public void visitPLVariable(MetaPLVariable variable) {
        this.indentNewLine();
        this.out.print("this.");
        this.out.print(StringHelper.getEscapedName(variable.getName()));
        this.out.print(" = new ");
        if (variable.getListe()) {
            this.out.print("GlobalArray(");
            this.createArrayDimensions(((MetaCustomVariable)variable).dimensions());
        } else {
            this.out.print("GlobalVariable(");
        }
        this.out.print(");");
    }

    @Override
    public void visitPLInitwert(MetaPLInitwert initwert) {
        this.indentNewLine();
        this.out.print("this.");
        this.out.print(StringHelper.getEscapedName(initwert.getName()));
        this.out.print(" = new ");
        if (initwert.getListe()) {
            this.out.print("GlobalArray(");
            this.createArrayDimensions(((MetaCustomInitwert)initwert).dimensions());
        } else {
            this.out.print("GlobalVariable(");
        }
        this.out.print(");");
    }
}

