/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java;

import de.statspez.pleditor.generator.codegen.java.CodegenContext;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.support.AbstractCodeGenerator;
import de.statspez.pleditor.generator.codegen.support.LiteralManager;
import de.statspez.pleditor.generator.meta.MetaNumber;
import de.statspez.pleditor.generator.meta.MetaString;
import de.statspez.pleditor.generator.meta.MetaValue;
import java.io.Writer;

public class LiteralCodeGenerator
extends AbstractCodeGenerator {
    private LiteralManager myLiteralManager = null;

    public synchronized void generate(CodegenContext context, LiteralManager lManager) {
        this.myLiteralManager = lManager;
        MetaValue[] values = lManager.values();
        int i = 0;
        while (i < values.length) {
            values[i].accept(this);
            ++i;
        }
        this.indentNewLine();
        i = 0;
        while (i < lManager.numOfSegments()) {
            values = lManager.valuesForSegment(i);
            String className = lManager.prefixForSegment(i);
            className = className.substring(0, className.length() - 1);
            Writer writer = context.createWriter(String.valueOf(className) + ".java");
            LiteralCodeGenerator segmentCodeGenerator = new LiteralCodeGenerator();
            segmentCodeGenerator.setOutput(writer);
            segmentCodeGenerator.setErrorContext(context.getMessageContext());
            segmentCodeGenerator.myLiteralManager = lManager;
            segmentCodeGenerator.print("package ");
            segmentCodeGenerator.print(context.getPlausiPackage());
            segmentCodeGenerator.print(";");
            segmentCodeGenerator.indentNewLine();
            segmentCodeGenerator.indentNewLine();
            segmentCodeGenerator.print("import ");
            segmentCodeGenerator.print("de.statspez.pleditor.generator.runtime.");
            segmentCodeGenerator.print("*;");
            segmentCodeGenerator.indentNewLine();
            segmentCodeGenerator.indentNewLine();
            segmentCodeGenerator.print("public class ");
            segmentCodeGenerator.print(className);
            segmentCodeGenerator.indentNewLine();
            segmentCodeGenerator.print("{");
            segmentCodeGenerator.increaseIndentLevel();
            int j = 0;
            while (j < values.length) {
                values[j].accept(segmentCodeGenerator);
                ++j;
            }
            segmentCodeGenerator.decreaseIndentLevel();
            segmentCodeGenerator.indentNewLine();
            segmentCodeGenerator.print("}");
            segmentCodeGenerator.out.flush();
            context.destroyWriter(String.valueOf(className) + ".java", writer);
            ++i;
        }
        this.checkForErrors();
    }

    private String literalFor(MetaValue value) {
        String literal;
        int indexOfDot;
        if (!this.myLiteralManager.literalDefinedFor(value)) {
            this.error(value, "kein Literal fuer diesen Wert definiert");
        }
        if ((indexOfDot = (literal = this.myLiteralManager.literalFor(value)).indexOf(46)) >= 0) {
            literal = literal.substring(indexOfDot + 1);
        }
        return literal;
    }

    @Override
    public void visitNumber(MetaNumber aNumber) {
        this.indentNewLine();
        this.out.print("public static final NumberValue ");
        this.out.print(this.literalFor(aNumber));
        this.out.print(" = new NumberValue(");
        this.out.print(aNumber.value().toString());
        this.out.print(");");
    }

    @Override
    public void visitString(MetaString aString) {
        this.indentNewLine();
        this.out.print("public static final StringValue ");
        this.out.print(this.literalFor(aString));
        this.out.print(" = new StringValue(\"");
        this.out.print(StringHelper.getEscapedStringValue(aString.value()));
        this.out.print("\");");
    }
}

