/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java;

import de.statspez.pleditor.generator.codegen.java.CodegenFacade;
import de.statspez.pleditor.generator.codegen.support.CodegenException;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.IntermediateLanguageParser;
import de.statspez.pleditor.generator.parser.ResolveException;
import de.statspez.pleditor.generator.parser.speclanguage.SpecLangParseException;
import java.io.FileReader;

public class JavaGenerator {
    public static void main(String[] args) throws Exception {
        int errorCode = 0;
        if (args.length < 2) {
            System.err.println("usage: JavaGenerator: xml-filename output-dir");
            errorCode = 1;
        }
        try {
            String quellDateiName = args[0];
            String ausgabeDirName = args[1];
            IntermediateLanguageParser parser = new IntermediateLanguageParser();
            FileReader fin = new FileReader(quellDateiName);
            MetaPlausibilisierung plausi = (MetaPlausibilisierung)parser.parse(fin);
            fin.close();
            CodegenFacade codeGen = new CodegenFacade();
            codeGen.generate(plausi, ausgabeDirName);
        }
        catch (SpecLangParseException exc) {
            System.err.println("Fehler beim Parsen:");
            System.err.println(exc.getMessage());
            System.err.println(exc.messagesAsText());
            errorCode = 2;
        }
        catch (ResolveException exc) {
            System.err.println("Fehlerhafte Referenzen:");
            System.err.println(exc.getMessage());
            errorCode = 3;
        }
        catch (CodegenException exc) {
            System.err.println("Fehler bei der Pruefung:");
            String warnings = exc.warningsAsText();
            String errors = exc.errorsAsText();
            System.err.println(exc.getMessage());
            System.err.println("Fehler:");
            System.err.println(errors);
            System.err.println("Warnungen:");
            System.err.println(warnings);
            errorCode = 4;
        }
        catch (ILParseException exc) {
            System.err.println("Fehlerhafter Aufbau der Elemente:");
            System.err.println(exc.getMessage());
            errorCode = 5;
        }
        catch (Exception exc) {
            System.err.println("Fehler:");
            exc.printStackTrace();
            errorCode = 6;
        }
        System.exit(errorCode);
    }
}

