/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.cpp;

import de.statspez.pleditor.generator.codegen.cpp.CppProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.support.CodegenException;
import de.statspez.pleditor.generator.codegen.support.HelperVisitor;
import de.statspez.pleditor.generator.codegen.support.SymbolDescriptor;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaLiteralAccess;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;

class CppTranslateToMethodStrategy
extends HelperVisitor {
    private SymbolDescriptor lastFunctionDescriptor = null;
    private String forcedMethodName = null;

    public CppTranslateToMethodStrategy(CppProgramCodeGenerator generator) {
        super(generator);
    }

    public void setForcedMethodName(String forcedMethodName) {
        this.forcedMethodName = forcedMethodName;
    }

    @Override
    public void visitFieldAccess(MetaFieldAccess anAccess) {
        anAccess.accessedField().accept(this);
    }

    @Override
    public void visitArrayAccess(MetaArrayAccess anAccess) {
        this.error(anAccess, "Listen koennen keine Funktionen identifizieren");
    }

    @Override
    public void visitIdentifier(MetaIdentifier id) {
        this.checkIfDefinedAndFunction(id);
        if (this.forcedMethodName != null && this.forcedMethodName.length() > 0) {
            this.out().print(this.forcedMethodName);
        } else {
            this.out().print("prg_");
            this.out().print(StringHelper.getEscapedName(id.value()));
        }
    }

    @Override
    public void visitLiteralAccess(MetaLiteralAccess anAccess) {
        this.error(anAccess, "Literale koennen keine Funktionen identifizieren");
    }

    public void visitStructureAcccess(MetaStructureAccess anAccess) {
        throw new CodegenException("Fataler Fehler: Zugriffe auf Strukturen werden an dieser Stelle nicht unterstuetzt!");
    }

    public SymbolDescriptor lastFunctionDescriptor() {
        return this.lastFunctionDescriptor;
    }

    private void checkIfDefinedAndFunction(MetaIdentifier id) {
        if (!this.scope().isDefined(id, this.namespace())) {
            this.error(id, String.valueOf(id.value()) + " ist nicht in diesem Gueltigkeitsbereich definiert " + "(Scope:" + this.namespace() + ")");
            return;
        }
        this.lastFunctionDescriptor = this.scope().symbolDescriptor(id, this.namespace());
        if (!(this.lastFunctionDescriptor.isFunction() || this.lastFunctionDescriptor.isPruefung() || this.lastFunctionDescriptor.isAblauf() || this.lastFunctionDescriptor.isEigenschaft())) {
            this.error(id, String.valueOf(id.value()) + " ist keine Funktion");
            return;
        }
    }
}

