/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.userdefined;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Sequence;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

public class SequenceQuoterFunction
implements Function {
    private static final long serialVersionUID = -8692592342324471253L;

    @Override
    public String getCanonicalName() {
        return "SEQUENCEQUOTER";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        Object indexValue;
        Type indexType;
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 1 || parameterCount > 3) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Sequence sequence = context.getTypeRegistry().convertToSequence(parameters.getType(0), parameters.getValue(0));
        if (sequence == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_NA_VALUE);
        }
        String quote = "\"";
        String separator = ",";
        if (parameterCount > 1) {
            indexType = parameters.getType(1);
            indexValue = parameters.getValue(1);
            separator = context.getTypeRegistry().convertToText(indexType, indexValue);
        }
        if (parameterCount > 2) {
            indexType = parameters.getType(2);
            indexValue = parameters.getValue(2);
            quote = context.getTypeRegistry().convertToText(indexType, indexValue);
        }
        StringBuilder b = new StringBuilder();
        while (sequence.hasNext()) {
            Object o = sequence.next();
            if (o != null) {
                b.append(quote).append(String.valueOf(o)).append(quote);
            }
            if (!sequence.hasNext()) continue;
            b.append(separator);
        }
        return new TypeValuePair(TextType.TYPE, b.toString());
    }
}

