/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.libformula.editor;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.di.core.Const;
import org.pentaho.libformula.editor.FormulaMessage;
import org.pentaho.reporting.libraries.formula.lvalues.ContextLookup;
import org.pentaho.reporting.libraries.formula.lvalues.FormulaFunction;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.ParsePosition;
import org.pentaho.reporting.libraries.formula.lvalues.StaticValue;
import org.pentaho.reporting.libraries.formula.lvalues.Term;
import org.pentaho.reporting.libraries.formula.parser.FormulaParser;
import org.pentaho.reporting.libraries.formula.parser.ParseException;
import org.pentaho.reporting.libraries.formula.parser.Token;
import org.pentaho.reporting.libraries.formula.typing.coretypes.DateTimeType;
import org.pentaho.reporting.libraries.formula.typing.coretypes.LogicalType;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

public class FormulaEvaluator {
    private String[] keyWords;
    private String[] inputFields;
    private FormulaParser formulaParser;

    public FormulaEvaluator(String[] keyWords, String[] inputFields) {
        this.keyWords = keyWords;
        this.inputFields = inputFields;
        this.formulaParser = new FormulaParser();
    }

    public Map<String, FormulaMessage> evaluateFormula(String expression) {
        HashMap<String, FormulaMessage> messages = new HashMap<String, FormulaMessage>();
        if (expression == null || expression.trim().equals("")) {
            return messages;
        }
        try {
            LValue lValue = this.formulaParser.parse(expression.trim());
            if (lValue != null) {
                try {
                    this.verifyLValue(lValue, messages);
                }
                catch (Exception e) {
                    FormulaMessage message = new FormulaMessage(1, "Parse Exception", "Parsing error in formula : " + e.getMessage());
                    messages.put(message.toString(), message);
                }
            }
        }
        catch (ParseException parseException) {
            String problem;
            Token token = parseException.currentToken;
            boolean handled = false;
            if (token != null && (problem = token.toString()) != null) {
                FormulaMessage message = new FormulaMessage(1, new ParsePosition(token.beginLine, token.beginColumn, token.endLine, token.endColumn), "Parse Exception", "Parse exception near '" + problem + "' on line " + token.beginLine + ", column " + token.beginColumn + "\n\n" + parseException.getMessage());
                messages.put(message.toString(), message);
                handled = true;
            }
            if (!handled) {
                FormulaMessage message;
                if (parseException.getMessage() != null) {
                    message = new FormulaMessage(1, "Parse Exception", "Parsing error in formula : " + parseException.getMessage());
                    messages.put(message.toString(), message);
                } else {
                    message = new FormulaMessage(1, "Parse Exception", "Parsing error in formula : " + parseException.toString());
                    messages.put(message.toString(), message);
                }
            }
        }
        catch (Throwable e) {
            if (e.getMessage() != null) {
                FormulaMessage message = new FormulaMessage(1, "Parse Exception", "Parsing error in formula : " + e.getMessage());
                messages.put(message.toString(), message);
            }
            FormulaMessage message = new FormulaMessage(1, "Parse Exception", "Parsing error in formula : " + e.toString());
            messages.put(message.toString(), message);
        }
        return messages;
    }

    public void verifyLValue(LValue lvalue, Map<String, FormulaMessage> messages) {
        if (lvalue instanceof FormulaFunction) {
            FormulaMessage formulaMessage;
            FormulaFunction formulaFunction = (FormulaFunction)lvalue;
            String functionName = formulaFunction.getFunctionName();
            if (Const.indexOfString((String)functionName, (String[])this.keyWords) < 0) {
                formulaMessage = new FormulaMessage(1, formulaFunction.getParsePosition(), functionName, "Unknown function");
                messages.put(formulaMessage.toString(), formulaMessage);
            } else {
                formulaMessage = new FormulaMessage(4, formulaFunction.getParsePosition(), functionName, "Function");
                messages.put(formulaMessage.toString(), formulaMessage);
            }
            LValue[] arguments = formulaFunction.getChildValues();
            if (arguments != null) {
                for (LValue argument : arguments) {
                    this.verifyLValue(argument, messages);
                }
            }
        } else if (lvalue instanceof Term) {
            Term term = (Term)lvalue;
            LValue head = term.getHeadValue();
            this.verifyLValue(head, messages);
            LValue[] operands = term.getOperands();
            if (operands != null) {
                for (LValue operand : operands) {
                    this.verifyLValue(operand, messages);
                }
            }
        } else if (lvalue instanceof StaticValue) {
            StaticValue staticValue = (StaticValue)lvalue;
            if (staticValue.getValueType() instanceof NumberType) {
                FormulaMessage formulaMessage = new FormulaMessage(6, staticValue.getParsePosition(), staticValue.toString(), "Static number");
                messages.put(formulaMessage.toString(), formulaMessage);
            } else if (staticValue.getValueType() instanceof TextType) {
                FormulaMessage formulaMessage = new FormulaMessage(7, staticValue.getParsePosition(), staticValue.toString(), "Static string");
                messages.put(formulaMessage.toString(), formulaMessage);
            } else if (staticValue.getValueType() instanceof DateTimeType) {
                FormulaMessage formulaMessage = new FormulaMessage(8, staticValue.getParsePosition(), staticValue.toString(), "Static date/time");
                messages.put(formulaMessage.toString(), formulaMessage);
            } else if (staticValue.getValueType() instanceof LogicalType) {
                FormulaMessage formulaMessage = new FormulaMessage(9, staticValue.getParsePosition(), staticValue.toString(), "Static logical");
                messages.put(formulaMessage.toString(), formulaMessage);
            }
        } else if (lvalue instanceof ContextLookup) {
            ContextLookup contextLookup = (ContextLookup)lvalue;
            FormulaMessage fieldMessage = new FormulaMessage(5, contextLookup.getParsePosition(), contextLookup.getName(), "Field");
            messages.put(fieldMessage.toString(), fieldMessage);
            String name = contextLookup.getName();
            if (Const.indexOfString((String)name, (String[])this.inputFields) < 0) {
                FormulaMessage formulaMessage = new FormulaMessage(1, contextLookup.getParsePosition(), name, "Unknown field name");
                messages.put(formulaMessage.toString(), formulaMessage);
            }
        }
    }
}

