/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransConfiguration;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.SlaveSequence;
import org.pentaho.di.www.SlaveServerConfig;
import org.pentaho.di.www.SocketPortAllocation;

public class TransformationMap {
    private Map<CarteObjectEntry, Trans> transformationMap = new Hashtable<CarteObjectEntry, Trans>();
    private Map<CarteObjectEntry, TransConfiguration> configurationMap = new Hashtable<CarteObjectEntry, TransConfiguration>();
    private Map<String, List<SocketPortAllocation>> hostServerSocketPortsMap = new Hashtable<String, List<SocketPortAllocation>>();
    private SlaveServerConfig slaveServerConfig;

    public synchronized void addTransformation(String transformationName, String containerObjectId, Trans trans, TransConfiguration transConfiguration) {
        CarteObjectEntry entry = new CarteObjectEntry(transformationName, containerObjectId);
        this.transformationMap.put(entry, trans);
        this.configurationMap.put(entry, transConfiguration);
    }

    public synchronized void registerTransformation(Trans trans, TransConfiguration transConfiguration) {
        trans.setContainerObjectId(UUID.randomUUID().toString());
        CarteObjectEntry entry = new CarteObjectEntry(trans.getTransMeta().getName(), trans.getContainerObjectId());
        this.transformationMap.put(entry, trans);
        this.configurationMap.put(entry, transConfiguration);
    }

    public synchronized Trans getTransformation(String transformationName) {
        for (CarteObjectEntry entry : this.transformationMap.keySet()) {
            if (!entry.getName().equals(transformationName)) continue;
            return this.transformationMap.get(entry);
        }
        return null;
    }

    public synchronized Trans getTransformation(CarteObjectEntry entry) {
        return this.transformationMap.get(entry);
    }

    public synchronized TransConfiguration getConfiguration(String transformationName) {
        for (CarteObjectEntry entry : this.configurationMap.keySet()) {
            if (!entry.getName().equals(transformationName)) continue;
            return this.configurationMap.get(entry);
        }
        return null;
    }

    public synchronized TransConfiguration getConfiguration(CarteObjectEntry entry) {
        return this.configurationMap.get(entry);
    }

    public synchronized void removeTransformation(CarteObjectEntry entry) {
        this.transformationMap.remove(entry);
        this.configurationMap.remove(entry);
    }

    public List<CarteObjectEntry> getTransformationObjects() {
        return new ArrayList<CarteObjectEntry>(this.transformationMap.keySet());
    }

    public Map<CarteObjectEntry, TransConfiguration> getConfigurationMap() {
        return this.configurationMap;
    }

    public void setConfigurationMap(Map<CarteObjectEntry, TransConfiguration> configurationMap) {
        this.configurationMap = configurationMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SocketPortAllocation allocateServerSocketPort(int portRangeStart, String hostname, String clusteredRunId, String transformationName, String sourceSlaveName, String sourceStepName, String sourceStepCopy, String targetSlaveName, String targetStepName, String targetStepCopy) {
        if (Const.isEmpty((String)clusteredRunId)) {
            throw new RuntimeException("A server socket allocation always has to accompanied by a cluster run ID but it was empty");
        }
        if (portRangeStart <= 0) {
            throw new RuntimeException("A server socket allocation always has to accompanied by port range start > 0 but it was " + portRangeStart);
        }
        if (Const.isEmpty((String)hostname)) {
            throw new RuntimeException("A server socket allocation always has to accompanied by a hostname but it was empty");
        }
        if (Const.isEmpty((String)transformationName)) {
            throw new RuntimeException("A server socket allocation always has to accompanied by a transformation name but it was empty");
        }
        if (Const.isEmpty((String)sourceSlaveName)) {
            throw new RuntimeException("A server socket allocation always has to accompanied by a source slave server name but it was empty");
        }
        if (Const.isEmpty((String)targetSlaveName)) {
            throw new RuntimeException("A server socket allocation always has to accompanied by a target slave server name but it was empty");
        }
        if (Const.isEmpty((String)sourceStepName)) {
            throw new RuntimeException("A server socket allocation always has to accompanied by a source step name but it was empty");
        }
        if (Const.isEmpty((String)targetStepName)) {
            throw new RuntimeException("A server socket allocation always has to accompanied by a target step name but it was empty");
        }
        if (Const.isEmpty((String)sourceStepCopy)) {
            throw new RuntimeException("A server socket allocation always has to accompanied by a source step copy but it was empty");
        }
        if (Const.isEmpty((String)targetStepCopy)) {
            throw new RuntimeException("A server socket allocation always has to accompanied by a target step copy but it was empty");
        }
        Map<String, List<SocketPortAllocation>> map = this.hostServerSocketPortsMap;
        synchronized (map) {
            List<SocketPortAllocation> serverSocketPortsMap = this.hostServerSocketPortsMap.get(hostname);
            if (serverSocketPortsMap == null) {
                serverSocketPortsMap = new ArrayList<SocketPortAllocation>();
                this.hostServerSocketPortsMap.put(hostname, serverSocketPortsMap);
            }
            List<SocketPortAllocation> list = serverSocketPortsMap;
            synchronized (list) {
                SocketPortAllocation socketPortAllocation = null;
                int maxPort = portRangeStart - 1;
                for (int index = 0; index < serverSocketPortsMap.size(); ++index) {
                    SocketPortAllocation spa = serverSocketPortsMap.get(index);
                    if (spa.getPort() > maxPort) {
                        maxPort = spa.getPort();
                    }
                    if (spa.getClusterRunId().equalsIgnoreCase(clusteredRunId) && spa.getSourceSlaveName().equalsIgnoreCase(sourceSlaveName) && spa.getTargetSlaveName().equalsIgnoreCase(targetSlaveName) && spa.getTransformationName().equalsIgnoreCase(transformationName) && spa.getSourceStepName().equalsIgnoreCase(sourceStepName) && spa.getSourceStepCopy().equalsIgnoreCase(sourceStepCopy) && spa.getTargetStepName().equalsIgnoreCase(targetStepName) && spa.getTargetStepCopy().equalsIgnoreCase(targetStepCopy)) {
                        spa.setAllocated(true);
                        socketPortAllocation = spa;
                        break;
                    }
                    if (spa.isAllocated() || !spa.getSourceSlaveName().equalsIgnoreCase(sourceSlaveName) || !spa.getTargetSlaveName().equalsIgnoreCase(targetSlaveName)) continue;
                    socketPortAllocation = new SocketPortAllocation(spa.getPort(), new Date(), clusteredRunId, transformationName, sourceSlaveName, sourceStepName, sourceStepCopy, targetSlaveName, targetStepName, targetStepCopy);
                    serverSocketPortsMap.set(index, socketPortAllocation);
                    break;
                }
                if (socketPortAllocation == null) {
                    socketPortAllocation = new SocketPortAllocation(maxPort + 1, new Date(), clusteredRunId, transformationName, sourceSlaveName, sourceStepName, sourceStepCopy, targetSlaveName, targetStepName, targetStepCopy);
                    serverSocketPortsMap.add(socketPortAllocation);
                }
                return socketPortAllocation;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deallocateServerSocketPorts(String transName, String carteObjectId) {
        Map<String, List<SocketPortAllocation>> map = this.hostServerSocketPortsMap;
        synchronized (map) {
            for (String hostname : this.hostServerSocketPortsMap.keySet()) {
                List<SocketPortAllocation> spas;
                List<SocketPortAllocation> list = spas = this.hostServerSocketPortsMap.get(hostname);
                synchronized (list) {
                    for (SocketPortAllocation spa : spas) {
                        if (!spa.getTransformationName().equalsIgnoreCase(transName) || !Const.isEmpty((String)carteObjectId) && !spa.getClusterRunId().equals(carteObjectId)) continue;
                        spa.setAllocated(false);
                    }
                }
            }
        }
    }

    public void deallocateServerSocketPorts(CarteObjectEntry entry) {
        for (String hostname : this.hostServerSocketPortsMap.keySet()) {
            for (SocketPortAllocation spa : this.hostServerSocketPortsMap.get(hostname)) {
                if (!spa.getTransformationName().equalsIgnoreCase(entry.getName())) continue;
                spa.setAllocated(false);
            }
        }
    }

    public void deallocateServerSocketPort(int port, String hostname) {
        List<SocketPortAllocation> serverSocketPortsMap = this.hostServerSocketPortsMap.get(hostname);
        if (serverSocketPortsMap == null) {
            return;
        }
        for (SocketPortAllocation spa : new ArrayList<SocketPortAllocation>(serverSocketPortsMap)) {
            if (spa.getPort() != port) continue;
            spa.setAllocated(false);
            return;
        }
    }

    public CarteObjectEntry getFirstCarteObjectEntry(String transName) {
        for (CarteObjectEntry key : this.transformationMap.keySet()) {
            if (!key.getName().equals(transName)) continue;
            return key;
        }
        return null;
    }

    public SlaveServerConfig getSlaveServerConfig() {
        return this.slaveServerConfig;
    }

    public void setSlaveServerConfig(SlaveServerConfig slaveServerConfig) {
        this.slaveServerConfig = slaveServerConfig;
    }

    public Map<String, List<SocketPortAllocation>> getHostServerSocketPortsMap() {
        return this.hostServerSocketPortsMap;
    }

    public void setHostServerSocketPortsMap(Map<String, List<SocketPortAllocation>> hostServerSocketPortsMap) {
        this.hostServerSocketPortsMap = hostServerSocketPortsMap;
    }

    public SlaveSequence getSlaveSequence(String name) {
        return SlaveSequence.findSlaveSequence(name, this.slaveServerConfig.getSlaveSequences());
    }

    public boolean isAutomaticSlaveSequenceCreationAllowed() {
        return this.slaveServerConfig.isAutomaticCreationAllowed();
    }

    public SlaveSequence createSlaveSequence(String name) throws KettleException {
        SlaveSequence auto = this.slaveServerConfig.getAutoSequence();
        if (auto == null) {
            throw new KettleException("No auto-sequence information found in the slave server config.  Slave sequence could not be created automatically.");
        }
        SlaveSequence slaveSequence = new SlaveSequence(name, auto.getStartValue(), auto.getDatabaseMeta(), auto.getSchemaName(), auto.getTableName(), auto.getSequenceNameField(), auto.getValueField());
        this.slaveServerConfig.getSlaveSequences().add(slaveSequence);
        return slaveSequence;
    }
}

