/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobConfiguration;
import org.pentaho.di.job.JobExecutionConfiguration;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransConfiguration;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.www.BaseJobServlet;
import org.pentaho.di.www.WebResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RegisterPackageServlet
extends BaseJobServlet {
    public static final String CONTEXT_PATH = "/kettle/registerPackage";
    private static final long serialVersionUID = -7582587179862317791L;
    private static final String PARAMETER_LOAD = "load";
    private static final String PARAMETER_TYPE = "type";
    private static final String TYPE_JOB = "job";
    private static final String ZIP_CONT = "zip:{0}!{1}";

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }

    @Override
    WebResult generateBody(HttpServletRequest request, HttpServletResponse response, boolean useXML) throws KettleException, IOException {
        FileObject tempFile = KettleVFS.createTempFile((String)"export", (String)".zip", (String)System.getProperty("java.io.tmpdir"));
        OutputStream out = KettleVFS.getOutputStream((FileObject)tempFile, (boolean)false);
        IOUtils.copy((InputStream)request.getInputStream(), (OutputStream)out);
        out.flush();
        IOUtils.closeQuietly((OutputStream)out);
        String archiveUrl = tempFile.getName().toString();
        String load = request.getParameter(PARAMETER_LOAD);
        if (!Const.isEmpty((String)load)) {
            String resultId;
            String fileUrl = MessageFormat.format(ZIP_CONT, archiveUrl, load);
            boolean isJob = TYPE_JOB.equalsIgnoreCase(request.getParameter(PARAMETER_TYPE));
            if (isJob) {
                Node node = this.getConfigNodeFromZIP(archiveUrl, "__job_execution_configuration__.xml", "job_execution_configuration");
                JobExecutionConfiguration jobExecutionConfiguration = new JobExecutionConfiguration(node);
                JobMeta jobMeta = new JobMeta(fileUrl, jobExecutionConfiguration.getRepository());
                JobConfiguration jobConfiguration = new JobConfiguration(jobMeta, jobExecutionConfiguration);
                Job job = this.createJob(jobConfiguration);
                resultId = job.getContainerObjectId();
            } else {
                Node node = this.getConfigNodeFromZIP(archiveUrl, "__job_execution_configuration__.xml", "transformation_execution_configuration");
                TransExecutionConfiguration transExecutionConfiguration = new TransExecutionConfiguration(node);
                TransMeta transMeta = new TransMeta(fileUrl, transExecutionConfiguration.getRepository());
                TransConfiguration transConfiguration = new TransConfiguration(transMeta, transExecutionConfiguration);
                Trans trans = this.createTrans(transConfiguration);
                resultId = trans.getContainerObjectId();
            }
            return new WebResult("OK", fileUrl, resultId);
        }
        return null;
    }

    @Override
    protected boolean useXML(HttpServletRequest request) {
        return true;
    }

    protected Node getConfigNodeFromZIP(Object archiveUrl, Object fileName, String xml_tag) throws KettleXMLException {
        String configUrl = MessageFormat.format(ZIP_CONT, archiveUrl, fileName);
        Document configDoc = XMLHandler.loadXMLFile((String)configUrl);
        return XMLHandler.getSubNode((Node)configDoc, (String)xml_tag);
    }
}

