/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.sapinput;

public enum SapType {
    Single("SINGLE", "Single"),
    Structure("STRUCTURE", "Structure"),
    Table("TABLE", "Table");

    private String code;
    private String description;

    private SapType(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static SapType findTypeForCode(String code) {
        for (SapType type : SapType.values()) {
            if (!type.getCode().equalsIgnoreCase(code)) continue;
            return type;
        }
        return null;
    }

    public static SapType findTypeForDescription(String description) {
        for (SapType type : SapType.values()) {
            if (!type.getDescription().equalsIgnoreCase(description)) continue;
            return type;
        }
        return null;
    }

    public static String[] getDescriptions() {
        String[] descriptions = new String[SapType.values().length];
        for (int i = 0; i < SapType.values().length; ++i) {
            descriptions[i] = SapType.values()[i].getDescription();
        }
        return descriptions;
    }
}

