/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.reservoirsampling;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepDataInterface;

public class ReservoirSamplingData
extends BaseStepData
implements StepDataInterface {
    protected RowMetaInterface m_outputRowMeta;
    protected List<Object[]> m_sample = null;
    protected int m_k;
    protected int m_currentRow;
    protected Random m_random;
    protected PROC_MODE m_state;

    public void setOutputRowMeta(RowMetaInterface rmi) {
        this.m_outputRowMeta = rmi;
    }

    public RowMetaInterface getOutputRowMeta() {
        return this.m_outputRowMeta;
    }

    public List<Object[]> getSample() {
        return this.m_sample;
    }

    public void initialize(int sampleSize, int seed) {
        this.m_k = sampleSize;
        if (this.m_k == 0) {
            this.m_state = PROC_MODE.PASSTHROUGH;
        } else if (this.m_k < 0) {
            this.m_state = PROC_MODE.DISABLED;
        } else if (this.m_k > 0) {
            this.m_state = PROC_MODE.SAMPLING;
        }
        this.m_sample = this.m_k > 0 ? new ArrayList(this.m_k) : new ArrayList();
        this.m_currentRow = 0;
        this.m_random = new Random(seed);
        for (int i = 0; i < 100; ++i) {
            this.m_random.nextDouble();
        }
    }

    public PROC_MODE getProcessingMode() {
        return this.m_state;
    }

    public void setProcessingMode(PROC_MODE state) {
        this.m_state = state;
    }

    public void processRow(Object[] row) {
        double r;
        if (this.m_currentRow < this.m_k) {
            this.setElement(this.m_sample, this.m_currentRow, row);
        } else if (this.m_k > 0 && (r = this.m_random.nextDouble()) < (double)this.m_k / (double)this.m_currentRow) {
            r = this.m_random.nextDouble();
            int replace = (int)((double)this.m_k * r);
            this.setElement(this.m_sample, replace, row);
        }
        ++this.m_currentRow;
    }

    private void setElement(List<Object[]> list, int idx, Object item) {
        int size = list.size();
        if (size <= idx) {
            int buff = size == 0 ? 100 : size * 2;
            for (int i = 0; i < buff; ++i) {
                list.add(null);
            }
        }
        list.set(idx, (Object[])item);
    }

    public void cleanUp() {
        this.m_sample = null;
    }

    public static enum PROC_MODE {
        SAMPLING,
        PASSTHROUGH,
        DISABLED;

    }
}

