/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.randomccnumber;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.randomccnumber.RandomCCNumberGeneratorData;
import org.pentaho.di.trans.steps.randomccnumber.RandomCCNumberGeneratorMeta;
import org.pentaho.di.trans.steps.randomccnumber.RandomCreditCardNumberGenerator;

public class RandomCCNumberGenerator
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = RandomCCNumberGeneratorMeta.class;
    private RandomCCNumberGeneratorMeta meta;
    private RandomCCNumberGeneratorData data;

    public RandomCCNumberGenerator(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        return rowData;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
        }
        for (int i = 0; i < this.data.cardTypes.length && !this.isStopped(); ++i) {
            String[] cardNumber = RandomCreditCardNumberGenerator.GenerateCreditCardNumbers(this.data.cardTypes[i], this.data.cardLen[i], this.data.cardSize[i]);
            for (int j = 0; j < cardNumber.length && !this.isStopped(); ++j) {
                Object[] row = this.buildEmptyRow();
                this.incrementLinesRead();
                int index = 0;
                row[index++] = cardNumber[j];
                if (this.data.addCardTypeOutput) {
                    row[index++] = this.meta.getFieldCCType()[i];
                }
                if (this.data.addCardLengthOutput) {
                    row[index++] = new Long(this.data.cardLen[i]);
                }
                if (this.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"RandomCCNumberGenerator.Log.ValueReturned", (String[])new String[]{this.data.outputRowMeta.getString(row)}));
                }
                this.putRow(this.data.outputRowMeta, row);
            }
        }
        this.setOutputDone();
        return false;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (RandomCCNumberGeneratorMeta)smi;
        this.data = (RandomCCNumberGeneratorData)sdi;
        if (super.init(smi, sdi)) {
            if (this.meta.getFieldCCType() == null) {
                this.logError(BaseMessages.getString(PKG, (String)"RandomCCNumberGenerator.Log.NoFieldSpecified", (String[])new String[0]));
                return false;
            }
            if (this.meta.getFieldCCType().length == 0) {
                this.logError(BaseMessages.getString(PKG, (String)"RandomCCNumberGenerator.Log.NoFieldSpecified", (String[])new String[0]));
                return false;
            }
            if (Const.isEmpty((String)this.meta.getCardNumberFieldName())) {
                this.logError(BaseMessages.getString(PKG, (String)"RandomCCNumberGenerator.Log.CardNumberFieldMissing", (String[])new String[0]));
                return false;
            }
            this.data.cardTypes = new int[this.meta.getFieldCCType().length];
            this.data.cardLen = new int[this.meta.getFieldCCType().length];
            this.data.cardSize = new int[this.meta.getFieldCCType().length];
            for (int i = 0; i < this.meta.getFieldCCType().length; ++i) {
                this.data.cardTypes[i] = RandomCreditCardNumberGenerator.getCardType(this.meta.getFieldCCType()[i]);
                String len = this.environmentSubstitute(this.meta.getFieldCCLength()[i]);
                this.data.cardLen[i] = Const.toInt((String)len, (int)-1);
                if (this.data.cardLen[i] < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"RandomCCNumberGenerator.Log.WrongLength", (String[])new String[]{len, String.valueOf(i)}));
                    return false;
                }
                String size = this.environmentSubstitute(this.meta.getFieldCCSize()[i]);
                this.data.cardSize[i] = Const.toInt((String)size, (int)-1);
                if (this.data.cardSize[i] >= 0) continue;
                this.logError(BaseMessages.getString(PKG, (String)"RandomCCNumberGenerator.Log.WrongSize", (String[])new String[]{size, String.valueOf(i)}));
                return false;
            }
            this.data.addCardTypeOutput = !Const.isEmpty((String)this.meta.getCardTypeFieldName());
            this.data.addCardLengthOutput = !Const.isEmpty((String)this.meta.getCardLengthFieldName());
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        super.dispose(smi, sdi);
    }
}

