/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.orabulkloader;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ProvidesDatabaseConnectionInformation;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.orabulkloader.OraBulkLoader;
import org.pentaho.di.trans.steps.orabulkloader.OraBulkLoaderData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class OraBulkLoaderMeta
extends BaseStepMeta
implements StepMetaInterface,
ProvidesDatabaseConnectionInformation {
    private static Class<?> PKG = OraBulkLoaderMeta.class;
    private static int DEFAULT_COMMIT_SIZE = 100000;
    private static int DEFAULT_BIND_SIZE = 0;
    private static int DEFAULT_READ_SIZE = 0;
    private static int DEFAULT_MAX_ERRORS = 50;
    private String schemaName;
    private String tableName;
    private String sqlldr;
    private String controlFile;
    private String dataFile;
    private String logFile;
    private String badFile;
    private String discardFile;
    private DatabaseMeta databaseMeta;
    private String[] fieldTable;
    private String[] fieldStream;
    private String[] dateMask;
    private String commitSize;
    private String bindSize;
    private String readSize;
    private String maxErrors;
    private String loadMethod;
    private String loadAction;
    private String encoding;
    private String characterSetName;
    private boolean directPath;
    private boolean eraseFiles;
    private String dbNameOverride;
    private boolean failOnWarning;
    private boolean failOnError;
    private boolean parallel;
    private String altRecordTerm;
    public static final String ACTION_APPEND = "APPEND";
    public static final String ACTION_INSERT = "INSERT";
    public static final String ACTION_REPLACE = "REPLACE";
    public static final String ACTION_TRUNCATE = "TRUNCATE";
    public static final String METHOD_AUTO_CONCURRENT = "AUTO_CONCURRENT";
    public static final String METHOD_AUTO_END = "AUTO_END";
    public static final String METHOD_MANUAL = "MANUAL";
    public static final String DATE_MASK_DATE = "DATE";
    public static final String DATE_MASK_DATETIME = "DATETIME";

    public int getCommitSizeAsInt(VariableSpace varSpace) {
        try {
            return Integer.valueOf(varSpace.environmentSubstitute(this.getCommitSize()));
        }
        catch (NumberFormatException ex) {
            return DEFAULT_COMMIT_SIZE;
        }
    }

    public String getCommitSize() {
        return this.commitSize;
    }

    public void setCommitSize(String commitSize) {
        this.commitSize = commitSize;
    }

    @Override
    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getSqlldr() {
        return this.sqlldr;
    }

    public void setSqlldr(String sqlldr) {
        this.sqlldr = sqlldr;
    }

    public String[] getFieldTable() {
        return this.fieldTable;
    }

    public void setFieldTable(String[] updateLookup) {
        this.fieldTable = updateLookup;
    }

    public String[] getFieldStream() {
        return this.fieldStream;
    }

    public void setFieldStream(String[] updateStream) {
        this.fieldStream = updateStream;
    }

    public String[] getDateMask() {
        return this.dateMask;
    }

    public void setDateMask(String[] dateMask) {
        this.dateMask = dateMask;
    }

    public boolean isFailOnWarning() {
        return this.failOnWarning;
    }

    public void setFailOnWarning(boolean failOnWarning) {
        this.failOnWarning = failOnWarning;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public String getCharacterSetName() {
        return this.characterSetName;
    }

    public void setCharacterSetName(String characterSetName) {
        this.characterSetName = characterSetName;
    }

    public String getAltRecordTerm() {
        return this.altRecordTerm;
    }

    public void setAltRecordTerm(String altRecordTerm) {
        this.altRecordTerm = altRecordTerm;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public void allocate(int nrvalues) {
        this.fieldTable = new String[nrvalues];
        this.fieldStream = new String[nrvalues];
        this.dateMask = new String[nrvalues];
    }

    @Override
    public Object clone() {
        OraBulkLoaderMeta retval = (OraBulkLoaderMeta)super.clone();
        int nrvalues = this.fieldTable.length;
        retval.allocate(nrvalues);
        for (int i = 0; i < nrvalues; ++i) {
            retval.fieldTable[i] = this.fieldTable[i];
            retval.fieldStream[i] = this.fieldStream[i];
            retval.dateMask[i] = this.dateMask[i];
        }
        return retval;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)con);
            this.commitSize = XMLHandler.getTagValue((Node)stepnode, (String)"commit");
            if (Const.isEmpty((String)this.commitSize)) {
                this.commitSize = Integer.toString(DEFAULT_COMMIT_SIZE);
            }
            this.bindSize = XMLHandler.getTagValue((Node)stepnode, (String)"bind_size");
            if (Const.isEmpty((String)this.bindSize)) {
                this.bindSize = Integer.toString(DEFAULT_BIND_SIZE);
            }
            this.readSize = XMLHandler.getTagValue((Node)stepnode, (String)"read_size");
            if (Const.isEmpty((String)this.readSize)) {
                this.readSize = Integer.toString(DEFAULT_READ_SIZE);
            }
            this.maxErrors = XMLHandler.getTagValue((Node)stepnode, (String)"errors");
            if (Const.isEmpty((String)this.maxErrors)) {
                this.maxErrors = Integer.toString(DEFAULT_MAX_ERRORS);
            }
            this.schemaName = XMLHandler.getTagValue((Node)stepnode, (String)"schema");
            this.tableName = XMLHandler.getTagValue((Node)stepnode, (String)"table");
            this.loadMethod = XMLHandler.getTagValue((Node)stepnode, (String)"load_method");
            this.loadAction = XMLHandler.getTagValue((Node)stepnode, (String)"load_action");
            this.sqlldr = XMLHandler.getTagValue((Node)stepnode, (String)"sqlldr");
            this.controlFile = XMLHandler.getTagValue((Node)stepnode, (String)"control_file");
            this.dataFile = XMLHandler.getTagValue((Node)stepnode, (String)"data_file");
            this.logFile = XMLHandler.getTagValue((Node)stepnode, (String)"log_file");
            this.badFile = XMLHandler.getTagValue((Node)stepnode, (String)"bad_file");
            this.discardFile = XMLHandler.getTagValue((Node)stepnode, (String)"discard_file");
            this.directPath = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"direct_path"));
            this.eraseFiles = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"erase_files"));
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)"encoding");
            this.dbNameOverride = XMLHandler.getTagValue((Node)stepnode, (String)"dbname_override");
            this.characterSetName = XMLHandler.getTagValue((Node)stepnode, (String)"character_set");
            this.failOnWarning = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"fail_on_warning"));
            this.failOnError = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"fail_on_error"));
            this.parallel = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"parallel"));
            this.altRecordTerm = XMLHandler.getTagValue((Node)stepnode, (String)"alt_rec_term");
            int nrvalues = XMLHandler.countNodes((Node)stepnode, (String)"mapping");
            this.allocate(nrvalues);
            for (int i = 0; i < nrvalues; ++i) {
                String locDateMask;
                Node vnode = XMLHandler.getSubNodeByNr((Node)stepnode, (String)"mapping", (int)i);
                this.fieldTable[i] = XMLHandler.getTagValue((Node)vnode, (String)"stream_name");
                this.fieldStream[i] = XMLHandler.getTagValue((Node)vnode, (String)"field_name");
                if (this.fieldStream[i] == null) {
                    this.fieldStream[i] = this.fieldTable[i];
                }
                this.dateMask[i] = (locDateMask = XMLHandler.getTagValue((Node)vnode, (String)"date_mask")) == null ? "" : (DATE_MASK_DATE.equals(locDateMask) || DATE_MASK_DATETIME.equals(locDateMask) ? locDateMask : "");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.Exception.UnableToReadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.fieldTable = null;
        this.databaseMeta = null;
        this.commitSize = Integer.toString(DEFAULT_COMMIT_SIZE);
        this.bindSize = Integer.toString(DEFAULT_BIND_SIZE);
        this.readSize = Integer.toString(DEFAULT_READ_SIZE);
        this.maxErrors = Integer.toString(DEFAULT_MAX_ERRORS);
        this.schemaName = "";
        this.tableName = BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.DefaultTableName", (String[])new String[0]);
        this.loadMethod = METHOD_AUTO_END;
        this.loadAction = ACTION_APPEND;
        this.sqlldr = "sqlldr";
        this.controlFile = "control${Internal.Step.CopyNr}.cfg";
        this.dataFile = "load${Internal.Step.CopyNr}.dat";
        this.logFile = "";
        this.badFile = "";
        this.discardFile = "";
        this.encoding = "";
        this.dbNameOverride = "";
        this.directPath = false;
        this.eraseFiles = true;
        this.characterSetName = "";
        this.failOnWarning = false;
        this.failOnError = false;
        this.parallel = false;
        this.altRecordTerm = "";
        int nrvalues = 0;
        this.allocate(nrvalues);
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XMLHandler.addTagValue((String)"commit", (String)this.commitSize));
        retval.append("    ").append(XMLHandler.addTagValue((String)"bind_size", (String)this.bindSize));
        retval.append("    ").append(XMLHandler.addTagValue((String)"read_size", (String)this.readSize));
        retval.append("    ").append(XMLHandler.addTagValue((String)"errors", (String)this.maxErrors));
        retval.append("    ").append(XMLHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"table", (String)this.tableName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"load_method", (String)this.loadMethod));
        retval.append("    ").append(XMLHandler.addTagValue((String)"load_action", (String)this.loadAction));
        retval.append("    ").append(XMLHandler.addTagValue((String)"sqlldr", (String)this.sqlldr));
        retval.append("    ").append(XMLHandler.addTagValue((String)"control_file", (String)this.controlFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"data_file", (String)this.dataFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"log_file", (String)this.logFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"bad_file", (String)this.badFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"discard_file", (String)this.discardFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"direct_path", (boolean)this.directPath));
        retval.append("    ").append(XMLHandler.addTagValue((String)"erase_files", (boolean)this.eraseFiles));
        retval.append("    ").append(XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    ").append(XMLHandler.addTagValue((String)"dbname_override", (String)this.dbNameOverride));
        retval.append("    ").append(XMLHandler.addTagValue((String)"character_set", (String)this.characterSetName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"fail_on_warning", (boolean)this.failOnWarning));
        retval.append("    ").append(XMLHandler.addTagValue((String)"fail_on_error", (boolean)this.failOnError));
        retval.append("    ").append(XMLHandler.addTagValue((String)"parallel", (boolean)this.parallel));
        retval.append("    ").append(XMLHandler.addTagValue((String)"alt_rec_term", (String)this.altRecordTerm));
        for (int i = 0; i < this.fieldTable.length; ++i) {
            retval.append("      <mapping>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"stream_name", (String)this.fieldTable[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"field_name", (String)this.fieldStream[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"date_mask", (String)this.dateMask[i]));
            retval.append("      </mapping>").append(Const.CR);
        }
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            this.commitSize = rep.getStepAttributeString(id_step, "commit");
            this.bindSize = rep.getStepAttributeString(id_step, "bind_size");
            this.readSize = rep.getStepAttributeString(id_step, "read_size");
            this.maxErrors = rep.getStepAttributeString(id_step, "errors");
            this.schemaName = rep.getStepAttributeString(id_step, "schema");
            this.tableName = rep.getStepAttributeString(id_step, "table");
            this.loadMethod = rep.getStepAttributeString(id_step, "load_method");
            this.loadAction = rep.getStepAttributeString(id_step, "load_action");
            this.sqlldr = rep.getStepAttributeString(id_step, "sqlldr");
            this.controlFile = rep.getStepAttributeString(id_step, "control_file");
            this.dataFile = rep.getStepAttributeString(id_step, "data_file");
            this.logFile = rep.getStepAttributeString(id_step, "log_file");
            this.badFile = rep.getStepAttributeString(id_step, "bad_file");
            this.discardFile = rep.getStepAttributeString(id_step, "discard_file");
            this.directPath = rep.getStepAttributeBoolean(id_step, "direct_path");
            this.eraseFiles = rep.getStepAttributeBoolean(id_step, "erase_files");
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            this.dbNameOverride = rep.getStepAttributeString(id_step, "dbname_override");
            this.characterSetName = rep.getStepAttributeString(id_step, "character_set");
            this.failOnWarning = rep.getStepAttributeBoolean(id_step, "fail_on_warning");
            this.failOnError = rep.getStepAttributeBoolean(id_step, "fail_on_error");
            this.parallel = rep.getStepAttributeBoolean(id_step, "parallel");
            this.altRecordTerm = rep.getStepAttributeString(id_step, "alt_rec_term");
            int nrvalues = rep.countNrStepAttributes(id_step, "stream_name");
            this.allocate(nrvalues);
            for (int i = 0; i < nrvalues; ++i) {
                this.fieldTable[i] = rep.getStepAttributeString(id_step, i, "stream_name");
                this.fieldStream[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.dateMask[i] = rep.getStepAttributeString(id_step, i, "date_mask");
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.Exception.UnexpectedErrorReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta);
            rep.saveStepAttribute(id_transformation, id_step, "commit", this.commitSize);
            rep.saveStepAttribute(id_transformation, id_step, "bind_size", this.bindSize);
            rep.saveStepAttribute(id_transformation, id_step, "read_size", this.readSize);
            rep.saveStepAttribute(id_transformation, id_step, "errors", this.maxErrors);
            rep.saveStepAttribute(id_transformation, id_step, "schema", this.schemaName);
            rep.saveStepAttribute(id_transformation, id_step, "table", this.tableName);
            rep.saveStepAttribute(id_transformation, id_step, "load_method", this.loadMethod);
            rep.saveStepAttribute(id_transformation, id_step, "load_action", this.loadAction);
            rep.saveStepAttribute(id_transformation, id_step, "sqlldr", this.sqlldr);
            rep.saveStepAttribute(id_transformation, id_step, "control_file", this.controlFile);
            rep.saveStepAttribute(id_transformation, id_step, "data_file", this.dataFile);
            rep.saveStepAttribute(id_transformation, id_step, "log_file", this.logFile);
            rep.saveStepAttribute(id_transformation, id_step, "bad_file", this.badFile);
            rep.saveStepAttribute(id_transformation, id_step, "discard_file", this.discardFile);
            rep.saveStepAttribute(id_transformation, id_step, "direct_path", this.directPath);
            rep.saveStepAttribute(id_transformation, id_step, "erase_files", this.eraseFiles);
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            rep.saveStepAttribute(id_transformation, id_step, "dbname_override", this.dbNameOverride);
            rep.saveStepAttribute(id_transformation, id_step, "character_set", this.characterSetName);
            rep.saveStepAttribute(id_transformation, id_step, "fail_on_warning", this.failOnWarning);
            rep.saveStepAttribute(id_transformation, id_step, "fail_on_error", this.failOnError);
            rep.saveStepAttribute(id_transformation, id_step, "parallel", this.parallel);
            rep.saveStepAttribute(id_transformation, id_step, "alt_rec_term", this.altRecordTerm);
            for (int i = 0; i < this.fieldTable.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "stream_name", this.fieldTable[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.fieldStream[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "date_mask", this.dateMask[i]);
            }
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getObjectId());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        String error_message = "";
        if (this.databaseMeta != null) {
            Database db = new Database(loggingObject, this.databaseMeta);
            db.shareVariablesWith((VariableSpace)transMeta);
            try {
                boolean error_found;
                boolean first;
                db.connect();
                if (!Const.isEmpty((String)this.tableName)) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.CheckResult.TableNameOK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                    first = true;
                    error_found = false;
                    error_message = "";
                    String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(transMeta.environmentSubstitute(this.schemaName), transMeta.environmentSubstitute(this.tableName));
                    RowMetaInterface r = db.getTableFields(schemaTable);
                    if (r != null) {
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.CheckResult.TableExists", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                        first = true;
                        error_found = false;
                        error_message = "";
                        for (int i = 0; i < this.fieldTable.length; ++i) {
                            String field = this.fieldTable[i];
                            ValueMetaInterface v = r.searchValueMeta(field);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                error_message = error_message + BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.CheckResult.MissingFieldsToLoadInTargetTable", (String[])new String[0]) + Const.CR;
                            }
                            error_found = true;
                            error_message = error_message + "\t\t" + field + Const.CR;
                        }
                        cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.CheckResult.AllFieldsFoundInTargetTable", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    } else {
                        error_message = BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.CheckResult.CouldNotReadTableInfo", (String[])new String[0]);
                        cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    }
                }
                if (prev != null && prev.size() > 0) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.CheckResult.StepReceivingDatas", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                    first = true;
                    error_message = "";
                    error_found = false;
                    for (int i = 0; i < this.fieldStream.length; ++i) {
                        ValueMetaInterface v = prev.searchValueMeta(this.fieldStream[i]);
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            error_message = error_message + BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.CheckResult.MissingFieldsInInput", (String[])new String[0]) + Const.CR;
                        }
                        error_found = true;
                        error_message = error_message + "\t\t" + this.fieldStream[i] + Const.CR;
                    }
                    cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.CheckResult.AllFieldsFoundInInput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                error_message = BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.CheckResult.MissingFieldsInInput3", (String[])new String[0]) + Const.CR;
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            catch (KettleException e) {
                error_message = BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.CheckResult.DatabaseErrorOccurred", (String[])new String[0]) + e.getMessage();
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            error_message = BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.CheckResult.StepReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.CheckResult.NoInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, Repository repository, IMetaStore metaStore) throws KettleStepException {
        SQLStatement retval;
        block11: {
            retval = new SQLStatement(stepMeta.getName(), this.databaseMeta, null);
            if (this.databaseMeta != null) {
                if (prev != null && prev.size() > 0) {
                    RowMeta tableFields = new RowMeta();
                    for (int i = 0; i < this.fieldTable.length; ++i) {
                        ValueMetaInterface v = prev.searchValueMeta(this.fieldStream[i]);
                        if (v == null) {
                            throw new KettleStepException("Unable to find field [" + this.fieldStream[i] + "] in the input rows");
                        }
                        ValueMetaInterface tableField = v.clone();
                        tableField.setName(this.fieldTable[i]);
                        tableFields.addValueMeta(tableField);
                    }
                    if (!Const.isEmpty((String)this.tableName)) {
                        Database db = new Database(loggingObject, this.databaseMeta);
                        db.shareVariablesWith((VariableSpace)transMeta);
                        try {
                            db.connect();
                            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(transMeta.environmentSubstitute(this.schemaName), transMeta.environmentSubstitute(this.tableName));
                            String sql = db.getDDL(schemaTable, (RowMetaInterface)tableFields, null, false, null, true);
                            if (sql.length() == 0) {
                                retval.setSQL(null);
                                break block11;
                            }
                            retval.setSQL(sql);
                        }
                        catch (KettleException e) {
                            retval.setError(BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.GetSQL.ErrorOccurred", (String[])new String[0]) + e.getMessage());
                        }
                    } else {
                        retval.setError(BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.GetSQL.NoTableDefinedOnConnection", (String[])new String[0]));
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.GetSQL.NotReceivingAnyFields", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.GetSQL.NoConnectionDefined", (String[])new String[0]));
            }
        }
        return retval;
    }

    @Override
    public void analyseImpact(List<DatabaseImpact> impact, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (prev != null) {
            for (int i = 0; i < this.fieldTable.length; ++i) {
                ValueMetaInterface v = prev.searchValueMeta(this.fieldStream[i]);
                DatabaseImpact ii = new DatabaseImpact(3, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), transMeta.environmentSubstitute(this.tableName), this.fieldTable[i], this.fieldStream[i], v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                impact.add(ii);
            }
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new OraBulkLoader(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new OraBulkLoaderData();
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    public boolean isDirectPath() {
        return this.directPath;
    }

    public void setDirectPath(boolean directPath) {
        this.directPath = directPath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RowMetaInterface getRequiredFields(VariableSpace space) throws KettleException {
        String realTableName = space.environmentSubstitute(this.tableName);
        String realSchemaName = space.environmentSubstitute(this.schemaName);
        if (this.databaseMeta == null) throw new KettleException(BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.Exception.ConnectionNotDefined", (String[])new String[0]));
        Database db = new Database(loggingObject, this.databaseMeta);
        try {
            db.connect();
            if (Const.isEmpty((String)realTableName)) throw new KettleException(BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.Exception.TableNotSpecified", (String[])new String[0]));
            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(realSchemaName, realTableName);
            if (db.checkTableExists(schemaTable)) {
                RowMetaInterface rowMetaInterface = db.getTableFields(schemaTable);
                return rowMetaInterface;
            }
            try {
                throw new KettleException(BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.Exception.TableNotFound", (String[])new String[0]));
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
            }
        }
        finally {
            db.disconnect();
        }
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getBadFile() {
        return this.badFile;
    }

    public void setBadFile(String badFile) {
        this.badFile = badFile;
    }

    public String getControlFile() {
        return this.controlFile;
    }

    public void setControlFile(String controlFile) {
        this.controlFile = controlFile;
    }

    public String getDataFile() {
        return this.dataFile;
    }

    public void setDataFile(String dataFile) {
        this.dataFile = dataFile;
    }

    public String getDiscardFile() {
        return this.discardFile;
    }

    public void setDiscardFile(String discardFile) {
        this.discardFile = discardFile;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public void setLoadAction(String action) {
        this.loadAction = action;
    }

    public String getLoadAction() {
        return this.loadAction;
    }

    public void setLoadMethod(String method) {
        this.loadMethod = method;
    }

    public String getLoadMethod() {
        return this.loadMethod;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getDelimiter() {
        return ",";
    }

    public String getEnclosure() {
        return "\"";
    }

    public boolean isEraseFiles() {
        return this.eraseFiles;
    }

    public void setEraseFiles(boolean eraseFiles) {
        this.eraseFiles = eraseFiles;
    }

    public int getBindSizeAsInt(VariableSpace varSpace) {
        try {
            return Integer.valueOf(varSpace.environmentSubstitute(this.getBindSize()));
        }
        catch (NumberFormatException ex) {
            return DEFAULT_BIND_SIZE;
        }
    }

    public String getBindSize() {
        return this.bindSize;
    }

    public void setBindSize(String bindSize) {
        this.bindSize = bindSize;
    }

    public int getMaxErrorsAsInt(VariableSpace varSpace) {
        try {
            return Integer.valueOf(varSpace.environmentSubstitute(this.getMaxErrors()));
        }
        catch (NumberFormatException ex) {
            return DEFAULT_MAX_ERRORS;
        }
    }

    public String getMaxErrors() {
        return this.maxErrors;
    }

    public void setMaxErrors(String maxErrors) {
        this.maxErrors = maxErrors;
    }

    public int getReadSizeAsInt(VariableSpace varSpace) {
        try {
            return Integer.valueOf(varSpace.environmentSubstitute(this.getReadSize()));
        }
        catch (NumberFormatException ex) {
            return DEFAULT_READ_SIZE;
        }
    }

    public String getReadSize() {
        return this.readSize;
    }

    public void setReadSize(String readSize) {
        this.readSize = readSize;
    }

    public String getDbNameOverride() {
        return this.dbNameOverride;
    }

    public void setDbNameOverride(String dbNameOverride) {
        this.dbNameOverride = dbNameOverride;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    @Override
    public String getMissingDatabaseConnectionInformationMessage() {
        return null;
    }
}

