/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mapping;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.mapping.MappingValueRename;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class MappingIODefinition
implements Cloneable {
    public static final String XML_TAG = "mapping";
    private StepMeta inputStep;
    private String inputStepname = null;
    private String outputStepname = null;
    private String description;
    private List<MappingValueRename> valueRenames = new ArrayList<MappingValueRename>();
    private boolean mainDataPath = false;
    private boolean renamingOnOutput = false;

    public MappingIODefinition() {
    }

    public MappingIODefinition(String inputStepname, String outputStepname) {
        this();
        this.inputStepname = inputStepname;
        this.outputStepname = outputStepname;
    }

    public Object clone() {
        try {
            MappingIODefinition definition = (MappingIODefinition)super.clone();
            return definition;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public MappingIODefinition(Node mappingNode) {
        this();
        this.inputStepname = XMLHandler.getTagValue((Node)mappingNode, (String)"input_step");
        this.outputStepname = XMLHandler.getTagValue((Node)mappingNode, (String)"output_step");
        this.mainDataPath = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)mappingNode, (String)"main_path"));
        this.renamingOnOutput = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)mappingNode, (String)"rename_on_output"));
        this.description = XMLHandler.getTagValue((Node)mappingNode, (String)"description");
        int nrConnectors = XMLHandler.countNodes((Node)mappingNode, (String)"connector");
        for (int i = 0; i < nrConnectors; ++i) {
            Node inputConnector = XMLHandler.getSubNodeByNr((Node)mappingNode, (String)"connector", (int)i);
            String parentField = XMLHandler.getTagValue((Node)inputConnector, (String)"parent");
            String childField = XMLHandler.getTagValue((Node)inputConnector, (String)"child");
            this.valueRenames.add(new MappingValueRename(parentField, childField));
        }
    }

    public String getXML() {
        StringBuffer xml = new StringBuffer(200);
        xml.append("    ").append(XMLHandler.openTag((String)XML_TAG));
        xml.append("    ").append(XMLHandler.addTagValue((String)"input_step", (String)this.inputStepname));
        xml.append("    ").append(XMLHandler.addTagValue((String)"output_step", (String)this.outputStepname));
        xml.append("    ").append(XMLHandler.addTagValue((String)"main_path", (boolean)this.mainDataPath));
        xml.append("    ").append(XMLHandler.addTagValue((String)"rename_on_output", (boolean)this.renamingOnOutput));
        xml.append("    ").append(XMLHandler.addTagValue((String)"description", (String)this.description));
        for (MappingValueRename valueRename : this.valueRenames) {
            xml.append("       ").append(XMLHandler.openTag((String)"connector"));
            xml.append(XMLHandler.addTagValue((String)"parent", (String)valueRename.getSourceValueName(), (boolean)false, (String[])new String[0]));
            xml.append(XMLHandler.addTagValue((String)"child", (String)valueRename.getTargetValueName(), (boolean)false, (String[])new String[0]));
            xml.append(XMLHandler.closeTag((String)"connector")).append(Const.CR);
        }
        xml.append("    ").append(XMLHandler.closeTag((String)XML_TAG));
        return xml.toString();
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step, String prefix, int nr) throws KettleException {
        rep.saveStepAttribute(id_transformation, id_step, nr, prefix + "input_step", this.inputStepname);
        rep.saveStepAttribute(id_transformation, id_step, nr, prefix + "output_step", this.outputStepname);
        rep.saveStepAttribute(id_transformation, id_step, nr, prefix + "main_path", this.mainDataPath);
        rep.saveStepAttribute(id_transformation, id_step, nr, prefix + "rename_on_output", this.renamingOnOutput);
        rep.saveStepAttribute(id_transformation, id_step, nr, prefix + "description", this.description);
        rep.saveStepAttribute(id_transformation, id_step, nr, prefix + "nr_renames", this.valueRenames.size());
        for (int i = 0; i < this.valueRenames.size(); ++i) {
            rep.saveStepAttribute(id_transformation, id_step, nr, prefix + "rename_parent_" + i, this.valueRenames.get(i).getSourceValueName());
            rep.saveStepAttribute(id_transformation, id_step, nr, prefix + "rename_child_" + i, this.valueRenames.get(i).getTargetValueName());
        }
    }

    public MappingIODefinition(Repository rep, ObjectId id_step, String prefix, int nr) throws KettleException {
        this();
        this.inputStepname = rep.getStepAttributeString(id_step, nr, prefix + "input_step");
        this.outputStepname = rep.getStepAttributeString(id_step, nr, prefix + "output_step");
        this.mainDataPath = rep.getStepAttributeBoolean(id_step, nr, prefix + "main_path");
        this.renamingOnOutput = rep.getStepAttributeBoolean(id_step, nr, prefix + "rename_on_output");
        this.description = rep.getStepAttributeString(id_step, nr, prefix + "description");
        int nrRenames = (int)rep.getStepAttributeInteger(id_step, nr, prefix + "nr_renames");
        for (int i = 0; i < nrRenames; ++i) {
            String parent = rep.getStepAttributeString(id_step, nr, prefix + "rename_parent_" + i);
            String child = rep.getStepAttributeString(id_step, nr, prefix + "rename_child_" + i);
            this.valueRenames.add(new MappingValueRename(parent, child));
        }
    }

    public String getInputStepname() {
        return this.inputStepname;
    }

    public void setInputStepname(String inputStepname) {
        this.inputStepname = inputStepname;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOutputStepname() {
        return this.outputStepname;
    }

    public void setOutputStepname(String outputStepname) {
        this.outputStepname = outputStepname;
    }

    public boolean isMainDataPath() {
        return this.mainDataPath;
    }

    public void setMainDataPath(boolean mainDataPath) {
        this.mainDataPath = mainDataPath;
    }

    public boolean isRenamingOnOutput() {
        return this.renamingOnOutput;
    }

    public void setRenamingOnOutput(boolean renamingOnOutput) {
        this.renamingOnOutput = renamingOnOutput;
    }

    public List<MappingValueRename> getValueRenames() {
        return this.valueRenames;
    }

    public void setValueRenames(List<MappingValueRename> valueRenames) {
        this.valueRenames = valueRenames;
    }

    public StepMeta getInputStep() {
        return this.inputStep;
    }

    public void setInputStep(StepMeta inputStep) {
        this.inputStep = inputStep;
    }
}

