/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fieldsplitter;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.fieldsplitter.FieldSplitter;
import org.pentaho.di.trans.steps.fieldsplitter.FieldSplitterData;
import org.pentaho.di.trans.steps.fieldsplitter.FieldSplitterMetaInjection;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class FieldSplitterMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = FieldSplitterMeta.class;
    private String splitField;
    private String delimiter;
    private String enclosure;
    private String[] fieldName;
    private String[] fieldID;
    private boolean[] fieldRemoveID;
    private int[] fieldType;
    private String[] fieldFormat;
    private String[] fieldGroup;
    private String[] fieldDecimal;
    private String[] fieldCurrency;
    private int[] fieldLength;
    private int[] fieldPrecision;
    private String[] fieldNullIf;
    private String[] fieldIfNull;
    private int[] fieldTrimType;

    public String getSplitField() {
        return this.splitField;
    }

    public void setSplitField(String splitField) {
        this.splitField = splitField;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getEnclosure() {
        return this.enclosure;
    }

    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public String[] getFieldID() {
        return this.fieldID;
    }

    public void setFieldID(String[] fieldID) {
        this.fieldID = fieldID;
    }

    public boolean[] getFieldRemoveID() {
        return this.fieldRemoveID;
    }

    public void setFieldRemoveID(boolean[] fieldRemoveID) {
        this.fieldRemoveID = fieldRemoveID;
    }

    public int[] getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(int[] fieldType) {
        this.fieldType = fieldType;
    }

    public String[] getFieldFormat() {
        return this.fieldFormat;
    }

    public void setFieldFormat(String[] fieldFormat) {
        this.fieldFormat = fieldFormat;
    }

    public String[] getFieldGroup() {
        return this.fieldGroup;
    }

    public void setFieldGroup(String[] fieldGroup) {
        this.fieldGroup = fieldGroup;
    }

    public String[] getFieldDecimal() {
        return this.fieldDecimal;
    }

    public void setFieldDecimal(String[] fieldDecimal) {
        this.fieldDecimal = fieldDecimal;
    }

    public String[] getFieldCurrency() {
        return this.fieldCurrency;
    }

    public void setFieldCurrency(String[] fieldCurrency) {
        this.fieldCurrency = fieldCurrency;
    }

    public int[] getFieldLength() {
        return this.fieldLength;
    }

    public void setFieldLength(int[] fieldLength) {
        this.fieldLength = fieldLength;
    }

    public int[] getFieldPrecision() {
        return this.fieldPrecision;
    }

    public void setFieldPrecision(int[] fieldPrecision) {
        this.fieldPrecision = fieldPrecision;
    }

    public String[] getFieldNullIf() {
        return this.fieldNullIf;
    }

    public void setFieldNullIf(String[] fieldNullIf) {
        this.fieldNullIf = fieldNullIf;
    }

    public String[] getFieldIfNull() {
        return this.fieldIfNull;
    }

    public void setFieldIfNull(String[] fieldIfNull) {
        this.fieldIfNull = fieldIfNull;
    }

    public int[] getFieldTrimType() {
        return this.fieldTrimType;
    }

    public void setFieldTrimType(int[] fieldTrimType) {
        this.fieldTrimType = fieldTrimType;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrfields) {
        this.fieldName = new String[nrfields];
        this.fieldID = new String[nrfields];
        this.fieldRemoveID = new boolean[nrfields];
        this.fieldType = new int[nrfields];
        this.fieldFormat = new String[nrfields];
        this.fieldGroup = new String[nrfields];
        this.fieldDecimal = new String[nrfields];
        this.fieldCurrency = new String[nrfields];
        this.fieldLength = new int[nrfields];
        this.fieldPrecision = new int[nrfields];
        this.fieldNullIf = new String[nrfields];
        this.fieldIfNull = new String[nrfields];
        this.fieldTrimType = new int[nrfields];
    }

    @Override
    public Object clone() {
        FieldSplitterMeta retval = (FieldSplitterMeta)super.clone();
        int nrfields = this.fieldName.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.fieldName[i] = this.fieldName[i];
            retval.fieldID[i] = this.fieldID[i];
            retval.fieldRemoveID[i] = this.fieldRemoveID[i];
            retval.fieldType[i] = this.fieldType[i];
            retval.fieldLength[i] = this.fieldLength[i];
            retval.fieldPrecision[i] = this.fieldPrecision[i];
            retval.fieldFormat[i] = this.fieldFormat[i];
            retval.fieldGroup[i] = this.fieldGroup[i];
            retval.fieldDecimal[i] = this.fieldDecimal[i];
            retval.fieldCurrency[i] = this.fieldCurrency[i];
            retval.fieldNullIf[i] = this.fieldNullIf[i];
            retval.fieldIfNull[i] = this.fieldIfNull[i];
            retval.fieldTrimType[i] = this.fieldTrimType[i];
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.splitField = XMLHandler.getTagValue((Node)stepnode, (String)"splitfield");
            this.delimiter = XMLHandler.getTagValue((Node)stepnode, (String)"delimiter");
            this.enclosure = XMLHandler.getTagValue((Node)stepnode, (String)"enclosure");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.fieldID[i] = XMLHandler.getTagValue((Node)fnode, (String)"id");
                String sidrem = XMLHandler.getTagValue((Node)fnode, (String)"idrem");
                String stype = XMLHandler.getTagValue((Node)fnode, (String)"type");
                this.fieldFormat[i] = XMLHandler.getTagValue((Node)fnode, (String)"format");
                this.fieldGroup[i] = XMLHandler.getTagValue((Node)fnode, (String)"group");
                this.fieldDecimal[i] = XMLHandler.getTagValue((Node)fnode, (String)"decimal");
                this.fieldCurrency[i] = XMLHandler.getTagValue((Node)fnode, (String)"currency");
                String slen = XMLHandler.getTagValue((Node)fnode, (String)"length");
                String sprc = XMLHandler.getTagValue((Node)fnode, (String)"precision");
                this.fieldNullIf[i] = XMLHandler.getTagValue((Node)fnode, (String)"nullif");
                this.fieldIfNull[i] = XMLHandler.getTagValue((Node)fnode, (String)"ifnull");
                String trim = XMLHandler.getTagValue((Node)fnode, (String)"trimtype");
                this.fieldRemoveID[i] = "Y".equalsIgnoreCase(sidrem);
                this.fieldType[i] = ValueMeta.getType((String)stype);
                this.fieldLength[i] = Const.toInt((String)slen, (int)-1);
                this.fieldPrecision[i] = Const.toInt((String)sprc, (int)-1);
                this.fieldTrimType[i] = ValueMeta.getTrimTypeByCode((String)trim);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"FieldSplitterMeta.Exception.UnableToLoadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.splitField = "";
        this.delimiter = ",";
        this.enclosure = null;
        this.allocate(0);
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        int idx = r.indexOfValue(this.getSplitField());
        if (idx < 0) {
            throw new RuntimeException(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.CouldNotFindFieldToSplit", (String[])new String[]{this.getSplitField()}));
        }
        for (int i = 0; i < this.getFieldName().length; ++i) {
            try {
                ValueMetaInterface v = ValueMetaFactory.createValueMeta((String)this.getFieldName()[i], (int)this.getFieldType()[i]);
                v.setLength(this.getFieldLength()[i], this.getFieldPrecision()[i]);
                v.setOrigin(name);
                v.setConversionMask(this.getFieldFormat()[i]);
                v.setDecimalSymbol(this.getFieldDecimal()[i]);
                v.setGroupingSymbol(this.getFieldGroup()[i]);
                v.setCurrencySymbol(this.getFieldCurrency()[i]);
                v.setTrimType(this.getFieldTrimType()[i]);
                if (i == 0 && idx >= 0) {
                    r.setValueMeta(idx, v);
                    continue;
                }
                if (idx >= r.size()) {
                    r.addValueMeta(v);
                }
                r.addValueMeta(idx + i, v);
                continue;
            }
            catch (Exception e) {
                throw new KettleStepException((Throwable)e);
            }
        }
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(500);
        retval.append("   ").append(XMLHandler.addTagValue((String)"splitfield", (String)this.splitField));
        retval.append("   ").append(XMLHandler.addTagValue((String)"delimiter", (String)this.delimiter));
        retval.append("   ").append(XMLHandler.addTagValue((String)"enclosure", (String)this.enclosure));
        retval.append("    <fields>");
        for (int i = 0; i < this.fieldName.length; ++i) {
            retval.append("      <field>");
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"id", (String)this.fieldID[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"idrem", (boolean)this.fieldRemoveID[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)ValueMeta.getTypeDesc((int)this.fieldType[i])));
            retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)this.fieldFormat[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"group", (String)this.fieldGroup[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"decimal", (String)this.fieldDecimal[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"currency", (String)this.fieldCurrency[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)this.fieldLength[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)this.fieldPrecision[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"nullif", (String)this.fieldNullIf[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"ifnull", (String)this.fieldIfNull[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"trimtype", (String)ValueMeta.getTrimTypeCode((int)this.fieldTrimType[i])));
            retval.append("      </field>");
        }
        retval.append("    </fields>");
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.splitField = rep.getStepAttributeString(id_step, "splitfield");
            this.delimiter = rep.getStepAttributeString(id_step, "delimiter");
            this.enclosure = rep.getStepAttributeString(id_step, "enclosure");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.fieldID[i] = rep.getStepAttributeString(id_step, i, "field_id");
                this.fieldRemoveID[i] = rep.getStepAttributeBoolean(id_step, i, "field_idrem");
                this.fieldType[i] = ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "field_type"));
                this.fieldFormat[i] = rep.getStepAttributeString(id_step, i, "field_format");
                this.fieldGroup[i] = rep.getStepAttributeString(id_step, i, "field_group");
                this.fieldDecimal[i] = rep.getStepAttributeString(id_step, i, "field_decimal");
                this.fieldCurrency[i] = rep.getStepAttributeString(id_step, i, "field_currency");
                this.fieldLength[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_length");
                this.fieldPrecision[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_precision");
                this.fieldNullIf[i] = rep.getStepAttributeString(id_step, i, "field_nullif");
                this.fieldIfNull[i] = rep.getStepAttributeString(id_step, i, "field_ifnull");
                this.fieldTrimType[i] = ValueMeta.getTrimTypeByCode((String)rep.getStepAttributeString(id_step, i, "field_trimtype"));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"FieldSplitterMeta.Exception.UnexpectedErrorInReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "splitfield", this.splitField);
            rep.saveStepAttribute(id_transformation, id_step, "delimiter", this.delimiter);
            rep.saveStepAttribute(id_transformation, id_step, "enclosure", this.enclosure);
            for (int i = 0; i < this.fieldName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.fieldName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_id", this.fieldID[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_idrem", this.fieldRemoveID[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", ValueMeta.getTypeDesc((int)this.fieldType[i]));
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format", this.fieldFormat[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_group", this.fieldGroup[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_decimal", this.fieldDecimal[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_currency", this.fieldCurrency[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", this.fieldLength[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", this.fieldPrecision[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_nullif", this.fieldNullIf[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_ifnull", this.fieldIfNull[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_trimtype", ValueMeta.getTrimTypeCode((int)this.fieldTrimType[i]));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"FieldSplitterMeta.Exception.UnalbeToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        String error_message = "";
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FieldSplitterMeta.CheckResult.StepReceivingFields", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            error_message = "";
            int i = prev.indexOfValue(this.splitField);
            if (i < 0) {
                error_message = BaseMessages.getString(PKG, (String)"FieldSplitterMeta.CheckResult.SplitedFieldNotPresentInInputStream", (String[])new String[]{this.splitField});
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FieldSplitterMeta.CheckResult.SplitedFieldFoundInInputStream", (String[])new String[]{this.splitField}), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            error_message = BaseMessages.getString(PKG, (String)"FieldSplitterMeta.CheckResult.CouldNotReadFieldsFromPreviousStep", (String[])new String[0]) + Const.CR;
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FieldSplitterMeta.CheckResult.StepReceivingInfoFromOtherStep", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"FieldSplitterMeta.CheckResult.NoInputReceivedFromOtherStep", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new FieldSplitter(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new FieldSplitterData();
    }

    @Override
    public StepMetaInjectionInterface getStepMetaInjectionInterface() {
        return new FieldSplitterMetaInjection(this);
    }
}

